/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.bigquery;

import com.dataiku.dip.connections.bigquery.builtin.QueryStatisticsProvider;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.BigQuery;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.Job;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.JobId;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.JobStatistics;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.JobStatus;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.TableResult;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

public class QueryResult
implements QueryStatisticsProvider {
    public final JobId jobId;
    public final TableResult tableResult;
    public final boolean allRowsFetched;
    private final BigQuery client;
    private Job job;

    QueryResult(BigQuery client, JobId jobId, TableResult tableResult, boolean allRowsFetched) {
        this(client, jobId, tableResult, allRowsFetched, null);
    }

    QueryResult(BigQuery client, JobId jobId, TableResult tableResult, boolean allRowsFetched, @Nullable Job job) {
        Preconditions.checkNotNull((Object)client);
        Preconditions.checkNotNull((Object)jobId);
        this.jobId = jobId;
        this.tableResult = tableResult;
        this.allRowsFetched = allRowsFetched;
        this.job = job;
        this.client = client;
    }

    public Job getJob() {
        if (this.job == null || !JobStatus.State.DONE.equals((Object)this.job.getStatus().getState())) {
            this.job = this.client.getJob(this.jobId, new BigQuery.JobOption[0]);
        }
        return this.job;
    }

    @Override
    public JobStatistics.QueryStatistics getQueryStatistics() {
        Job actualJob = this.getJob();
        return actualJob == null ? null : (JobStatistics.QueryStatistics)actualJob.getStatistics();
    }
}

