/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.endpoints.kafka;

import com.dataiku.dip.classpathfix.DKUDoubles;
import com.dataiku.dip.classpathfix.DKULongs;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.formats.avro.SchemaConverter;
import com.dataiku.dip.shaker.types.Boolean;
import com.dataiku.dip.shaker.types.Date;
import com.dataiku.dip.shaker.types.DateOnly;
import com.dataiku.dip.shaker.types.DatetimeNoTz;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaFormatDeserializer;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaFormatSerializer;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.commons.lang.StringUtils;

public class AvroKafkaFormat {
    private static Date dateMeaning = new Date();
    private static DateOnly dateOnlyMeaning = new DateOnly();
    private static DatetimeNoTz datetimeNoTzMeaning = new DatetimeNoTz();

    private static Schema getSubSchemaOfTypeBuiltByDSSIfNeeded(Schema fieldSchema) {
        if (fieldSchema.isUnion()) {
            for (Schema subSchema : fieldSchema.getTypes()) {
                if (subSchema.getType() == Schema.Type.NULL) continue;
                return subSchema;
            }
        }
        return fieldSchema;
    }

    private static Schema getSubSchemaOfTypeIfNeeded(Schema fieldSchema, Schema.Type expected) {
        if (fieldSchema.isUnion()) {
            for (Schema subSchema : fieldSchema.getTypes()) {
                if (subSchema.getType() != expected) continue;
                return subSchema;
            }
        }
        return fieldSchema;
    }

    public static class AvroKafkaFormatSerializer
    implements KafkaFormatSerializer {
        private final AvroKafkaFormatParams params;
        private List<SchemaColumn> columns;
        private Schema avroSchema;
        private ColumnFactory cf;
        private Boolean booleanMeaning = new Boolean();

        public AvroKafkaFormatSerializer(AvroKafkaFormatParams params) {
            this.params = params;
        }

        @Override
        public void init(ColumnFactory cf, com.dataiku.dip.coremodel.Schema schema) {
            this.cf = cf;
            this.columns = this.params.getSchemaColumns(schema);
            com.dataiku.dip.coremodel.Schema subSchema = new com.dataiku.dip.coremodel.Schema(this.columns, false);
            this.avroSchema = SchemaConverter.convertSchema(subSchema, SchemaConverter.AvroFlavor.HIVE);
        }

        @Override
        public String getKafkaSerializer() {
            return "io.confluent.kafka.serializers.KafkaAvroSerializer";
        }

        Schema getAvroSchema() {
            return this.avroSchema;
        }

        @Override
        public Object serialize(Row row) throws IOException {
            GenericRecordBuilder recordBuilder = new GenericRecordBuilder(this.avroSchema);
            for (SchemaColumn column : this.columns) {
                String v = row.get(this.cf.column(column.getName()));
                Schema.Field field = this.avroSchema.getField(column.getName());
                try {
                    Object converted = this.serializeValue(column, field.schema(), (JsonElement)(StringUtils.isEmpty((String)v) ? JsonNull.INSTANCE : new JsonPrimitive(v)));
                    if (converted == null) {
                        recordBuilder.clear(field);
                        continue;
                    }
                    recordBuilder.set(field, converted);
                }
                catch (Exception e) {
                    throw new IOException("Failed to serialize value of column " + column.getName(), e);
                }
            }
            return recordBuilder.build();
        }

        private Object serializeValue(SchemaColumn column, Schema fieldSchema, JsonElement value) {
            if (value == null || value.isJsonNull()) {
                return null;
            }
            fieldSchema = AvroKafkaFormat.getSubSchemaOfTypeBuiltByDSSIfNeeded(fieldSchema);
            Object converted = null;
            Type columType = column.getType();
            switch (columType) {
                case TINYINT: 
                case SMALLINT: 
                case INT: 
                case BIGINT: {
                    converted = value.isJsonPrimitive() && value.getAsJsonPrimitive().isNumber() ? Long.valueOf(value.getAsLong()) : DKULongs.tryParse((String)value.getAsString());
                    if (converted == null) break;
                    if (columType == Type.INT) {
                        converted = ((Long)converted).intValue();
                        break;
                    }
                    if (columType == Type.SMALLINT) {
                        converted = ((Long)converted).shortValue();
                        break;
                    }
                    if (columType != Type.TINYINT) break;
                    converted = ((Long)converted).byteValue();
                    break;
                }
                case FLOAT: 
                case DOUBLE: {
                    converted = value.isJsonPrimitive() && value.getAsJsonPrimitive().isNumber() ? Double.valueOf(value.getAsDouble()) : DKUDoubles.tryParse((String)value.getAsString());
                    if (converted == null || columType != Type.FLOAT) break;
                    converted = Float.valueOf(((Double)converted).floatValue());
                    break;
                }
                case BOOLEAN: {
                    if (value.isJsonPrimitive() && value.getAsJsonPrimitive().isNumber()) {
                        converted = value.getAsBoolean();
                        break;
                    }
                    converted = this.booleanMeaning.parseNoFail(value.getAsString());
                    break;
                }
                case DATE: {
                    converted = dateMeaning.msSinceEpoch(value.getAsString());
                    break;
                }
                case DATEONLY: {
                    converted = (int)(dateOnlyMeaning.msSinceEpoch(value.getAsString()) / 86400000L);
                    break;
                }
                case DATETIMENOTZ: {
                    converted = datetimeNoTzMeaning.msSinceEpoch(value.getAsString());
                    break;
                }
                case STRING: 
                case GEOMETRY: 
                case GEOPOINT: {
                    converted = value.getAsString();
                    break;
                }
                case ARRAY: {
                    converted = value.isJsonArray() ? value.getAsJsonArray() : JSON.parse((String)value.getAsString(), JsonArray.class);
                    Schema arraySchema = fieldSchema.getType() == Schema.Type.ARRAY ? fieldSchema.getElementType() : fieldSchema;
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (JsonElement x : (JsonArray)converted) {
                        values.add(this.serializeValue(column.arrayContent, arraySchema, x));
                    }
                    converted = values;
                    break;
                }
                case MAP: {
                    converted = value.isJsonObject() ? value.getAsJsonObject() : JSON.parse((String)value.getAsString(), JsonObject.class);
                    Schema valueSchema = fieldSchema.getType() == Schema.Type.MAP ? fieldSchema.getValueType() : fieldSchema;
                    HashMap<String, Object> values = new HashMap<String, Object>();
                    for (Map.Entry e : ((JsonObject)converted).entrySet()) {
                        values.put((String)e.getKey(), this.serializeValue(column.mapValues, valueSchema, (JsonElement)e.getValue()));
                    }
                    converted = values;
                    break;
                }
                case OBJECT: {
                    converted = value.isJsonObject() ? value.getAsJsonObject() : JSON.parse((String)value.getAsString(), JsonObject.class);
                    GenericRecordBuilder recordBuilder = new GenericRecordBuilder(fieldSchema);
                    for (SchemaColumn fieldColumn : column.objectFields) {
                        JsonElement v = ((JsonObject)converted).get(fieldColumn.getName());
                        Schema.Field field = fieldSchema.getField(fieldColumn.getName());
                        Object fieldValue = this.serializeValue(fieldColumn, field.schema(), v);
                        if (fieldValue == null) {
                            recordBuilder.clear(field);
                            continue;
                        }
                        recordBuilder.set(field, fieldValue);
                    }
                    converted = recordBuilder.build();
                    break;
                }
            }
            return converted;
        }

        @Override
        public List<String> columnNamesForSchema(com.dataiku.dip.coremodel.Schema schema) {
            return this.params.columnNamesForSchema(schema);
        }

        @Override
        public List<SchemaColumn> getSchemaColumns(com.dataiku.dip.coremodel.Schema schema) {
            return this.params.getSchemaColumns(schema);
        }
    }

    public static class AvroKafkaFormatDeserializer
    implements KafkaFormatDeserializer {
        private final AvroKafkaFormatParams params;
        private List<SchemaColumn> columns;
        private ColumnFactory cf;

        public AvroKafkaFormatDeserializer(AvroKafkaFormatParams params) {
            this.params = params;
        }

        @Override
        public void init(ColumnFactory cf, RowFactory rf, com.dataiku.dip.coremodel.Schema schema) {
            this.cf = cf;
            this.columns = schema == null || schema.getColumns().isEmpty() ? Lists.newArrayList() : this.params.getSchemaColumns(schema);
        }

        @Override
        public String getKafkaDeserializer() {
            return "io.confluent.kafka.serializers.KafkaAvroDeserializer";
        }

        @Override
        public void deserialize(Object v, Row row) throws IOException {
            if (v == null) {
                return;
            }
            if (!(v instanceof GenericRecord)) {
                throw new UnsupportedOperationException("Expected a GenericRecord, got " + (v == null ? "null" : v.getClass().getCanonicalName()));
            }
            GenericRecord record = (GenericRecord)v;
            GenericData genericData = new GenericData();
            Schema recordSchema = record.getSchema();
            if (this.columns.isEmpty()) {
                for (Schema.Field field : recordSchema.getFields()) {
                    this.extractField(row, record, field, null, genericData);
                }
            } else {
                for (SchemaColumn sc : this.columns) {
                    Schema.Field field = recordSchema.getField(sc.getName());
                    if (field == null) continue;
                    this.extractField(row, record, field, sc, genericData);
                }
            }
        }

        private void extractField(Row row, GenericRecord record, Schema.Field field, SchemaColumn sc, GenericData genericData) throws IOException {
            try {
                Object fieldValue = genericData.getField((Object)record, field.name(), field.pos());
                JsonElement jsonValue = this.extractFieldValue(fieldValue, field.schema(), sc);
                if (jsonValue instanceof JsonPrimitive) {
                    row.put(this.cf.column(field.name()), ((JsonPrimitive)jsonValue).getAsString());
                } else {
                    row.put(this.cf.column(field.name()), jsonValue.toString());
                }
            }
            catch (Exception e) {
                throw new IOException("Cannot deserialize avro value for column " + field.name(), e);
            }
        }

        private void extractField(JsonObject row, GenericRecord record, Schema.Field field, SchemaColumn sc, GenericData genericData) throws IOException {
            try {
                Object fieldValue = genericData.getField((Object)record, field.name(), field.pos());
                JsonElement jsonValue = this.extractFieldValue(fieldValue, field.schema(), sc);
                row.add(field.name(), jsonValue);
            }
            catch (Exception e) {
                throw new IOException("Cannot deserialize avro value for column " + field.name(), e);
            }
        }

        private JsonElement extractFieldValue(Object fieldValue, Schema fieldSchema, SchemaColumn sc) throws IOException {
            if (fieldValue == null) {
                return JsonNull.INSTANCE;
            }
            if (fieldValue instanceof GenericRecord) {
                return this.extractStructFieldValue((GenericRecord)fieldValue, sc);
            }
            if (fieldValue instanceof String) {
                return new JsonPrimitive((String)fieldValue);
            }
            if (fieldValue instanceof java.lang.Boolean) {
                return new JsonPrimitive((java.lang.Boolean)fieldValue);
            }
            if (fieldValue instanceof Number) {
                return AvroKafkaFormatDeserializer.extractNumberFieldValue((Number)fieldValue, fieldSchema, sc);
            }
            if (fieldValue instanceof Map) {
                return this.extractMapFieldValue((Map)fieldValue, fieldSchema, sc);
            }
            if (fieldValue instanceof Collection) {
                return this.extractListFieldValue((Collection)fieldValue, fieldSchema, sc);
            }
            return new JsonPrimitive(fieldValue.toString());
        }

        private JsonArray extractListFieldValue(Collection<?> fieldValue, Schema fieldSchema, SchemaColumn sc) throws IOException {
            Collection<?> collection = fieldValue;
            Schema arraySchema = (fieldSchema = AvroKafkaFormat.getSubSchemaOfTypeIfNeeded(fieldSchema, Schema.Type.ARRAY)).getType() == Schema.Type.ARRAY ? fieldSchema.getElementType() : fieldSchema;
            JsonArray unwrapped = new JsonArray();
            for (Object x : collection) {
                unwrapped.add(this.extractFieldValue(x, arraySchema, sc == null ? null : sc.arrayContent));
            }
            return unwrapped;
        }

        private JsonObject extractMapFieldValue(Map<Object, ?> fieldValue, Schema fieldSchema, SchemaColumn sc) throws IOException {
            Map<Object, ?> map = fieldValue;
            Schema valueSchema = (fieldSchema = AvroKafkaFormat.getSubSchemaOfTypeIfNeeded(fieldSchema, Schema.Type.MAP)).getType() == Schema.Type.MAP ? fieldSchema.getValueType() : fieldSchema;
            JsonObject unwrapped = new JsonObject();
            for (Map.Entry<Object, ?> e : map.entrySet()) {
                String n = e.getKey().toString();
                unwrapped.add(n, this.extractFieldValue(e.getValue(), valueSchema, sc == null ? null : sc.mapValues));
            }
            return unwrapped;
        }

        private static JsonPrimitive extractNumberFieldValue(Number fieldValue, Schema fieldSchema, SchemaColumn sc) {
            if ((fieldSchema = AvroKafkaFormat.getSubSchemaOfTypeBuiltByDSSIfNeeded(fieldSchema)).getType() == Schema.Type.INT && fieldSchema.getLogicalType() != null && "date".equalsIgnoreCase(fieldSchema.getLogicalType().getName())) {
                return AvroKafkaFormatDeserializer.dateOnlyFromNumber(fieldValue);
            }
            if (fieldSchema.getType() == Schema.Type.LONG && fieldSchema.getLogicalType() != null && "timestamp-millis".equalsIgnoreCase(fieldSchema.getLogicalType().getName())) {
                return AvroKafkaFormatDeserializer.dateFromNumber(fieldValue);
            }
            if (fieldSchema.getType() == Schema.Type.LONG && fieldSchema.getLogicalType() != null && "timestamp-micros".equalsIgnoreCase(fieldSchema.getLogicalType().getName())) {
                return AvroKafkaFormatDeserializer.dateFromNumber(fieldValue.longValue() / 1000L);
            }
            if (fieldSchema.getType() == Schema.Type.LONG && fieldSchema.getLogicalType() != null && "local-timestamp-millis".equalsIgnoreCase(fieldSchema.getLogicalType().getName())) {
                return AvroKafkaFormatDeserializer.datetimeNoTzFromNumber(fieldValue);
            }
            if (fieldSchema.getType() == Schema.Type.LONG && fieldSchema.getLogicalType() != null && "local-timestamp-micros".equalsIgnoreCase(fieldSchema.getLogicalType().getName())) {
                return AvroKafkaFormatDeserializer.datetimeNoTzFromNumber(fieldValue.longValue() / 1000L);
            }
            if (sc != null && sc.getType() == Type.DATE) {
                return AvroKafkaFormatDeserializer.dateFromNumber(fieldValue);
            }
            if (sc != null && sc.getType() == Type.DATEONLY) {
                return AvroKafkaFormatDeserializer.dateOnlyFromNumber(fieldValue);
            }
            if (sc != null && sc.getType() == Type.DATETIMENOTZ) {
                return AvroKafkaFormatDeserializer.datetimeNoTzFromNumber(fieldValue);
            }
            return new JsonPrimitive(fieldValue);
        }

        private JsonObject extractStructFieldValue(GenericRecord fieldValue, SchemaColumn sc) throws IOException {
            GenericRecord record = fieldValue;
            Schema recordSchema = record.getSchema();
            GenericData genericData = new GenericData();
            List recordColumns = sc == null ? null : sc.objectFields;
            JsonObject subRow = new JsonObject();
            if (recordColumns == null || recordColumns.isEmpty()) {
                for (Schema.Field field : recordSchema.getFields()) {
                    this.extractField(subRow, record, field, null, genericData);
                }
            } else {
                for (SchemaColumn sub : recordColumns) {
                    Schema.Field field = recordSchema.getField(sub.getName());
                    if (field == null) continue;
                    this.extractField(subRow, record, field, sub, genericData);
                }
            }
            return subRow;
        }

        private static JsonPrimitive datetimeNoTzFromNumber(Number fieldValue) {
            long ts = fieldValue.longValue();
            return new JsonPrimitive(DatetimeNoTz.CANONICAL_FORMATTER.print(ts));
        }

        private static JsonPrimitive dateFromNumber(Number fieldValue) {
            long ts = fieldValue.longValue();
            return new JsonPrimitive(Date.CANONICAL_FORMATTER.print(ts) + "Z");
        }

        private static JsonPrimitive dateOnlyFromNumber(Number fieldValue) {
            int epochDays = fieldValue.intValue();
            LocalDate date = LocalDate.ofEpochDay(epochDays);
            DateTime dateTime = new DateTime(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), 0, 0, 0, DateTimeZone.UTC);
            return new JsonPrimitive(Date.CANONICAL_FORMATTER.print((ReadableInstant)dateTime).substring(0, 10));
        }

        @Override
        public List<String> columnNamesForSchema(com.dataiku.dip.coremodel.Schema schema) {
            return this.params.columnNamesForSchema(schema);
        }

        @Override
        public com.dataiku.dip.coremodel.Schema fetchSchema(Properties props, String topic, boolean isKey) throws Exception {
            String url = props.getProperty("schema.registry.url");
            if (StringUtils.isBlank((String)url)) {
                throw new Exception("Schema registry not set, can't query");
            }
            CachedSchemaRegistryClient client = new CachedSchemaRegistryClient(url, 10);
            SchemaMetadata metadata = client.getLatestSchemaMetadata(String.format("%s-%s", topic, isKey ? "key" : "value"));
            Schema avroSchema = new Schema.Parser().parse(metadata.getSchema());
            return SchemaConverter.convertSchema(avroSchema);
        }

        @Override
        public List<SchemaColumn> getSchemaColumns(com.dataiku.dip.coremodel.Schema schema) {
            return this.params.getSchemaColumns(schema);
        }
    }

    public static class AvroKafkaFormatParams {
        public List<String> columnNames = Lists.newArrayList();

        private List<SchemaColumn> getSchemaColumns(com.dataiku.dip.coremodel.Schema schema) {
            if (this.columnNames == null || this.columnNames.isEmpty()) {
                return Lists.newArrayList((Iterable)schema.getColumns());
            }
            ArrayList ret = Lists.newArrayList();
            for (String columnName : this.columnNames) {
                SchemaColumn sc = schema.getColumn(columnName);
                if (sc == null) continue;
                ret.add(sc);
            }
            return ret;
        }

        public Schema getAvroSchema(com.dataiku.dip.coremodel.Schema schema) {
            List<SchemaColumn> columns = this.getSchemaColumns(schema);
            com.dataiku.dip.coremodel.Schema subSchema = new com.dataiku.dip.coremodel.Schema(columns, false);
            return SchemaConverter.convertSchema(subSchema, SchemaConverter.AvroFlavor.HIVE);
        }

        private List<String> columnNamesForSchema(com.dataiku.dip.coremodel.Schema schema) {
            if (this.columnNames == null || this.columnNames.isEmpty()) {
                ArrayList ret = Lists.newArrayList();
                for (SchemaColumn sc : schema.getColumns()) {
                    ret.add(sc.getName());
                }
                return ret;
            }
            return Lists.newArrayList(this.columnNames);
        }
    }
}

