/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.unifiedmonitoring;

import com.dataiku.common.rpc.APIKeyAuthAPIClient;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.apideployer.DeployerUtils;
import com.dataiku.dip.apideployer.datamodel.actual.InfraLightStatus;
import com.dataiku.dip.apideployer.datamodel.config.AbstractProjectDeploymentInfra;
import com.dataiku.dip.apideployer.infra.AbstractAutomationNodeInfraManager;
import com.dataiku.dip.apideployer.infra.AutomationNodeInfrasService;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.directory.NodeConnection;
import com.dataiku.dip.directory.NodesDirectory;
import com.dataiku.dip.directory.NodesDirectoryService;
import com.dataiku.dip.nodeclients.AutomationNodeClient;
import com.dataiku.dip.nodeclients.DesignNodeClient;
import com.dataiku.dip.nodeclients.IUnifiedMonitoringClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.NodesService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.unifiedmonitoring.LocalDesignNode;
import com.dataiku.dip.unifiedmonitoring.settings.SourceNodeWithLocalInfo;
import com.dataiku.dip.utils.DKULogger;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class UnifiedMonitoringRemoteNodesManager
implements AutoCloseable {
    private final NodesDirectoryService nodesDirectoryService;
    private final NodesService nodesService;
    private final PasswordEncryptionService passwordEncryptionService;
    private final TransactionService transactionService;
    private final AutomationNodeInfrasService automationNodeInfrasService;
    private final Set<SourceNodeWithLocalInfoAndClient> nodes = new LinkedHashSet<SourceNodeWithLocalInfoAndClient>();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.unifiedmonitoring.remotenodesmanager");

    UnifiedMonitoringRemoteNodesManager(AuthCtx user, boolean includeAutomationNodes) throws Exception {
        APIKeyAuthAPIClient client;
        this.nodesDirectoryService = (NodesDirectoryService)SpringUtils.getBean(NodesDirectoryService.class);
        this.nodesService = (NodesService)SpringUtils.getBean(NodesService.class);
        this.passwordEncryptionService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
        this.transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
        this.automationNodeInfrasService = (AutomationNodeInfrasService)SpringUtils.getBean(AutomationNodeInfrasService.class);
        GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        if (this.nodesService.hasLocalDeployer()) {
            SourceNodeWithLocalInfoAndClient localDesignNode = new SourceNodeWithLocalInfoAndClient(DKUApp.getNodeId(), gs.studioExternalUrl, new LocalDesignNode(user));
            this.nodes.add(localDesignNode);
        }
        NodesDirectory nd = this.nodesDirectoryService.getNodesDirectoryUnsafe_AutoTXN();
        if (nd.enabled) {
            for (NodesDirectory.NodeRef node : nd.nodes) {
                if (node.nodeType != NodesDirectory.NodeType.DSS_DESIGN || Objects.equals(node.nodeId, DKUApp.getNodeId())) continue;
                if (!Objects.equals(node.status, NodesDirectory.NodeStatus.RUNNING) && !Objects.equals(node.status, NodesDirectory.NodeStatus.NOT_RESPONDING)) {
                    logger.infoV("The design node %s is not reachable (status: %s). It will not be in the unified monitoring remote node manager.", new Object[]{node.nodeId, node.status});
                    continue;
                }
                GeneralSettingsDAO.RemoteDesignNodeCreds creds = new GeneralSettingsDAO.RemoteDesignNodeCreds(node.url, node.adminAPIKey);
                creds.decryptFields(this.passwordEncryptionService);
                try {
                    DesignNodeClient client2 = new DesignNodeClient(creds, null, DeployerUtils.getUnifiedMonitoringConnectTimeout(), DeployerUtils.getUnifiedMonitoringSocketTimeout());
                    this.nodes.add(new SourceNodeWithLocalInfoAndClient(node.nodeId, node.url, client2));
                }
                catch (Exception e) {
                    logger.warnV((Throwable)e, "Could not reach external design node with id %s at url %s", new Object[]{node.nodeId, creds.url});
                }
            }
        } else {
            GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
            for (GeneralSettingsDAO.RemoteDesignNodeCreds creds : generalSettings.remoteDesignNodeCreds) {
                creds.decryptFields(this.passwordEncryptionService);
                Object nodeId = "unknown";
                try {
                    client = new DesignNodeClient(creds, null, DeployerUtils.getUnifiedMonitoringConnectTimeout(), DeployerUtils.getUnifiedMonitoringSocketTimeout());
                    nodeId = client.getNodeId();
                    this.nodes.add(new SourceNodeWithLocalInfoAndClient((String)nodeId, creds.url, (IUnifiedMonitoringClient)client));
                }
                catch (Exception e) {
                    logger.warnV((Throwable)e, "Could not reach external design node with id %s at url %s", new Object[]{nodeId, creds.url});
                }
            }
        }
        if (includeAutomationNodes) {
            ArrayList<NodeConnection> allAutomationNodeCreds = new ArrayList<NodeConnection>();
            try (Transaction t = this.transactionService.beginRead();){
                List<InfraLightStatus> infras = this.automationNodeInfrasService.listLightStatusUnsafe_Check(user);
                for (InfraLightStatus infraStatus : infras) {
                    try {
                        AbstractProjectDeploymentInfra infra = this.automationNodeInfrasService.getAutomationNodeInfra_CheckRead(user, infraStatus.getInfraBasicInfo().getId());
                        AbstractAutomationNodeInfraManager infraManager = infra.getInfraManager(user, DeployerUtils.getUnifiedMonitoringConnectTimeout(), DeployerUtils.getUnifiedMonitoringSocketTimeout());
                        allAutomationNodeCreds.addAll(infraManager.getNodeConnections());
                    }
                    catch (Exception e) {
                        logger.warnV((Throwable)e, "Failed to retrieve the automation node infrastructure of %s", new Object[]{infraStatus.getInfraBasicInfo().getId()});
                    }
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to retrieve the automation node connection credentials ", (Throwable)e);
            }
            for (NodeConnection nodeConnection : allAutomationNodeCreds) {
                try {
                    client = AutomationNodeClient.automationNodeClient(nodeConnection, null, DeployerUtils.getUnifiedMonitoringConnectTimeout(), DeployerUtils.getUnifiedMonitoringSocketTimeout());
                    String nodeId = client.getNodeId();
                    SourceNodeWithLocalInfoAndClient nodeIdOrUrlAndNodeClient = new SourceNodeWithLocalInfoAndClient(nodeId, nodeConnection.url, (IUnifiedMonitoringClient)client);
                    this.nodes.add(nodeIdOrUrlAndNodeClient);
                }
                catch (Exception e) {
                    logger.warnV((Throwable)e, "Could not reach automation node at url %s", new Object[]{nodeConnection.url});
                }
            }
        }
    }

    @Nullable
    public IUnifiedMonitoringClient getSourceNodeClientOrNull(SourceNodeWithLocalInfo sourceNode) {
        for (SourceNodeWithLocalInfoAndClient sourceNodeWithClient : this.nodes) {
            if (!(sourceNode.nodeId != null ? StringUtils.equals((String)sourceNode.nodeId, (String)sourceNodeWithClient.nodeId) : StringUtils.equals((String)sourceNode.url, (String)sourceNodeWithClient.nodeUrl))) continue;
            return sourceNodeWithClient.nodeClient;
        }
        logger.warnV("Cannot find a suitable client for the node id %s", new Object[]{sourceNode.nodeId});
        return null;
    }

    public Set<SourceNodeWithLocalInfoAndClient> listNodes() {
        return this.nodes;
    }

    public boolean hasNodes() {
        return !this.nodes.isEmpty();
    }

    @Override
    public void close() throws Exception {
        for (SourceNodeWithLocalInfoAndClient sourceNode : this.nodes) {
            IUnifiedMonitoringClient sourceNodeClient = sourceNode.nodeClient;
            try {
                if (sourceNodeClient == null) continue;
                sourceNodeClient.close();
            }
            catch (Exception e) {
                logger.warnV((Throwable)e, "Failed to close the source node client: %s", new Object[]{sourceNode.toString()});
            }
        }
    }

    public static class SourceNodeWithLocalInfoAndClient {
        public final String nodeId;
        public final String nodeUrl;
        @Nonnull
        final IUnifiedMonitoringClient nodeClient;

        public SourceNodeWithLocalInfoAndClient(String nodeId, String nodeUrl, @Nonnull IUnifiedMonitoringClient nodeClient) {
            this.nodeId = nodeId;
            this.nodeUrl = nodeUrl;
            this.nodeClient = nodeClient;
        }

        public String toString() {
            return "SourceNodeWithLocalInfoAndClient{nodeId='" + this.nodeId + "', nodeUrl='" + this.nodeUrl + "'}";
        }

        public SourceNodeWithLocalInfo toNodeInfo() {
            return new SourceNodeWithLocalInfo(this.nodeId, this.nodeUrl);
        }
    }
}

