/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.variables;

import com.dataiku.dip.remoterun.RemoteRunEnvHelper;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.variables.VariableExpansionFilterParser;
import com.dataiku.dip.variables.VariablesContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrLookup;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.log4j.Logger;

public class HierarchicalVariablesContext
implements VariablesContext {
    private Map<String, String> explicitlyAdded = new HashMap<String, String>();
    private List<JsonObject> levels = new ArrayList<JsonObject>();
    private static Logger logger = Logger.getLogger((String)"dku.variables");

    public void addLevel(JsonObject obj) {
        this.levels.add(obj);
    }

    public HierarchicalVariablesContext withLevel(JsonObject obj) {
        this.addLevel(obj);
        return this;
    }

    public boolean has(String variable) {
        String val;
        if (this.explicitlyAdded.containsKey(variable)) {
            return true;
        }
        if (variable.startsWith("env:") && (val = RemoteRunEnvHelper.getEnv(StringUtils.replaceOnce((String)variable, (String)"env:", (String)""))) != null) {
            return true;
        }
        for (int i = this.levels.size() - 1; i >= 0; --i) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Lookup in level " + String.valueOf(this.levels.get(i))));
            }
            if (!this.levels.get(i).has(variable)) continue;
            return true;
        }
        return false;
    }

    public JsonElement lookup(String variable) {
        return this._lookup(variable, false);
    }

    private JsonElement _lookup(String variable, boolean allowUnresolved) {
        String val;
        if (this.explicitlyAdded.containsKey(variable)) {
            String v = this.explicitlyAdded.get(variable);
            return v == null ? JsonNull.INSTANCE : new JsonPrimitive(v);
        }
        if (variable.startsWith("env:") && (val = RemoteRunEnvHelper.getEnv(StringUtils.replaceOnce((String)variable, (String)"env:", (String)""))) != null) {
            return new JsonPrimitive(val);
        }
        for (int i = this.levels.size() - 1; i >= 0; --i) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Lookup in level " + String.valueOf(this.levels.get(i))));
            }
            if (!this.levels.get(i).has(variable)) continue;
            return this.levels.get(i).get(variable);
        }
        if (!allowUnresolved) {
            throw ErrorContext.iae((String)("Unknown DSS variable: " + variable));
        }
        return null;
    }

    private String getSubstituted(final String expr, final boolean allowUnresolved, final boolean emptyIfUnresolved) {
        StrSubstitutor subs = new StrSubstitutor(new StrLookup(){

            public String lookup(String s) {
                if (StringUtils.isEmpty((String)s)) {
                    throw new IllegalArgumentException("Error during variable expansion filter, expression '" + expr + "' is malformed (empty expression as variable)");
                }
                VariableExpansionFilterParser.VariableExpansionChain ve = VariableExpansionFilterParser.parse(s);
                try {
                    JsonElement ret = HierarchicalVariablesContext.this._lookup(ve.headVariable, ve.headOptional);
                    String filtered = ve.apply(ret);
                    return filtered == null ? "" : filtered;
                }
                catch (IllegalArgumentException e) {
                    if (allowUnresolved) {
                        return emptyIfUnresolved ? "" : "__UNSUB_" + s + "_UNSUB__";
                    }
                    throw e;
                }
            }
        });
        return subs.replace(expr).replace("__UNSUB_", "${").replace("_UNSUB__", "}");
    }

    public String getAsString(String expr) {
        return this.getSubstituted(expr, false, false);
    }

    public String expand(@Nullable String str) {
        if (str == null) {
            return null;
        }
        String ret = this.getSubstituted(str, false, false);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Variable expand " + str + " -> " + ret));
        }
        return ret;
    }

    public String expandAllowUnresolved(String str) {
        if (str == null) {
            return null;
        }
        String ret = this.getSubstituted(str, true, false);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Variable expand " + str + " -> " + ret));
        }
        return ret;
    }

    public String expandEmptyIfUnresolved(String str) {
        String ret = this.getSubstituted(str, true, true);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Variable expand " + str + " -> " + ret));
        }
        return ret;
    }

    public int getAsInt(String expr) {
        String substituted = this.getSubstituted(expr, false, false);
        try {
            return Integer.parseInt(this.getSubstituted(expr, false, false));
        }
        catch (NumberFormatException e) {
            throw ErrorContext.iaef((String)"Illegal variable substitution: variable '%s' value: '%s' is not an integer", (Object)expr, (Object[])new Object[]{substituted});
        }
    }

    public double getAsDouble(String expr) {
        String substituted = this.getSubstituted(expr, false, false);
        try {
            return Double.parseDouble(this.getSubstituted(expr, false, false));
        }
        catch (NumberFormatException e) {
            throw ErrorContext.iaef((String)"Illegal variable substitution: variable '%s' value: '%s' is not a double", (Object)expr, (Object[])new Object[]{substituted});
        }
    }

    public boolean getAsBoolean(String expr) {
        String substituted = this.getSubstituted(expr, false, false);
        try {
            return Boolean.parseBoolean(this.getSubstituted(expr, false, false));
        }
        catch (NumberFormatException e) {
            throw ErrorContext.iaef((String)"Illegal variable substitution: variable '%s' value: '%s' is not a boolean", (Object)expr, (Object[])new Object[]{substituted});
        }
    }

    public Map<String, String> getAllVariables() {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (JsonObject obj : this.levels) {
            for (Map.Entry elt : obj.entrySet()) {
                String v = null;
                v = ((JsonElement)elt.getValue()).isJsonPrimitive() && ((JsonElement)elt.getValue()).getAsJsonPrimitive().isString() ? ((JsonElement)elt.getValue()).getAsJsonPrimitive().getAsString() : ((JsonElement)elt.getValue()).toString();
                ret.put((String)elt.getKey(), v);
            }
        }
        return ret;
    }

    public JsonObject getAllVariablesTyped() {
        JsonObject ret = new JsonObject();
        for (JsonObject obj : this.levels) {
            for (Map.Entry elt : obj.entrySet()) {
                ret.add((String)elt.getKey(), (JsonElement)elt.getValue());
            }
        }
        return ret;
    }

    public void add(String key, String value) {
        this.explicitlyAdded.put(key, value);
    }

    public HierarchicalVariablesContext with(String key, String value) {
        this.add(key, value);
        return this;
    }
}

