/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.variables;

import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.HierarchicalVariablesContext;
import com.dataiku.dip.variables.VariablesContext;
import com.google.gson.JsonObject;
import java.io.IOException;
import javax.annotation.Nonnull;

public abstract class VariablesService {
    public static final String VARIABLES_JSON_FILENAME = "variables.json";
    public static final String LOCAL_VARIABLES_JSON_FILENAME = "localvariables.json";

    public abstract VariablesContext getContext(String var1);

    public abstract VariablesContext getContextAndUserLogin(String var1, AuthCtx var2);

    public abstract VariablesContext getGlobalContext();

    public abstract VariablesContext getGlobalContextAndUserLogin(AuthCtx var1);

    public abstract VariablesContext getForConnection(DSSConnection var1, AuthCtx var2);

    public abstract VariablesContext getForConnectionAndProject(DSSConnection var1, AuthCtx var2, String var3);

    protected static void addLevel(HierarchicalVariablesContext hvc, TransactionRef t, String path) throws IOException {
        if (t.exists(path)) {
            hvc.addLevel((JsonObject)t.readObjectUnsafe(path, JsonObject.class));
        }
    }

    public abstract VariablesContext getForEverything(DSSConnection var1, AuthCtx var2, String var3);

    @Nonnull
    public static ProjectVariables readLocalUnresolvedProjectVariables(String projectKey, Transaction t) throws IOException {
        ProjectVariables pv = new ProjectVariables();
        pv.standard = (JsonObject)t.readObjectDefault(new RelFile(new String[]{"projects", projectKey, VARIABLES_JSON_FILENAME}), JsonObject.class);
        pv.local = (JsonObject)t.readObjectDefault(new RelFile(new String[]{"projects", projectKey, LOCAL_VARIABLES_JSON_FILENAME}), JsonObject.class);
        return pv;
    }

    public static ProjectVariablesWithComments readLocalUnresolvedProjectVariablesWithComments(String projectKey, Transaction t) throws IOException {
        ProjectVariablesWithComments pv = new ProjectVariablesWithComments();
        pv.standard = VariablesService.readStringUTF8ForJson5Default(new RelFile(new String[]{"projects", projectKey, VARIABLES_JSON_FILENAME}), t);
        pv.local = VariablesService.readStringUTF8ForJson5Default(new RelFile(new String[]{"projects", projectKey, LOCAL_VARIABLES_JSON_FILENAME}), t);
        return pv;
    }

    private static String readStringUTF8ForJson5Default(RelFile relFile, Transaction t) throws IOException {
        return t.isFile(relFile) ? t.readStringUTF8(relFile) : "{}";
    }

    public static void writeLocalProjectVariables(String projectKey, RWTransaction t, ProjectVariables pv, boolean commit) throws IOException {
        t.writeStringUTF8(new RelFile(new String[]{"projects", projectKey, VARIABLES_JSON_FILENAME}), JSON.prettyUnescapeHtml((Object)pv.standard));
        t.writeStringUTF8(new RelFile(new String[]{"projects", projectKey, LOCAL_VARIABLES_JSON_FILENAME}), JSON.prettyUnescapeHtml((Object)pv.local));
        if (commit) {
            t.commit("Saved project variables for project " + projectKey);
        }
    }

    public static void writeLocalProjectVariables(String projectKey, RWTransaction t, ProjectVariablesWithComments pv, boolean commit) throws IOException {
        t.writeStringUTF8(new RelFile(new String[]{"projects", projectKey, VARIABLES_JSON_FILENAME}), pv.standard);
        t.writeStringUTF8(new RelFile(new String[]{"projects", projectKey, LOCAL_VARIABLES_JSON_FILENAME}), pv.local);
        if (commit) {
            t.commit("Saved project variables for project " + projectKey);
        }
    }

    public static class ProjectVariables {
        public JsonObject standard = new JsonObject();
        public JsonObject local = new JsonObject();
    }

    public static class ProjectVariablesWithComments {
        public String standard = "{}";
        public String local = "{}";
    }
}

