/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSStartedEvent;
import com.dataiku.dip.code.CodeEnvPermissionsService;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.codestudio.object.CodeStudioObject;
import com.dataiku.dip.codestudio.template.CodeStudioTemplate;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.containers.exec.WorkloadType;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.cuspol.CustomFieldsService;
import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.dao.CodeStudioObjectsDAO;
import com.dataiku.dip.dao.CodeStudioTemplatesDAO;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.plugins.dev.DevPluginsService;
import com.dataiku.dip.recipes.MetaWithSelectableCodeEnv;
import com.dataiku.dip.recipes.ParamsWithSelectableCodeEnv;
import com.dataiku.dip.scheduler.runnables.StoppableWithTimeoutService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.AuthCtxCreationService;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.PublicAPIKey;
import com.dataiku.dip.security.trust.TrustInternalDB;
import com.dataiku.dip.security.trust.TrustedCodeService;
import com.dataiku.dip.server.api.auth.PublicAPIKeysService;
import com.dataiku.dip.server.notifications.backend.GeneralSettingsChangedEvent;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TaggingService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DKUExecutors;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.webapps.VirtualWebAppBackendSettings;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppHandler;
import com.dataiku.dip.webapps.WebAppMeta;
import com.dataiku.dip.webapps.WebAppRegistry;
import com.dataiku.dip.webapps.WebAppSecurityInfo;
import com.dataiku.dip.webapps.WebAppTemplateDesc;
import com.dataiku.dip.webapps.WebAppsDAO;
import com.dataiku.dip.webapps.WebAppsTemplatesService;
import com.dataiku.dip.webapps.backend.WebAppBackend;
import com.dataiku.dip.webapps.backend.WebAppBackendInstance;
import com.dataiku.dip.webapps.backend.WebAppBackendRestartThread;
import com.dataiku.dip.webapps.backend.WebAppBackendsManager;
import com.dataiku.dip.webapps.codestudio.CodeStudioWebAppMeta;
import com.dataiku.dip.webapps.plugins.CustomWebAppDesc;
import com.dataiku.dip.webapps.plugins.CustomWebAppMeta;
import com.dataiku.dip.webapps.proxy.ProxyWebAppMeta;
import com.dataiku.dip.webapps.standard.AbstractStandardWebAppHandler;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Service;

@Service
public class WebAppsService
implements ApplicationListener<DSSStartedEvent> {
    public static final String WEB_APP_TASK_PREFIX = "webApp:";
    private WebAppsDAO dao;
    private TaggingService taggingService;
    private CustomFieldsService customFieldsService;
    private PubSubService pubSub;
    private VariablesService variablesService;
    private ProjectsService projectsService;
    private TrustInternalDB trustInternalDB;
    private IPermissionsService permissionsService;
    private TransactionService transactionService;
    private CodeEnvPermissionsService codeEnvPermissionsService;
    private WebAppBackendsManager backendsManager;
    private WebAppsTemplatesService templatesService;
    private TaggableObjectsService taggableObjectsService;
    private CustomPolicyHooksRegistry customPolicyHooksRegistry;
    private DevPluginsService pluginDeveloperService;
    private FutureService futureService;
    private StoppableWithTimeoutService stoppableWithTimeoutService;
    private PublicAPIKeysService publicAPIKeysService;
    private TrustedCodeService trustedCodeService;
    private CodeStudioObjectsDAO codeStudioObjectsDAO;
    private CodeStudioTemplatesDAO codeStudioTemplatesDAO;
    private AuthCtxCreationService authCtxCreationService;
    private PasswordEncryptionService passwordEncryptionService;
    public Map<AnyLoc, WebApp> virtualWebApps = Maps.newHashMap();
    public Map<String, Set<WebApp>> virtualWebAppsByReuseKey = Maps.newHashMap();
    static DKULogger logger = DKULogger.getLogger((String)"dku.webapps.service");

    public static float getVirtualAliveMins() {
        return (float)ApplicationConfigurator.getParams().getDoubleParam("dku.virtual_webapps.alive.mins", 5.0);
    }

    @Autowired
    public WebAppsService(WebAppsDAO dao, TaggingService taggingService, CustomFieldsService customFieldsService, PubSubService pubSub, VariablesService variablesService, ProjectsService projectsService, TrustInternalDB trustInternalDB, IPermissionsService permissionsService, TransactionService transactionService, CodeEnvPermissionsService codeEnvPermissionsService, WebAppBackendsManager backendsManager, WebAppsTemplatesService templatesService, TaggableObjectsService taggableObjectsService, CustomPolicyHooksRegistry customPolicyHooksRegistry, DevPluginsService pluginDeveloperService, FutureService futureService, StoppableWithTimeoutService stoppableWithTimeoutService, PublicAPIKeysService publicAPIKeysService, TrustedCodeService trustedCodeService, CodeStudioObjectsDAO codeStudioObjectsDAO, CodeStudioTemplatesDAO codeStudioTemplatesDAO, AuthCtxCreationService authCtxCreationService, PasswordEncryptionService passwordEncryptionService) {
        this.dao = dao;
        this.taggingService = taggingService;
        this.customFieldsService = customFieldsService;
        this.pubSub = pubSub;
        this.variablesService = variablesService;
        this.projectsService = projectsService;
        this.trustInternalDB = trustInternalDB;
        this.permissionsService = permissionsService;
        this.transactionService = transactionService;
        this.codeEnvPermissionsService = codeEnvPermissionsService;
        this.backendsManager = backendsManager;
        this.templatesService = templatesService;
        this.taggableObjectsService = taggableObjectsService;
        this.customPolicyHooksRegistry = customPolicyHooksRegistry;
        this.pluginDeveloperService = pluginDeveloperService;
        this.futureService = futureService;
        this.stoppableWithTimeoutService = stoppableWithTimeoutService;
        this.publicAPIKeysService = publicAPIKeysService;
        this.trustedCodeService = trustedCodeService;
        this.codeStudioObjectsDAO = codeStudioObjectsDAO;
        this.codeStudioTemplatesDAO = codeStudioTemplatesDAO;
        this.authCtxCreationService = authCtxCreationService;
        this.passwordEncryptionService = passwordEncryptionService;
    }

    protected WebAppsService() {
    }

    public void reloadWebAppsIfNecessary(final AuthCtx authCtx, GeneralSettingsChangedEvent evt, InfoMessage.InfoMessages messages) {
        try {
            List<String> projects;
            final ArrayList<WebApp> toRestart = new ArrayList<WebApp>();
            try (Object t = this.transactionService.beginRead();){
                projects = this.projectsService.listKeys();
            }
            for (String projectKey : projects) {
                try {
                    Transaction t = this.transactionService.beginRead();
                    try {
                        if (!this.projectsService.projectExists(projectKey)) continue;
                        Set<String> registeredBackendIds = this.backendsManager.listRegisteredBackends(projectKey);
                        for (WebApp webApp : this.listUnsafe_noCode(projectKey)) {
                            WebAppSecurityInfo updated = WebAppSecurityInfo.createPublic(webApp, evt.newSettings.webAppSecuritySettings);
                            WebAppSecurityInfo previous = WebAppSecurityInfo.createPublic(webApp, evt.previousSettings.webAppSecuritySettings);
                            if (!registeredBackendIds.contains(webApp.id) || !WebAppSecurityInfo.needsRestart(previous, updated)) continue;
                            toRestart.add(webApp);
                        }
                    }
                    finally {
                        if (t == null) continue;
                        t.close();
                    }
                }
                catch (Exception exc) {
                    logger.warnV((Throwable)exc, "Error checking web application status in project '%s'", new Object[]{projectKey});
                }
            }
            for (WebApp webApp : toRestart) {
                messages.addMessage(InfoMessage.info((InfoMessage.MessageCode)WebAppsCode.WEBAPP_RESTART, (String)("Web app '" + webApp.getDisplayName() + "' (" + webApp.getProjectKey() + ") will be restarted.")));
            }
            t = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (WebApp webApp : toRestart) {
                        try {
                            logger.info((Object)("Security info changed for backend '" + webApp.getFullId() + "', restarting..."));
                            WebAppsService.this.restartBackend_NT(authCtx, webApp);
                        }
                        catch (Exception exc) {
                            logger.error((Object)("Unable to restart backend '" + webApp.getFullId() + "' ."), (Throwable)exc);
                        }
                    }
                }
            });
            ((Thread)t).setDaemon(true);
            ((Thread)t).start();
        }
        catch (Exception exc) {
            logger.error((Object)"Unable to list backends when reloading check.", (Throwable)exc);
        }
    }

    public String computeReuseKey(AuthCtx authCtx, String projectKey, String webAppType, JsonObject config) {
        WebAppMeta meta = WebAppRegistry.getMeta(webAppType);
        if (!(meta instanceof CustomWebAppMeta)) {
            return null;
        }
        CustomWebAppDesc desc = (CustomWebAppDesc)meta.getWebAppDesc();
        if (!desc.canReuse) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(projectKey);
        sb.append("-");
        sb.append(webAppType);
        if (desc.perUser) {
            sb.append("-");
            sb.append(authCtx.toString());
        }
        for (String propName : desc.propertiesForReusability) {
            sb.append("-");
            if (config == null || !config.has(propName)) continue;
            sb.append(JSON.json((Object)config.get(propName)));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebApp getReusableOrNull(AuthCtx authCtx, String projectKey, String webAppType, JsonObject config) {
        String key = this.computeReuseKey(authCtx, projectKey, webAppType, config);
        Map<AnyLoc, WebApp> map = this.virtualWebApps;
        synchronized (map) {
            if (key != null && this.virtualWebAppsByReuseKey.containsKey(key) && !this.virtualWebAppsByReuseKey.get(key).isEmpty()) {
                return this.virtualWebAppsByReuseKey.get(key).iterator().next();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebApp getVirtualWebAppOrNull(String projectKey, String id) {
        Map<AnyLoc, WebApp> map = this.virtualWebApps;
        synchronized (map) {
            AnyLoc loc = new AnyLoc(projectKey, id);
            return this.virtualWebApps.get(loc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebApp getVirtualWebAppOrNull(AnyLoc loc) {
        Map<AnyLoc, WebApp> map = this.virtualWebApps;
        synchronized (map) {
            return this.virtualWebApps.get(loc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putVirtualWebApp(AuthCtx authCtx, WebApp webApp) {
        Map<AnyLoc, WebApp> map = this.virtualWebApps;
        synchronized (map) {
            webApp.reuseKey = this.computeReuseKey(authCtx, webApp.projectKey, webApp.type, webApp.config);
            this.virtualWebApps.put(new AnyLoc(webApp.projectKey, webApp.id), webApp);
            if (StringUtils.isNotBlank((String)webApp.reuseKey)) {
                if (!this.virtualWebAppsByReuseKey.containsKey(webApp.reuseKey)) {
                    this.virtualWebAppsByReuseKey.put(webApp.reuseKey, new HashSet());
                }
                logger.info((Object)("Add reusable webApp " + webApp.getFullId() + " for key " + webApp.reuseKey));
                this.virtualWebAppsByReuseKey.get(webApp.reuseKey).add(webApp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebApp removeVirtualWebApp(String projectKey, String id) {
        Map<AnyLoc, WebApp> map = this.virtualWebApps;
        synchronized (map) {
            Set<WebApp> webApps;
            WebApp webApp = this.virtualWebApps.remove(new AnyLoc(projectKey, id));
            if (webApp != null && StringUtils.isNotBlank((String)webApp.reuseKey) && (webApps = this.virtualWebAppsByReuseKey.get(webApp.reuseKey)) != null) {
                logger.info((Object)("Remove reusable webApp " + webApp.getFullId() + " for key " + webApp.reuseKey));
                webApps.remove(webApp);
            }
            return webApp;
        }
    }

    public WebApp getMandatory(String projectKey, String id) throws IOException {
        WebApp webapp = this.getVirtualWebAppOrNull(projectKey, id);
        if (webapp == null) {
            webapp = (WebApp)this.dao.getMandatory(projectKey, id);
        }
        WebAppRegistry.getMeta(webapp.type).buildHandler(webapp).readCodeFiles();
        return webapp;
    }

    public WebApp getMandatoryUnsafe(String projectKey, String id) throws IOException {
        WebApp webapp = this.getVirtualWebAppOrNull(projectKey, id);
        if (webapp == null) {
            webapp = (WebApp)this.dao.getMandatoryUnsafe(projectKey, id);
        }
        WebAppRegistry.getMeta(webapp.type).buildHandler(webapp).readCodeFiles();
        return webapp;
    }

    public WebApp getMandatoryUnsafe_noCode(String projectKey, String id) throws IOException {
        WebApp webapp = this.getVirtualWebAppOrNull(projectKey, id);
        if (webapp == null) {
            webapp = (WebApp)this.dao.getMandatoryUnsafe(projectKey, id);
        }
        return webapp;
    }

    public WebApp getOrNull(String projectKey, String id) throws IOException {
        WebApp webapp = this.getVirtualWebAppOrNull(projectKey, id);
        if (webapp == null) {
            webapp = (WebApp)this.dao.getOrNull(projectKey, id);
        }
        if (webapp != null) {
            WebAppRegistry.getMeta(webapp.type).buildHandler(webapp).readCodeFiles();
        }
        return webapp;
    }

    public WebApp getOrNullUnsafe(String projectKey, String id) throws IOException {
        WebApp webapp = this.getVirtualWebAppOrNull(projectKey, id);
        if (webapp == null) {
            webapp = (WebApp)this.dao.getOrNullUnsafe(projectKey, id);
        }
        if (webapp != null) {
            WebAppRegistry.getMeta(webapp.type).buildHandler(webapp).readCodeFiles();
        }
        return webapp;
    }

    public WebApp getOrNullUnsafe_noCode(String projectKey, String id) throws IOException {
        WebApp webapp = this.getVirtualWebAppOrNull(projectKey, id);
        if (webapp == null) {
            webapp = (WebApp)this.dao.getOrNullUnsafe(projectKey, id);
        }
        return webapp;
    }

    public List<WebApp> listUnsafe_noCode(String projectKey) throws IOException {
        return this.dao.listUnsafe(projectKey);
    }

    public List<WebApp> listUnsafe(String projectKey) throws IOException {
        List<WebApp> webapps = this.dao.listUnsafe(projectKey);
        for (WebApp webapp : webapps) {
            WebAppRegistry.getMeta(webapp.type).buildHandler(webapp).readCodeFiles();
        }
        return webapps;
    }

    public List<WebApp> list(String projectKey) throws IOException {
        List<WebApp> webapps = this.dao.list(projectKey);
        for (WebApp webapp : webapps) {
            WebAppRegistry.getMeta(webapp.type).buildHandler(webapp).readCodeFiles();
        }
        return webapps;
    }

    public int approximateCount(String projectKey) throws IOException {
        return this.dao.approximateCount(projectKey);
    }

    public List<WebApp.WebAppListItem> listHeads_NT(String projectKey) throws IOException {
        TransactionContext.assertNoAttachedTransaction();
        Set<String> registeredBackendIds = this.backendsManager.listRegisteredBackends(projectKey);
        logger.info((Object)("Running webapp backends in " + projectKey));
        logger.info(registeredBackendIds);
        ArrayList<WebApp.WebAppListItem> ret = new ArrayList<WebApp.WebAppListItem>();
        try (Transaction t = this.transactionService.beginRead();){
            for (WebApp webApp : this.listUnsafe_noCode(projectKey)) {
                WebApp.WebAppListItem listItem = new WebApp.WebAppListItem(webApp);
                listItem.backendRunning = registeredBackendIds.contains(webApp.id);
                this.taggableObjectsService.setEditionInfoFromTags(webApp, listItem);
                ret.add(listItem);
            }
        }
        return ret;
    }

    public void cleanupStoppedVirtualWebapp(String projectKey, String id) {
        this.removeVirtualWebApp(projectKey, id);
        this.stoppableWithTimeoutService.kill(id);
    }

    public String computeRunAs(WebApp webApp) {
        if (StringUtils.isNotBlank((String)webApp.params.runAs)) {
            return webApp.params.runAs;
        }
        if (webApp.versionTag != null) {
            return webApp.versionTag.getLastAuthor();
        }
        return null;
    }

    public AuthCtx buildActualAuthCtx_T(AuthCtx orig, WebApp webApp) throws DKUSecurityException {
        if (webApp.params.runAs == null || webApp.params.runAs.isEmpty()) {
            if (orig.getAuthSource() == AuthCtx.AuthSource.NONE && webApp.versionTag != null) {
                logger.info((Object)"No 'runAs' field. Use last modifier.");
                String lastModifier = webApp.versionTag.getLastAuthor();
                AuthCtx newAuthCtx = this.authCtxCreationService.create(lastModifier);
                newAuthCtx.addVia("None");
                return newAuthCtx;
            }
            logger.info((Object)"No 'runAs' field. Use current auth context");
            return orig;
        }
        AuthCtx newAuthCtx = this.authCtxCreationService.create(webApp.params.runAs);
        newAuthCtx.addParent(orig);
        return newAuthCtx;
    }

    public List<BackendInfo> getBackendInfoListForProject_NT(DKUExecutors.DKUExecutor executor, String projectKey, boolean autoStartedOnly, boolean includeWebappsWithNoBackend) throws IOException {
        List<WebApp> webapps;
        try (Transaction ignored = this.transactionService.beginRead();){
            webapps = this.listUnsafe_noCode(projectKey);
        }
        Stream<Object> webAppStream = webapps.stream();
        if (autoStartedOnly) {
            webAppStream = webAppStream.filter(webApp -> webApp.params.isAutoStartBackend());
        } else if (!includeWebappsWithNoBackend) {
            webAppStream = webAppStream.filter(webApp -> webApp.params.isBackendEnabled());
        }
        int readinessTimeout = DKUApp.getParams().getIntParam("dku.webapp.backendReadiness.timeoutMS", Integer.valueOf(5000));
        List filteredWebapps = webAppStream.collect(Collectors.toList());
        ArrayList<BackendInfo> infoList = new ArrayList<BackendInfo>();
        for (WebApp webApp2 : filteredWebapps) {
            String webAppId = webApp2.id;
            String webAppName = webApp2.getDisplayName();
            BackendInfo info = new BackendInfo(webAppId, webAppName, webApp2.type);
            if (!webApp2.params.isBackendEnabled()) {
                info.status = Status.BACKEND_NOT_ENABLED;
            } else {
                info.hasBackend = true;
                info.isBackendAutostartOn = webApp2.params.isAutoStartBackend();
                try {
                    WebAppBackend backend = this.backendsManager.getBackendOrNull(projectKey, webAppId);
                    if (backend == null) {
                        info.status = Status.STOPPED;
                    } else {
                        executor.submit(() -> {
                            info.status = this.calculateWebAppBackendStatus(webApp2, backend, readinessTimeout);
                            return info.status;
                        });
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)("Unable to get status of backend for webapp " + webAppId), (Throwable)e);
                    info.status = Status.UNKNOWN;
                }
            }
            infoList.add(info);
        }
        return infoList;
    }

    private Status calculateWebAppBackendStatus(@Nonnull WebApp webApp, @Nonnull WebAppBackend backend, int readinessTimeout) {
        try {
            WebAppBackendInstance.BackendState state = backend.getState(true);
            if (WebAppBackendsManager.isBackendAlive(state)) {
                WebAppHandler webAppHandler = WebAppHandler.buildHandler(webApp);
                return webAppHandler.backendReady(state, readinessTimeout) ? Status.BACKEND_READY : Status.BACKEND_NOT_READY;
            }
            return Status.STOPPED;
        }
        catch (IOException e) {
            logger.warn((Object)("Unable to get status of backend for webapp " + webApp.id), (Throwable)e);
            return Status.UNKNOWN;
        }
    }

    public WebAppCreateResponse create(final AuthCtx authCtx, String projectKey, String name, String webappType, WebAppTemplateDesc templateDesc, JsonObject params, JsonObject config) throws Exception {
        final WebApp webApp = this.createNoSave(null, authCtx, projectKey, name, webappType, templateDesc, params, config, null);
        WebAppMeta meta = WebAppRegistry.getMeta(webappType);
        boolean runVirtual = false;
        if (meta instanceof CustomWebAppMeta) {
            List<CustomWebAppDesc.WebAppRole> roles = ((CustomWebAppDesc)meta.getWebAppDesc()).roles;
            runVirtual = roles != null && !roles.isEmpty();
        }
        WebAppCreateResponse ret = new WebAppCreateResponse();
        if (runVirtual) {
            webApp.creationTag = VersionTag.increment(null, authCtx.getIdentifier());
            webApp.isVirtual = true;
            this.putVirtualWebApp(authCtx, webApp);
            ret.resp = new WebAppSaveResponse();
            ret.resp.webAppId = webApp.id;
            float virtualAliveMins = WebAppsService.getVirtualAliveMins();
            this.stoppableWithTimeoutService.stopWithTimeout(WEB_APP_TASK_PREFIX + webApp.getFullId(), new StoppableWithTimeoutService.Stoppable(){

                @Override
                public void stop() {
                    logger.infoV("Timeouting webapp %s", new Object[]{webApp.getFullId()});
                    try (RWTransaction t = WebAppsService.this.transactionService.beginWriteAsDSS();){
                        WebAppsService.this.delete(authCtx, webApp.projectKey, webApp.id);
                        t.commit("Delete virtual webapp " + webApp.getFullId());
                    }
                    catch (Exception e) {
                        logger.errorV("Couldn't remove webapp, project=%s, webapp=%s : %s", new Object[]{webApp.projectKey, webApp.id, ExceptionUtils.getMessageWithCauses((Throwable)e)});
                    }
                }
            }, virtualAliveMins, false);
        } else {
            webApp.isVirtual = false;
            ret.resp = this.save(webApp, true);
        }
        ret.webapp = webApp;
        return ret;
    }

    public WebAppCreateResponse createVirtual(AuthCtx authCtx, String webAppId, String projectKey, String name, String webappType, WebAppTemplateDesc templateDesc, JsonObject params, JsonObject config, @Nullable String contextualCodeEnv) throws Exception {
        WebApp webApp = this.createNoSave(webAppId, authCtx, projectKey, name, webappType, templateDesc, params, config, contextualCodeEnv);
        WebAppMeta meta = WebAppRegistry.getMeta(webappType);
        if (!(meta instanceof ProxyWebAppMeta)) {
            VirtualWebAppBackendSettings globalBackendSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().virtualWebAppBackendSettings;
            VirtualWebAppBackendSettings projectBackendSettings = StringUtils.isNotBlank((String)projectKey) ? this.projectsService.getMandatoryUnsafe((String)projectKey).settings.virtualWebAppBackendSettings : new VirtualWebAppBackendSettings(false);
            VirtualWebAppBackendSettings backendSettings = VirtualWebAppBackendSettings.getEffectiveSettings(globalBackendSettings, projectBackendSettings);
            logger.info((Object)("Apply backend settings to webapp : " + JSON.json((Object)backendSettings)));
            if (backendSettings.mode == VirtualWebAppBackendSettings.SettingsMode.USE_DEFAULT) {
                webApp.params.infra.containerSelection.containerMode = ContainerExecSelection.ContainerExecMode.NONE;
            } else if (backendSettings.mode == VirtualWebAppBackendSettings.SettingsMode.EXPLICIT) {
                webApp.params.infra = backendSettings.infra;
            }
        }
        webApp.isVirtual = true;
        this.putVirtualWebApp(authCtx, webApp);
        WebAppCreateResponse ret = new WebAppCreateResponse();
        ret.resp = new WebAppSaveResponse();
        ret.resp.webAppId = webApp.id;
        ret.webapp = webApp;
        return ret;
    }

    public WebAppCreateResponse createTimeoutableVirtual(final AuthCtx authCtx, String webAppId, String projectKey, String name, String webappType, WebAppTemplateDesc templateDesc, JsonObject params, JsonObject config, @Nullable String contextualCodeEnv) throws Exception {
        WebAppCreateResponse ret = this.createVirtual(authCtx, webAppId, projectKey, name, webappType, templateDesc, params, config, contextualCodeEnv);
        final WebApp webApp = ret.webapp;
        webApp.creationTag = VersionTag.increment(null, authCtx.getIdentifier());
        float virtualAliveMins = WebAppsService.getVirtualAliveMins();
        this.stoppableWithTimeoutService.stopWithTimeout(WEB_APP_TASK_PREFIX + webApp.getFullId(), new StoppableWithTimeoutService.Stoppable(){

            @Override
            public void stop() {
                logger.infoV("Timeouting webapp %s", new Object[]{webApp.getFullId()});
                try (RWTransaction t = WebAppsService.this.transactionService.beginWriteAsDSS();){
                    WebAppsService.this.delete(authCtx, webApp.projectKey, webApp.id);
                    t.commit("Delete virtual webapp " + webApp.getFullId());
                }
                catch (Exception e) {
                    logger.errorV("Couldn't remove webapp, project=%s, webapp=%s : %s", new Object[]{webApp.projectKey, webApp.id, ExceptionUtils.getMessageWithCauses((Throwable)e)});
                }
            }
        }, virtualAliveMins, false);
        return ret;
    }

    public WebApp createNoSave(String id, AuthCtx authCtx, String projectKey, String name, String webappType, WebAppTemplateDesc templateDesc, JsonObject params, JsonObject config, @Nullable String contextualCodeEnv) throws Exception {
        if (id == null) {
            id = this.dao.generateUniqueId(projectKey);
        } else if (this.getOrNullUnsafe(projectKey, id) != null) {
            throw new IllegalArgumentException(String.format("Webapp with id %s already exists", id));
        }
        if (templateDesc != null && templateDesc.type != null && !templateDesc.type.equals(webappType)) {
            throw new IllegalArgumentException("Cannot create webapp for type" + webappType + " using template of type" + templateDesc.type);
        }
        WebApp webApp = new WebApp();
        webApp.id = id;
        webApp.projectKey = projectKey;
        webApp.name = name;
        webApp.type = webappType;
        webApp.config = config;
        WebAppMeta meta = WebAppRegistry.getMeta(webappType);
        WebApp.WebAppParams webAppParams = webApp.params = params != null ? (WebApp.WebAppParams)JSON.parse((JsonElement)params, meta.getParamsClass()) : meta.getParamsClass().newInstance();
        if (meta.isCustomWebApp() && config == null) {
            throw new IllegalStateException("Config is mandatory for plugin webapps");
        }
        if (meta instanceof CodeStudioWebAppMeta) {
            CodeStudioWebAppMeta.CodeStudioWebAppParams codeStudioWebAppParams = webApp.getParamsAs(CodeStudioWebAppMeta.CodeStudioWebAppParams.class);
            CodeStudioObject codeStudio = (CodeStudioObject)this.codeStudioObjectsDAO.getMandatoryUnsafe(projectKey, codeStudioWebAppParams.codeStudioId);
            CodeStudioTemplate template = this.codeStudioTemplatesDAO.getMandatoryUnsafe(codeStudio.templateId);
            String codeStudioContainerConfig = new ContainerExecConfigSelector().selectNameForCodeStudio_autoTXN(authCtx, projectKey, template.defaultContainerConf, template.allowContainerConfOverride);
            String projectContainerConfig = new ContainerExecConfigSelector().selectName_autoTXN(projectKey, new ContainerExecSelection(), WorkloadType.USER_CODE);
            logger.info((Object)("Code Studio set to run on " + StringUtils.defaultIfBlank((String)codeStudioContainerConfig, (String)"<none>") + ", project is using " + StringUtils.defaultIfBlank((String)projectContainerConfig, (String)"<none>")));
            if (StringUtils.equals((String)codeStudioContainerConfig, (String)projectContainerConfig)) {
                logger.info((Object)"Configuration is same as project, using 'inherit' for webapp");
                webApp.params.infra.containerSelection.containerMode = ContainerExecSelection.ContainerExecMode.INHERIT;
            } else {
                logger.info((Object)"Configuration is not the project's default, selecting explicitely in webapp");
                webApp.params.infra.containerSelection.containerMode = ContainerExecSelection.ContainerExecMode.EXPLICIT_CONTAINER;
                webApp.params.infra.containerSelection.containerConf = codeStudioContainerConfig;
            }
        }
        if (contextualCodeEnv != null && meta.isCustomWebApp() && ((CustomWebAppDesc)meta.getWebAppDesc()).useContextualCodeEnv && webApp.params instanceof ParamsWithSelectableCodeEnv) {
            if (StringUtils.isNotBlank((String)contextualCodeEnv)) {
                ((ParamsWithSelectableCodeEnv)((Object)webApp.params)).setCodeEnvSelection(CodeEnvSelection.explicitEnv(contextualCodeEnv));
            } else {
                ((ParamsWithSelectableCodeEnv)((Object)webApp.params)).setCodeEnvSelection(CodeEnvSelection.builtInEnvSelection());
            }
        }
        WebAppHandler wah = WebAppHandler.buildHandler(webApp);
        if (templateDesc != null && templateDesc.type != null) {
            File templateDir = this.templatesService.getTemplateDir(webappType, templateDesc);
            wah.initWebAppTemplate(templateDesc.id, templateDir);
        } else if (meta.isCustomWebApp()) {
            wah.initCustomWebApp();
        } else {
            wah.initWebApp();
        }
        return webApp;
    }

    public WebAppSaveResponse save(WebApp webApp, boolean creation) throws Exception {
        TaggableObjectChangedEvent.ActionType action;
        WebAppMeta meta;
        Preconditions.checkNotNull((Object)webApp.params, (Object)"Web app params are required");
        WebAppSaveResponse ret = new WebAppSaveResponse();
        ret.isVirtual = this.getVirtualWebAppOrNull(webApp.projectKey, webApp.id) != null;
        RWTransactionRef t = TransactionContext.retrieveWrite();
        WebApp existing = this.getOrNullUnsafe(webApp.projectKey, webApp.id);
        if (creation && existing != null) {
            throw new IllegalArgumentException("Webapp already exists");
        }
        if (!creation && existing == null) {
            throw new IllegalArgumentException("Webapp does not exist");
        }
        this.taggableObjectsService.handleCreationVersionTagOnObjectUpdateNullAllowed(webApp, existing);
        if (!(webApp.params.runAs == null || existing != null && existing.params.runAs != null && existing.params.runAs.equals(webApp.params.runAs))) {
            this.permissionsService.checkAdmin(t.getUser(), "change run-as of a webapp backend");
        }
        if ((meta = WebAppRegistry.getMeta(webApp.type)) instanceof MetaWithSelectableCodeEnv) {
            this.codeEnvPermissionsService.failIfCodeEnvNotUsable(webApp.projectKey, ((MetaWithSelectableCodeEnv)((Object)meta)).getEnvLang(), (ParamsWithSelectableCodeEnv)((Object)webApp.params), existing == null ? null : (ParamsWithSelectableCodeEnv)((Object)existing.params), t.getUser());
        }
        if (creation) {
            this.customFieldsService.enrichWithDefaultCustomFieldsForTaggableObject(webApp);
        }
        if (ret.isVirtual) {
            this.putVirtualWebApp(t.getUser(), webApp);
        } else {
            this.customPolicyHooksRegistry.onPreObjectSave(t.getUser(), this.getOrNull(webApp.projectKey, webApp.id), webApp);
            this.dao.save(webApp);
        }
        ret.webAppId = webApp.id;
        ret.versionTag = webApp.versionTag;
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", webApp.name);
        if (creation) {
            action = TaggableObjectChangedEvent.ActionType.WEB_APP_CREATE;
        } else if (webApp.name != null && existing != null && !webApp.name.equals(existing.name)) {
            action = TaggableObjectChangedEvent.ActionType.WEB_APP_RENAME;
            details.addProperty("newName", webApp.name);
            details.addProperty("oldName", existing.name);
        } else {
            action = TaggableObjectChangedEvent.ActionType.WEB_APP_EDIT;
        }
        this.taggingService.onObjectSaved(webApp.projectKey, webApp.tags);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.WEB_APP, webApp.projectKey, webApp.id, t.getUser(), action).withDetails(details));
        return ret;
    }

    public void delete(AuthCtx authCtx, String projectKey, String id) throws IOException, CodedException {
        JsonObject details = new JsonObject();
        WebApp wa = this.getOrNull(projectKey, id);
        if (wa != null) {
            this.customPolicyHooksRegistry.onPreObjectDelete(authCtx, wa);
            details.addProperty("objectDisplayName", wa.name);
            if (StringUtils.isNotBlank((String)wa.apiKey)) {
                try {
                    String decryptedApiKey = this.passwordEncryptionService.decryptIfEncrypted(wa.apiKey);
                    this.publicAPIKeysService.deleteProjectAPIKeyByKey(wa.projectKey, decryptedApiKey);
                }
                catch (Exception e) {
                    logger.warn((Object)"Failed to remove webapp's apiKey", (Throwable)e);
                }
            }
            if (wa.isVirtual) {
                this.removeVirtualWebApp(projectKey, id);
            } else {
                this.deleteDiskFiles(projectKey, id);
                this.dao.delete(projectKey, id);
                this.scheduleTrustDBCleanupAfterWebAppDeletion(projectKey, id);
            }
        }
        WebAppBackendRestartThread.stop(projectKey, authCtx, id);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.WEB_APP, projectKey, id, authCtx, TaggableObjectChangedEvent.ActionType.WEB_APP_DELETE).withDetails(details));
    }

    public void deleteForProject(String projectKey) {
        this.scheduleTrustDBCleanupAfterProjectDeletion(projectKey);
    }

    private void scheduleTrustDBCleanupAfterProjectDeletion(String projectKey) {
        TransactionContext.retrieveWrite().onPostCommit(() -> {
            try {
                this.trustInternalDB.removeEntriesForProject(projectKey);
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to cleanup trust DB for project " + projectKey);
            }
        });
    }

    private void scheduleTrustDBCleanupAfterWebAppDeletion(String projectKey, String webAppId) {
        TransactionContext.retrieveWrite().onPostCommit(() -> {
            try {
                this.trustInternalDB.removeEntriesForWebApp(projectKey, webAppId);
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to cleanup trust DB for project " + projectKey);
            }
        });
    }

    public WebApp copy(String projectKey, String webAppId, String newName) throws Exception {
        WebApp webApp = this.getMandatory(projectKey, webAppId);
        if (webApp.isVirtual) {
            throw new IllegalArgumentException("Virtual webapps cannot be copied");
        }
        newName = StringUtils.isBlank((String)newName) ? webApp.name : newName;
        Preconditions.checkArgument((webApp.projectKey != null ? 1 : 0) != 0, (Object)"Original web app has no project key");
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", newName);
        TaggableObjectChangedEvent.ActionType action = TaggableObjectChangedEvent.ActionType.WEB_APP_CREATE;
        details.addProperty("copy", Boolean.valueOf(true));
        details.addProperty("originalObjectName", webApp.name);
        details.addProperty("originalObjectId", webApp.id);
        AuthCtx user = TransactionContext.retrieveWrite().getUser();
        webApp.id = SecretKeyGenerator.generateSmall();
        webApp.name = newName;
        webApp.creationTag = webApp.versionTag = VersionTag.increment(null, user.getIdentifier());
        String originalApiKey = webApp.apiKey;
        WebAppHandler wah = WebAppHandler.buildHandler(webApp);
        wah.initWebApp();
        if (originalApiKey != null && wah instanceof AbstractStandardWebAppHandler) {
            try {
                if (webApp.apiKey != null) {
                    PublicAPIKey originKey = this.publicAPIKeysService.getKey(this.passwordEncryptionService.decryptIfEncrypted(originalApiKey));
                    PublicAPIKeysService.WebAppDatasetLevelPermissions permissionsToCopy = this.publicAPIKeysService.getDatasetLevelPermissions(user, webApp.projectKey, originKey.id);
                    PublicAPIKey targetKey = this.publicAPIKeysService.getKey(this.passwordEncryptionService.decryptIfEncrypted(webApp.apiKey));
                    this.publicAPIKeysService.setDatasetLevelPermissions(user, webApp.projectKey, targetKey.id, permissionsToCopy);
                }
            }
            catch (Exception e) {
                logger.warnV((Throwable)e, "Copying dataset level permissions from webapp %s to new webapp %s failed", new Object[]{webAppId, webApp.id});
            }
        }
        this.customPolicyHooksRegistry.onPreObjectSave(user, null, webApp);
        this.dao.save(webApp);
        wah.writeCodeFiles();
        this.taggingService.onObjectSaved(webApp.projectKey, webApp.tags);
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.WEB_APP, webApp.projectKey, webApp.id, user, action).withDetails(details));
        TransactionContext.retrieveWrite().onPostCommit(() -> {
            try {
                this.trustedCodeService.copyTrustEntriesForWebApp_NT(projectKey, webAppId, projectKey, webApp.id);
            }
            catch (IOException | SQLException e) {
                logger.error((Object)("Failed to copy trust entries for webapp " + webApp.getFullId()), (Throwable)e);
            }
        });
        return webApp;
    }

    public void deleteDiskFiles(String projectKey, String id) throws IOException {
        WebApp webapp = this.getVirtualWebAppOrNull(projectKey, id);
        if (webapp == null) {
            webapp = (WebApp)this.dao.getMandatoryUnsafe(projectKey, id);
        }
        WebAppHandler wah = WebAppHandler.buildHandler(webapp);
        wah.deleteCodeFiles();
    }

    public void onApplicationEvent(DSSStartedEvent dssStartedEvent) {
        logger.info((Object)"Starting web app backends in a bit of time");
        Thread startThread = new Thread(){

            @Override
            public void run() {
                try {
                    List<WebApp> webAppsToStop;
                    List<WebApp> webAppsToStart;
                    try (Transaction t = WebAppsService.this.transactionService.beginRead();){
                        webAppsToStart = WebAppsService.this.listAutoStartWebApps();
                        webAppsToStop = WebAppsService.this.listNotAutoStartWebAppsWithPersistedInfo();
                    }
                    logger.info((Object)"About to stop orphan webapps");
                    WebAppsService.this.stopBackends_NT(webAppsToStop, DSSAuthCtx.newNone());
                    DKUtils.unsafeSleep((long)60000L);
                    logger.info((Object)"About to start all auto-start webapp backends");
                    WebAppsService.this.restartAutoStartBackends_NT(webAppsToStart, DSSAuthCtx.newNone());
                }
                catch (Exception e) {
                    logger.error((Object)"Auto-start failed", (Throwable)e);
                }
            }
        };
        startThread.start();
        WebAppBackend.clearNginxConfs();
        Thread virtualWebAppsTimeout = new Thread(){

            @Override
            public void run() {
                block4: while (true) {
                    float virtualAliveMins = WebAppsService.getVirtualAliveMins();
                    try {
                        Thread.sleep((int)(0.5 * (double)virtualAliveMins * 60.0 * 1000.0));
                    }
                    catch (InterruptedException e) {
                        logger.info((Object)"Interrupted while sleeping", (Throwable)e);
                    }
                    try {
                        List<StoppableWithTimeoutService.Stoppable> killed = WebAppsService.this.stoppableWithTimeoutService.killIfExpiredByPrefix(WebAppsService.WEB_APP_TASK_PREFIX);
                        Iterator<StoppableWithTimeoutService.Stoppable> iterator = killed.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block4;
                            StoppableWithTimeoutService.Stoppable stoppable = iterator.next();
                            stoppable.stop();
                        }
                    }
                    catch (Throwable t) {
                        logger.error((Object)"Failed to cleanup virtual webapps", t);
                        continue;
                    }
                    break;
                }
            }
        };
        virtualWebAppsTimeout.start();
    }

    public Collection<WebApp> listRegisteredBackends(String projectKey) throws IOException {
        Set<String> ids = this.backendsManager.listRegisteredBackends(projectKey);
        ArrayList webApps = Lists.newArrayList();
        for (WebApp webApp : this.listUnsafe_noCode(projectKey)) {
            if (!ids.contains(webApp.id)) continue;
            webApps.add(webApp);
        }
        return webApps;
    }

    public Collection<WebApp> listRegisteredBackends() throws IOException {
        ArrayList webApps = Lists.newArrayList();
        for (String projectKey : this.projectsService.listKeys()) {
            webApps.addAll(this.listRegisteredBackends(projectKey));
        }
        return webApps;
    }

    private List<WebApp> listAutoStartWebApps() throws IOException {
        ArrayList webApps = Lists.newArrayList();
        for (String projectKey : this.projectsService.listKeys()) {
            for (WebApp webApp : this.listUnsafe(projectKey)) {
                if (!webApp.params.isAutoStartBackend()) continue;
                webApps.add(webApp);
            }
        }
        return webApps;
    }

    private List<WebApp> listNotAutoStartWebAppsWithPersistedInfo() throws IOException {
        ArrayList webApps = Lists.newArrayList();
        for (String projectKey : this.projectsService.listKeys()) {
            for (WebApp webApp : this.listUnsafe(projectKey)) {
                if (!webApp.params.isBackendEnabled() || webApp.params.isAutoStartBackend()) continue;
                WebAppBackend webAppBackend = this.backendsManager.getOrCreateBackend(webApp);
                if (webAppBackend.hasPersistedInstanceInfo()) {
                    webApps.add(webApp);
                    continue;
                }
                this.backendsManager.removeBackend(projectKey, webApp.getId());
            }
        }
        return webApps;
    }

    private void restartAutoStartBackends_NT(List<WebApp> webApps, AuthCtx authCtx) {
        for (WebApp webApp : webApps) {
            logger.info((Object)("(Re)starting backend for webapp " + webApp.projectKey + " " + webApp.name + " (" + webApp.id + ")"));
            try {
                this.restartBackend_NT(authCtx, webApp);
            }
            catch (Exception e) {
                logger.warn((Object)("(Re)starting backend for webapp " + webApp.projectKey + " " + webApp.name + " (" + webApp.id + ") failed"), (Throwable)e);
            }
        }
    }

    private void stopBackends_NT(List<WebApp> webApps, AuthCtx authCtx) {
        for (WebApp webApp : webApps) {
            logger.info((Object)("Stopping potentiallly orphan backend for webapp " + webApp.projectKey + " " + webApp.name + " (" + webApp.id + ")"));
            try {
                this.stopBackend(webApp);
            }
            catch (Exception e) {
                logger.warn((Object)("Stopping potentiallly orphan backend for webapp " + webApp.projectKey + " " + webApp.name + " (" + webApp.id + ") failed"), (Throwable)e);
            }
        }
    }

    public FutureResponse<WebAppBackendInstance.BackendState> restartBackend_NT(AuthCtx authCtx, WebApp webApp, Map<String, ?> parameters, boolean keepFutureIdInState) throws Exception {
        JsonObject varCtx = this.variablesService.getContext(webApp.projectKey).getAllVariablesTyped();
        if (parameters != null) {
            for (Map.Entry<String, ?> entry : parameters.entrySet()) {
                varCtx.add(entry.getKey(), JSON.toJsonElement(entry.getValue()));
            }
        }
        return this.backendsManager.forceRestart_NT(authCtx, webApp, varCtx, keepFutureIdInState);
    }

    public FutureResponse<WebAppBackendInstance.BackendState> restartBackend_NT(AuthCtx authCtx, WebApp webApp) throws Exception {
        return this.restartBackend_NT(authCtx, webApp, null, true);
    }

    public void restartBackends_NT(Collection<WebApp> webApps, AuthCtx authCtx) {
        for (WebApp webApp : webApps) {
            logger.info((Object)("(Re)starting backend for webapp " + webApp.projectKey + " " + webApp.name + " (" + webApp.id + ")"));
            try {
                this.restartBackend_NT(authCtx, webApp);
            }
            catch (Exception e) {
                logger.warn((Object)("(Re)starting backend for webapp " + webApp.projectKey + " " + webApp.name + " (" + webApp.id + ") failed"), (Throwable)e);
            }
        }
    }

    public WebAppBackendInstance.BackendState getBackendState(WebApp webApp, boolean keepFutureIdInState) throws Exception {
        WebAppBackendInstance.BackendState state = this.backendsManager.getState(webApp, keepFutureIdInState);
        if (state == null) {
            state = new WebAppBackendInstance.BackendState(webApp);
        }
        return state;
    }

    public boolean stopBackend(WebApp webApp) throws Exception {
        return this.backendsManager.stop_NT(webApp.projectKey, webApp.id);
    }

    public void stopAllForProject_NT(String projectKey) throws IOException {
        Collection<WebApp> webApps;
        try (Transaction t = this.transactionService.beginRead();){
            webApps = this.listRegisteredBackends(projectKey);
        }
        for (WebApp webApp : webApps) {
            logger.info((Object)("Stopping backend for webapp " + projectKey + " " + webApp.name + " (" + webApp.id + ")"));
            try {
                this.stopBackend(webApp);
            }
            catch (Exception e) {
                logger.warn((Object)("Stopping backend for webapp " + projectKey + " " + webApp.name + " (" + webApp.id + ") failed"), (Throwable)e);
            }
        }
    }

    public void stopAllAndStartAutoForProject_NT(AuthCtx authCtx, String projectKey) throws Exception {
        Set<String> runningWebAppIds;
        List<WebApp> webApps;
        try (Transaction t = this.transactionService.beginRead();){
            webApps = this.listUnsafe(projectKey);
            runningWebAppIds = this.backendsManager.listRegisteredBackends(projectKey);
        }
        HashSet<String> webAppIds = new HashSet<String>();
        for (WebApp webApp : webApps) {
            webAppIds.add(webApp.id);
            boolean wasRunning = runningWebAppIds.contains(webApp.id);
            if (wasRunning) {
                logger.info((Object)("Stopping backend for webapp " + projectKey + " " + webApp.name + " (" + webApp.id + ")"));
                try {
                    this.backendsManager.stop_NT(projectKey, webApp.id);
                }
                catch (Exception e) {
                    logger.warn((Object)("Stopping backend for webapp " + projectKey + " " + webApp.name + " (" + webApp.id + ") failed"), (Throwable)e);
                }
            }
            if (!wasRunning && !webApp.params.isAutoStartBackend()) continue;
            logger.info((Object)("(Re)starting backend for webapp " + projectKey + " " + webApp.name + " (" + webApp.id + ")"));
            try {
                this.restartBackend_NT(authCtx, webApp);
            }
            catch (Exception e) {
                logger.warn((Object)("(Re)starting backend for webapp " + projectKey + " " + webApp.name + " (" + webApp.id + ") failed"), (Throwable)e);
            }
        }
        for (String runningWebAppId : runningWebAppIds) {
            if (webAppIds.contains(runningWebAppId)) continue;
            logger.warn((Object)("Stopping backend for removed/disabled webapp " + projectKey + "." + runningWebAppId));
            try {
                this.backendsManager.stop_NT(projectKey, runningWebAppId);
            }
            catch (Exception e) {
                logger.warn((Object)("Stopping backend for removed/disabled webapp " + projectKey + "." + runningWebAppId + " failed"), (Throwable)e);
            }
        }
    }

    public void removeBackend_NT(String projectKey, String webAppId) {
        logger.info((Object)("Stopping backend for webapp " + projectKey + "." + webAppId));
        try {
            this.backendsManager.stop_NT(projectKey, webAppId);
        }
        catch (Exception e) {
            logger.warn((Object)("Stopping backend for webapp " + projectKey + "." + webAppId + " failed"), (Throwable)e);
        }
    }

    public List<BackendStateWithWebApp> listAllBackendStates_NT() throws IOException {
        ArrayList<BackendStateWithWebApp> ret = new ArrayList<BackendStateWithWebApp>();
        try (Transaction t = this.transactionService.beginRead();){
            for (String projectKey : this.projectsService.listKeys()) {
                for (WebApp webApp : this.listUnsafe_noCode(projectKey)) {
                    if (!webApp.params.isBackendEnabled()) continue;
                    BackendStateWithWebApp ps2 = new BackendStateWithWebApp();
                    ps2.projectKey = projectKey;
                    ps2.webAppId = webApp.id;
                    ps2.webAppName = webApp.name;
                    ps2.type = webApp.type;
                    ret.add(ps2);
                }
            }
        }
        for (BackendStateWithWebApp ps3 : ret) {
            try {
                ps3.backendState = this.backendsManager.getState(ps3.projectKey, ps3.webAppId, true);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to get webApp backend state", (Throwable)e);
            }
        }
        return ret;
    }

    public DevPluginsService.WebAppConversionResult convertWebAppToCustom(String projectKey, String id, String targetPluginId, DevPluginsService.TargetPluginMode mode, String webappType, AuthCtx authCtx) throws Exception {
        WebApp webapp;
        try (Transaction t = this.transactionService.beginRead();){
            webapp = this.getMandatory(projectKey, id);
        }
        if (webapp.isVirtual) {
            throw new IllegalArgumentException("Virtual webapps cannot be converted");
        }
        WebAppMeta meta = WebAppRegistry.getMeta(webapp.type);
        if (meta instanceof CustomWebAppMeta) {
            throw new IllegalArgumentException("Only code webapps can be used to create plugin webapps");
        }
        try (Transaction t = this.transactionService.beginRead();){
            meta.buildHandler(webapp).readCodeFiles();
        }
        if (mode == DevPluginsService.TargetPluginMode.NEW) {
            TransactionContext.warnAttachedTransaction();
            FutureResponse<InfoMessage> future = this.pluginDeveloperService.startCreatePlugin(targetPluginId, DevPluginsService.DevPluginBootstrapMode.EMPTY, null, null, null, authCtx);
            this.futureService.waitForFinalResponse(future);
        }
        return this.pluginDeveloperService.addCustomWebAppFromExisting(targetPluginId, webapp, webappType, authCtx);
    }

    static enum WebAppsCode implements InfoMessage.MessageCode
    {
        WEBAPP_RESTART("WebApp restart", InfoMessage.FixabilityCategory.UNKNOWN),
        WEBAPP_RESTART_FAIL("WebApp restart failure", InfoMessage.FixabilityCategory.UNKNOWN);

        private final String title;
        private final InfoMessage.FixabilityCategory fixability;

        private WebAppsCode(String title, InfoMessage.FixabilityCategory fixability) {
            this.title = title;
            this.fixability = fixability;
        }

        public String getCode() {
            return this.name();
        }

        public String getCodeTitle() {
            return this.title;
        }

        public InfoMessage.FixabilityCategory getFixability() {
            return this.fixability;
        }
    }

    public static class BackendInfo {
        public String id;
        public String name;
        public String type;
        public Status status;
        public boolean hasBackend;
        public boolean isBackendAutostartOn;

        public BackendInfo(String id, String name, String type) {
            this.id = id;
            this.name = name;
            this.type = type;
            this.status = Status.UNKNOWN;
            this.hasBackend = false;
            this.isBackendAutostartOn = false;
        }

        public BackendInfo(String id, String name, Status status) {
            this.id = id;
            this.name = name;
            this.status = status;
        }
    }

    public static enum Status {
        STOPPED,
        BACKEND_READY,
        BACKEND_NOT_READY,
        BACKEND_NOT_ENABLED,
        UNKNOWN;

    }

    public static class WebAppCreateResponse {
        public WebAppSaveResponse resp;
        public WebApp webapp;
    }

    public static class WebAppSaveResponse {
        public String webAppId;
        public FutureResponse<WebAppBackendInstance.BackendState> backendState;
        public boolean isVirtual;
        public TrustedCodeService.TrustedCodeCheckReport trustedCodeReport;
        @Nullable
        public VersionTag versionTag;
    }

    public static class BackendStateWithWebApp {
        String projectKey;
        String webAppId;
        String webAppName;
        WebAppBackendInstance.BackendState backendState;
        public String type;
    }
}

