/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.backend;

import com.dataiku.dip.code.ProjectLibPathHelper;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.exec.EnvironmentStash;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exposition.Exposables;
import com.dataiku.dip.io.KernelUtils;
import com.dataiku.dip.remoterun.RemoteRunEnvDef;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.ProcessResourceUsageMonitor;
import com.dataiku.dip.resourceusage.WithMaybePid;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.IImpersonationResolverService;
import com.dataiku.dip.security.process.InsecureProcessesLaunchService;
import com.dataiku.dip.security.process.IsolableProcess;
import com.dataiku.dip.security.process.RegularProcess;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppLaunchInfo;
import com.dataiku.dip.webapps.WebAppSecurityInfo;
import com.dataiku.dip.webapps.backend.WebAppBackend;
import com.dataiku.dip.webapps.backend.WebAppBackendKernel;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractWebAppLocalProcessKernel
implements WebAppBackendKernel {
    @Autowired
    private InsecureProcessesLaunchService insecureProcessesLaunchService;
    protected final WebApp webApp;
    protected final AuthCtx authCtx;
    protected final File workingDir;
    protected final DKUtils.LineSubscriptionAttacher mainLog;
    protected final DKUtils.SmartLogTailBuilder smartLogTailBuilder;
    protected Thread shutdownHook;
    protected final DKUtils.ExecOutputConsumer outputConsumer;
    protected IsolableProcess process;
    protected boolean killed;
    public IOException processExitException;
    public int savedReturnCode;
    private KernelMonitorThread monitorThread;
    protected final JsonObject userVariables;
    protected final WebAppLaunchInfo launchInfo;
    protected final WebAppSecurityInfo securityInfo;
    protected final APITicketService.Ticket ticket;
    protected boolean reportComputeResourceUsage = true;
    protected String commandName;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.webapps.abstract");

    public AbstractWebAppLocalProcessKernel(WebApp webApp, AuthCtx authCtx, File workingDir, DKUtils.LineSubscriptionAttacher mainLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder, JsonObject userVariables, WebAppLaunchInfo launchInfo, WebAppSecurityInfo securityInfo, APITicketService.Ticket ticket) {
        this.webApp = webApp;
        this.authCtx = authCtx;
        this.workingDir = workingDir;
        this.mainLog = mainLog;
        this.smartLogTailBuilder = smartLogTailBuilder;
        this.userVariables = userVariables;
        this.launchInfo = launchInfo;
        this.securityInfo = securityInfo;
        this.ticket = ticket;
        SpringUtils.getInstance().autowire((Object)this);
        this.outputConsumer = new DKUtils.ExecOutputConsumer().withThreadsBaseName("KNL-" + webApp.getFullId());
        this.shutdownHook = new Thread(new Runnable(){

            @Override
            public void run() {
                AbstractWebAppLocalProcessKernel.this.killed = true;
                if (AbstractWebAppLocalProcessKernel.this.process != null) {
                    AbstractWebAppLocalProcessKernel.this.tryKill(AbstractWebAppLocalProcessKernel.this.process);
                    AbstractWebAppLocalProcessKernel.this.process = null;
                }
            }
        });
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    protected abstract String getLogPrefix();

    protected abstract boolean impersonate();

    protected ProcessBuilder getProcessBuilder(List<String> cmd, boolean isPythonBackend, Map<String, String> libs, IImpersonationResolverService impersonationResolverService) throws IOException, DKUSecurityException {
        RemoteRunEnvDef envResource = new RemoteRunEnvDef();
        envResource.runsRemotely = false;
        envResource.cwd = this.workingDir.getAbsolutePath();
        EnvironmentStash envStash = this.getEnvironmentForLocalKernel();
        if (isPythonBackend) {
            envStash.env.put("PYTHONIOENCODING", "UTF-8");
        }
        if (this.userVariables != null) {
            envStash.customVariables = (Map)JSON.parse((JsonElement)this.userVariables, (TypeToken)new TypeToken<Map<String, Object>>(){});
        }
        if (this.launchInfo.pluginId != null) {
            envStash.env.put("DKU_PLUGIN_ID", this.launchInfo.pluginId);
        }
        if (this.launchInfo.resourceFolder != null) {
            WebAppBackend.putResourceFolderEnvironmentVariable(envStash.env, this.launchInfo.resourceFolder);
        }
        if (this.launchInfo.config != null) {
            envStash.env.put("DKU_CUSTOM_WEBAPP_CONFIG", JSON.json((Object)this.launchInfo.config));
        }
        if (this.launchInfo.pluginConfig != null) {
            envStash.env.put("DKU_PLUGIN_CONFIG", JSON.pretty((Object)this.launchInfo.pluginConfig));
        }
        ProjectLibPathHelper.ProjectLibsPaths outputPaths = KernelUtils.handlePythonAndRPath(this.authCtx, this.webApp.getProjectKey(), this.launchInfo.useProjectLibs, libs, this.workingDir, impersonationResolverService != null && impersonationResolverService.isEnabled(), null);
        envStash.pythonPath = outputPaths.pythonPath;
        envStash.rsrcPath = outputPaths.rsrcPath;
        envStash.copyToRemoteRunEnvDef(envResource, true, true, false);
        File envFile = new File(this.workingDir, "remote-run-env-def.json");
        logger.info((Object)("Writing dku-exec-env for local execution in " + envFile.getAbsolutePath()));
        DKUFileUtils.writeFileUTF8((File)envFile, (String)JSON.pretty((Object)envResource));
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.environment().putAll(envResource.env);
        return pb;
    }

    protected EnvironmentStash getEnvironmentForLocalKernel() {
        EnvironmentStash envStash = new EnvironmentStash();
        envStash.fillDefault();
        envStash.fillCommunicationVars();
        envStash.setCommunicationVarsForLocalOnlyExecution();
        envStash.apiTicket = this.ticket.getSecret();
        envStash.projectKey = this.webApp.projectKey;
        if (StringUtils.isNotBlank((String)this.launchInfo.envName)) {
            envStash.env.put("DKU_CODE_ENV_NAME", this.launchInfo.envName);
        }
        return envStash;
    }

    @Override
    public void run(WebAppBackendKernel.MainKernelProcess mainKernelProcess) throws Exception {
        logger.info((Object)("Running command : " + Joiner.on((String)" ").join(mainKernelProcess.pb.command())));
        this.commandName = mainKernelProcess.pb.command().get(0);
        if (this.impersonate()) {
            this.process = this.insecureProcessesLaunchService.launch(this.authCtx, this.webApp.projectKey, GeneralSettingsDAO.CGrouppableProcessType.WEBAPP_DEV_BACKEND, this.workingDir, mainKernelProcess.pb);
        } else {
            this.process = new RegularProcess(mainKernelProcess.pb, this.workingDir);
            this.process.start();
        }
        this.outputConsumer.withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.smartLogTailBuilder)).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.smartLogTailBuilder));
        this.outputConsumer.withOutputConsumer((DKUtils.ExecSubscription)this.mainLog.getSubSubscription(this.getLogPrefix())).withErrorConsumer((DKUtils.ExecSubscription)this.mainLog.getSubSubscription(this.getLogPrefix()));
        this.monitorThread = new KernelMonitorThread();
        this.monitorThread.start();
        this.monitorThread.join();
        logger.info((Object)"Monitor thread done");
    }

    @Override
    public Integer getPid() {
        if (this.process != null) {
            return this.process.getWorkingPid();
        }
        return null;
    }

    @Override
    public SmartLogTail getLogTail() {
        logger.info((Object)"Getting webapp log tail");
        if (this.smartLogTailBuilder != null) {
            return this.smartLogTailBuilder.get();
        }
        return null;
    }

    @Override
    public void kill() {
        this.killed = true;
        if (this.process != null) {
            this.tryKill(this.process);
            this.tryUnregisterHook();
            this.process = null;
        }
    }

    protected void tryKill(IsolableProcess process) {
        RegularProcess regularProcess;
        int pid;
        logger.warn((Object)("Killing kernel " + this.webApp.getFullId()));
        if (process instanceof RegularProcess && (pid = (regularProcess = (RegularProcess)process).getWorkingPid()) > 0) {
            try {
                ArrayList pythonCode = Lists.newArrayList();
                pythonCode.add("import os, subprocess");
                pythonCode.add("l = subprocess.check_output(['ps', '-e', '-o', 'pid=', '-o', 'ppid='])");
                pythonCode.add("l = [x.split() for x in l.split('\\n')]");
                pythonCode.add("l = [x[0] for x in l if len(x) > 1 and x[1] == '" + pid + "']");
                pythonCode.add("os.kill(" + pid + ", 9)");
                pythonCode.add("l = [os.kill(int(x), 9) for x in l]");
                DKUtils.execAndLog((String[])new String[]{"python", "-c", Joiner.on((String)"\n").join((Iterable)pythonCode)}, null);
            }
            catch (InterruptedException e) {
                logger.warn((Object)"Unable to kill process group", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (IOException e) {
                logger.warn((Object)"Unable to kill process group", (Throwable)e);
            }
        }
        try {
            process.evilKill();
        }
        catch (IOException e) {
            logger.warn((Object)"failed to kill kernel", (Throwable)e);
        }
    }

    @Override
    public Exception getWebAppProcessRunException() {
        return this.processExitException;
    }

    protected void tryUnregisterHook() {
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (Throwable t) {
                logger.warn((Object)"Failed to remove shutdownHook", t);
            }
        }
        this.shutdownHook = null;
    }

    public static Exposables.Exposable cleanupKernel(WebApp webApp, WebAppLaunchInfo launchInfo, final File workingDir, DKUtils.RotatingLoggingSubscription mainLog2, DKUtils.SmartLogTailBuilder smartLogTailBuilder2) {
        return new Exposables.LocalExposable(){

            @Override
            public void alterCommandLine(List<List<Pattern>> removed, List<SimpleKeyValue> modified, List<List<String>> added) {
            }

            @Override
            public DKUtils.ExecOutputConsumer getExecOutputConsumer() {
                return new DKUtils.ExecOutputConsumer();
            }

            @Override
            public File getTmpDir() {
                return workingDir;
            }

            @Override
            public WebAppSecurityInfo getSecurityInfo() {
                return new WebAppSecurityInfo();
            }
        };
    }

    protected class KernelMonitorThread
    extends Thread {
        protected Thread toInterrupt;
        protected Closeable toClose;

        public synchronized void setInterruptOnFailure(Thread toInterrupt) {
            this.toInterrupt = toInterrupt;
        }

        public synchronized void setCloseOnFailure(Closeable toClose) {
            this.toClose = toClose;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread.currentThread().setName("KNL-" + AbstractWebAppLocalProcessKernel.this.webApp.getFullId() + "-monitor-" + Thread.currentThread().getId());
            try {
                Object cru = null;
                ProcessResourceUsageMonitor resourceMonitorThread = null;
                if (AbstractWebAppLocalProcessKernel.this.reportComputeResourceUsage) {
                    cru = ComputeResourceUsage.forLocalProcess().reportStartNoFail();
                    resourceMonitorThread = new ProcessResourceUsageMonitor(cru, AbstractWebAppLocalProcessKernel.this.commandName, (WithMaybePid)AbstractWebAppLocalProcessKernel.this.process);
                    resourceMonitorThread.start();
                }
                AbstractWebAppLocalProcessKernel.this.outputConsumer.start(AbstractWebAppLocalProcessKernel.this.process.getInputStream(), AbstractWebAppLocalProcessKernel.this.process.getErrorStream(), AbstractWebAppLocalProcessKernel.this.process.getOutputStream());
                int rv = AbstractWebAppLocalProcessKernel.this.process.waitFor();
                logger.info((Object)("Process done with code " + rv));
                AbstractWebAppLocalProcessKernel abstractWebAppLocalProcessKernel = AbstractWebAppLocalProcessKernel.this;
                synchronized (abstractWebAppLocalProcessKernel) {
                    AbstractWebAppLocalProcessKernel.this.savedReturnCode = rv;
                    AbstractWebAppLocalProcessKernel.this.process = null;
                }
                AbstractWebAppLocalProcessKernel.this.tryUnregisterHook();
                AbstractWebAppLocalProcessKernel.this.outputConsumer.finish();
                if (AbstractWebAppLocalProcessKernel.this.reportComputeResourceUsage) {
                    assert (resourceMonitorThread != null);
                    resourceMonitorThread.finish(true);
                    cru.reportCompleteNoFail();
                }
                if (rv != 0) {
                    AbstractWebAppLocalProcessKernel.this.processExitException = new IOException("Kernel process return code is " + rv);
                }
            }
            catch (IOException | InterruptedException e) {
                logger.error((Object)"Failure while running process", (Throwable)e);
            }
            finally {
                KernelMonitorThread kernelMonitorThread = this;
                synchronized (kernelMonitorThread) {
                    if (this.toInterrupt != null) {
                        logger.info((Object)("KernelMonitorThread done: Interrupting : " + String.valueOf(this.toInterrupt)));
                        this.toInterrupt.interrupt();
                    }
                    if (this.toClose != null) {
                        logger.error((Object)("KernelMonitorThread done:  Closing: " + String.valueOf(this.toClose)));
                        IOUtils.closeQuietly((Closeable)this.toClose);
                    }
                }
            }
        }
    }
}

