/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.backend;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exposition.AbstractExposedEndpointCollector;
import com.dataiku.dip.exposition.ExposedEndpointConsumer;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.remoterun.RemoteRunNetworkingUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.AuthCtxCreationService;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPBlacklistVerifier;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.utils.PerfUtils;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppMeta;
import com.dataiku.dip.webapps.WebAppRegistry;
import com.dataiku.dip.webapps.WebAppSecurityInfo;
import com.dataiku.dip.webapps.WebAppsService;
import com.dataiku.dip.webapps.backend.AbstractWebAppBackendRunner;
import com.dataiku.dip.webapps.backend.NginxUtils;
import com.dataiku.dip.webapps.backend.WebAppBackendInstance;
import com.dataiku.dip.webapps.backend.WebAppBackendInstanceStartWaitThread;
import com.dataiku.dip.webapps.plugins.CustomWebAppMeta;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.http.HttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.CloseableHttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpGet;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.DefaultHttpClient;
import com.dataiku.dss.shadelib.org.apache.http.params.BasicHttpParams;
import com.dataiku.dss.shadelib.org.apache.http.params.HttpConnectionParams;
import com.dataiku.dss.shadelib.org.apache.http.params.HttpParams;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.springframework.beans.factory.annotation.Autowired;

public class WebAppBackend
extends AbstractExposedEndpointCollector {
    public static final String FAILED_BACKEND_PROBE_TEXT = "Failed to get html for backend: ";
    @Autowired
    private FutureService futureService;
    @Autowired
    private AuthCtxCreationService authCtxCreationService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private WebAppsService webAppsService;
    private final WebApp webApp;
    public final String backendIdForLegacyMode;
    private final String projectKey;
    private final boolean legacyUrl;
    private WebAppBackendInstance webAppBackendInstance;
    private List<ExposedEndpointConsumer.ExposedEndpoint> registered = Lists.newArrayList();
    private WebAppSecurityInfo securityInfo = new WebAppSecurityInfo();
    private boolean backendForcesAuthentication = false;
    private String proxiedUrlSuffix = null;
    private volatile boolean stopped = false;
    static DKULogger logger = DKULogger.getLogger((String)"dku.webapps.backends");

    public WebAppBackend(WebApp webApp) {
        this.webApp = webApp;
        this.projectKey = webApp.projectKey;
        this.legacyUrl = webApp.hasLegacyBackendURL();
        this.backendIdForLegacyMode = SecretKeyGenerator.generate((int)8);
        SpringUtils.getInstance().autowire((Object)this);
    }

    public void setSecurityInfo(WebAppSecurityInfo securityInfo, boolean backendForcesAuthentication) {
        this.securityInfo = securityInfo;
        this.backendForcesAuthentication = backendForcesAuthentication;
    }

    public void setProxiedUrlSuffix(String proxiedUrlSuffix) {
        this.proxiedUrlSuffix = proxiedUrlSuffix;
    }

    public WebAppMeta getWebAppMeta() {
        return WebAppRegistry.getMeta(this.webApp.type);
    }

    public WebApp.WebAppParams getWebAppParams() {
        return this.webApp.params;
    }

    public String getProjectKey() {
        return this.webApp.projectKey;
    }

    public String getWebAppId() {
        return this.webApp.id;
    }

    public String getWebAppType() {
        return this.webApp.type;
    }

    public static void putResourceFolderEnvironmentVariable(Map<String, String> env, String resourceFolder) {
        env.put("DKU_PLUGIN_RESOURCES", resourceFolder);
        env.put("DKU_CUSTOM_RESOURCE_FOLDER", resourceFolder);
    }

    @Override
    protected synchronized void endpointsChanged(List<ExposedEndpointConsumer.ExposedEndpoint> endpoints) throws Exception {
        this.registered = Lists.newArrayList(endpoints);
        if (this.webAppBackendInstance == null) {
            if (endpoints.size() > 0) {
                throw new IllegalStateException("Trying to register port without an actual backend process running");
            }
        } else {
            this.webAppBackendInstance.setHasExposedEndpoint(endpoints.size() > 0);
        }
        this.writeNewNGINXConfig();
    }

    private synchronized ExposedEndpointConsumer.ExposedEndpoint getOneRegisteredInstance() {
        if (this.registered.size() > 0) {
            return this.registered.get(new Random().nextInt(this.registered.size()));
        }
        return null;
    }

    private synchronized void clearRegisteredInstances() throws Exception {
        super.clear();
    }

    public String getBackendUrl() {
        ExposedEndpointConsumer.ExposedEndpoint hostPort = this.getOneRegisteredInstance();
        return this.getBackendUrl(hostPort);
    }

    public String getBackendUrl(ExposedEndpointConsumer.ExposedEndpoint hostPort) {
        Object urlChunk;
        Object object = urlChunk = this.legacyUrl ? this.backendIdForLegacyMode : this.webApp.id;
        if (hostPort != null && StringUtils.isNotBlank((String)hostPort.id)) {
            urlChunk = (String)urlChunk + "_" + hostPort.id;
        }
        if (this.legacyUrl) {
            return "/html-apps-backends/" + (String)urlChunk + "/";
        }
        return "/web-apps-backends/" + this.projectKey + "/" + (String)urlChunk + "/";
    }

    private HttpGet getProbeUrl() {
        if (this.webAppBackendInstance == null) {
            throw new IllegalStateException("Trying to get backend url before backend process is launched");
        }
        ExposedEndpointConsumer.ExposedEndpoint hostPort = this.getOneRegisteredInstance();
        if (hostPort == null) {
            return null;
        }
        String suffix = this.webAppBackendInstance.getLivelinessPath();
        if (suffix != null) {
            suffix = suffix.replaceAll("\\{baseUrlPort[0-9]+\\}", "{baseUrl}");
            suffix = suffix.replace("${baseUrl}", PathUtils.makeLeadingNoTrailing((String)this.getBackendUrl(hostPort)));
        }
        String hostPortUrl = hostPort.getUrl();
        HttpGet get = new HttpGet(hostPortUrl + suffix);
        for (Map.Entry<String, String> header : hostPort.getProxiedHeaders().entrySet()) {
            get.setHeader(header.getKey(), header.getValue());
        }
        return get;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackendProbingResult probeBackend(int requestTimeout) throws IOException {
        HttpGet request = this.getProbeUrl();
        if (request == null) {
            logger.info((Object)"No backend url ready");
            return new BackendProbingResult();
        }
        BasicHttpParams httpParams = null;
        if (requestTimeout > 0) {
            httpParams = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)requestTimeout);
            HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)requestTimeout);
        }
        logger.info((Object)("Get " + request.getURI().toString()));
        DefaultHttpClient client = "https".equals(request.getURI().getScheme()) ? ConnectionUtils.newNonValidatingHttpClient((HttpParams)httpParams) : new DefaultHttpClient((HttpParams)httpParams);
        client.addRequestInterceptor(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR);
        try {
            CloseableHttpResponse resp = client.execute((HttpUriRequest)request);
            BackendProbingResult backendProbingResult = new BackendProbingResult((HttpResponse)resp, this.backendForcesAuthentication);
            return backendProbingResult;
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private File getConfigFile() {
        if (this.legacyUrl) {
            return ApplicationConfigurator.getFile((String)("install-support/python-backends.d/" + this.backendIdForLegacyMode + ".conf"));
        }
        return ApplicationConfigurator.getFile((String)("install-support/backends.d/" + this.projectKey + "/" + this.webApp.id + ".conf"));
    }

    public static void clearNginxConfs() {
        try {
            DKUFileUtils.forceDelete((File)ApplicationConfigurator.getFile((String)"install-support/python-backends.d/"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            DKUFileUtils.forceDelete((File)ApplicationConfigurator.getFile((String)"install-support/backends.d/"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            NginxUtils.hupNginx();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @VisibleForTesting
    List<String> getNGINXConfig(ExposedEndpointConsumer.ExposedEndpoint hostPort) throws CodedIOException {
        Object proxiedUrl = hostPort.getUrl();
        String backendUrl = this.getBackendUrl(hostPort);
        if (StringUtils.isNotBlank((String)this.proxiedUrlSuffix) && !"/".equals(this.proxiedUrlSuffix)) {
            HashMap replacements = Maps.newHashMap();
            replacements.put("projectKey", this.webApp.projectKey);
            replacements.put("codeStudioId", this.webApp.id);
            replacements.put("backendUrl", backendUrl);
            StrSubstitutor subst = new StrSubstitutor((Map)replacements, "${", "}");
            String userProxiedUrlPart = subst.replace(StringUtils.defaultIfBlank((String)this.proxiedUrlSuffix, (String)"")).replaceAll("//", "/");
            if (StringUtils.isBlank((String)userProxiedUrlPart)) {
                if (!((String)proxiedUrl).endsWith("/")) {
                    proxiedUrl = (String)proxiedUrl + "/";
                }
            } else {
                while (((String)proxiedUrl).endsWith("/")) {
                    proxiedUrl = ((String)proxiedUrl).substring(0, ((String)proxiedUrl).length() - 1);
                }
                proxiedUrl = (String)proxiedUrl + userProxiedUrlPart;
            }
        } else {
            proxiedUrl = (String)proxiedUrl + "/";
        }
        return WebAppBackend.buildNGINXConfig(backendUrl, (String)proxiedUrl, hostPort.getProxiedHeaders(), this.webApp.projectKey, this.webApp.id, this.webApp.type, this.securityInfo);
    }

    @VisibleForTesting
    List<String> getDirectURLsNGINXConfig(ExposedEndpointConsumer.ExposedEndpoint hostPort) {
        return WebAppBackend.buildDirectURLsNGINXConfig(this.getBackendUrl(hostPort), this.webApp.projectKey, this.webApp.id, this.webApp.type, this.securityInfo);
    }

    public static List<String> buildNGINXConfig(String backendUrl, String proxiedUrl, Map<String, String> proxiedHeaders, String projectKey, String webAppId, String webAppType, WebAppSecurityInfo securityInfo) throws CodedIOException {
        IPBlacklistVerifier.validateUriNotBlacklisted(proxiedUrl, false);
        if (securityInfo == null) {
            securityInfo = new WebAppSecurityInfo();
        }
        ArrayList nginxLocations = Lists.newArrayList();
        ArrayList fullLocations = Lists.newArrayList();
        Object accessTokenCookieHiding = securityInfo.hideAccessToken ? "  set $new_cookie $http_cookie; \n  if ($http_cookie ~ \"^(.*)\\s*" + securityInfo.accessTokenCookieName + "\\s*=[^;]+;(.*)$\") { \n    set $new_cookie $1$2; \n  } \n  if ($http_cookie ~ \"^(.*)\\s*" + securityInfo.accessTokenCookieName + "\\s*=[^;]+\\s*$\") { \n    set $new_cookie $1; \n  } \n  proxy_set_header Cookie $new_cookie; \n" : "";
        String proxiedHeadersString = proxiedHeaders.entrySet().stream().map(e -> String.format("  proxy_set_header %s \"%s\";\n", e.getKey(), e.getValue())).collect(Collectors.joining());
        String extraProxyLocationCommands = (String)accessTokenCookieHiding + proxiedHeadersString;
        extraProxyLocationCommands = extraProxyLocationCommands + "  proxy_http_version 1.1; \n  proxy_set_header Upgrade $http_upgrade; \n  proxy_set_header Connection \"upgrade\"; \n";
        com.dataiku.dip.utils.NginxUtils.ensureSafe((String)webAppId);
        String baseBackendUrlLT = PathUtils.slashes((String)com.dataiku.dip.utils.NginxUtils.ensureSafe((String)backendUrl), (Boolean)true, (Boolean)true, (boolean)true, (String)"/");
        if (securityInfo.backendCheckAccess) {
            String authId = "auth_" + SecretKeyGenerator.generate((int)6);
            String protectedLocation = "location ^~ " + baseBackendUrlLT + " {\n  resolver 127.0.0.1;\n  if ($custom_basehref = false) {\n     set $custom_basehref \"\";\n  }\n  proxy_set_header \"X-DKU-BaseHRef\" \"$custom_basehref\";\n  proxy_pass " + proxiedUrl + ";\n  proxy_next_upstream off; # Don't retry\n  proxy_read_timeout 3600; # We have long queries\n  auth_request /" + authId + ";\n  auth_request_set $auth_studiourl $upstream_http_x_dku_studiourl;\n  auth_request_set $auth_accessforbiddenreason $upstream_http_x_dku_accessforbiddenreason;\n  error_page 502 /webapp-error-502.html;\n  error_page 401 @error_location_" + authId + ";\n  error_page 403 @reject_location_" + authId + ";\n" + extraProxyLocationCommands;
            String authLocation = "location = /" + authId + " {\n  proxy_pass http://127.0.0.1:" + RemoteRunNetworkingUtils.getBackendPortForLocalAccess() + "/dip/api/webapps/check-access/" + projectKey + "/" + webAppId + "/;\n  proxy_pass_request_body off;\n  proxy_set_header Content-Length \"\";\n  proxy_set_header Content-Type \"\";\n  proxy_set_header Sec-WebSocket-Protocol \"\";\n  proxy_set_header X-Original-URI $request_uri;\n}";
            GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
            if (StringUtils.isNotBlank((String)generalSettings.webAppSecuritySettings.webAppAuthCustomRedirectUrl)) {
                errorLocation = "location @error_location_" + authId + " {\n  return 302 " + baseBackendUrlLT + "redirect-login/login;\n}";
                fullLocations.add(errorLocation);
                String loginLocation = "location ^~ " + baseBackendUrlLT + "redirect-login/ {\n  resolver 127.0.0.1;\n  proxy_pass " + generalSettings.webAppSecuritySettings.webAppAuthCustomRedirectUrl + ";\n  proxy_set_header X-DKU-projectKey " + projectKey + ";\n  proxy_set_header X-DKU-webAppId " + webAppId + ";\n  proxy_set_header X-DKU-webAppType " + webAppType + ";\n  proxy_next_upstream off; # Don't retry\n  proxy_read_timeout 3600; # We have long queries\n  error_page 502 /webapp-error-502.html;\n";
                nginxLocations.add(loginLocation);
            } else {
                errorLocation = "location @error_location_" + authId + " {\n  try_files /webapp-error-401.html /webapp-error-401.html;\n}";
                fullLocations.add(errorLocation);
            }
            String rejectLocation = "location @reject_location_" + authId + " {\n  try_files /webapp-error-403.html /webapp-error-403.html;\n  sub_filter \"ERROR_MESSAGE_PLACEHOLDER\" $auth_accessforbiddenreason;\n  sub_filter_once on;\n}";
            fullLocations.add(rejectLocation);
            nginxLocations.add(protectedLocation);
            fullLocations.add(authLocation);
        } else {
            String baseLocation = "location ^~ " + baseBackendUrlLT + " {\n  resolver 127.0.0.1;\n  if ($custom_basehref = false) {\n     set $custom_basehref \"\";\n  }\n  proxy_set_header \"X-DKU-BaseHRef\" \"$custom_basehref\";\n  proxy_pass " + proxiedUrl + ";\n  proxy_next_upstream off; # Don't retry\n  proxy_read_timeout 3600; # We have long queries\n  error_page 502 /webapp-error-502.html;\n" + extraProxyLocationCommands;
            nginxLocations.add(baseLocation);
        }
        fullLocations.addAll(WebAppBackend.addCorsHeadersAndClose(nginxLocations));
        return fullLocations;
    }

    public static List<String> buildDirectURLsNGINXConfig(String backendUrl, String projectKey, String webAppId, String webAppType, WebAppSecurityInfo securityInfo) {
        if (securityInfo == null) {
            securityInfo = new WebAppSecurityInfo();
        }
        ArrayList nginxLocations = Lists.newArrayList();
        nginxLocations.addAll(WebAppBackend.publishWebappOnPrefix("/webapps/", backendUrl, projectKey, webAppId, webAppType, securityInfo));
        nginxLocations.addAll(WebAppBackend.publishWebappOnPrefix("/public-webapps/", backendUrl, projectKey, webAppId, webAppType, securityInfo));
        return WebAppBackend.addCorsHeadersAndClose(nginxLocations);
    }

    private static List<String> publishWebappOnPrefix(String prefix, String backendUrl, String projectKey, String webAppId, String webAppType, WebAppSecurityInfo securityInfo) {
        ArrayList nginxLocations = Lists.newArrayList();
        String baseBackendUrlLT = PathUtils.slashes((String)com.dataiku.dip.utils.NginxUtils.ensureSafe((String)backendUrl), (Boolean)true, (Boolean)true, (boolean)true, (String)"/");
        String safePkey = com.dataiku.dip.utils.NginxUtils.ensureSafe((String)projectKey);
        String safeId = com.dataiku.dip.utils.NginxUtils.ensureSafe((String)webAppId);
        String safeVanity = securityInfo.vanityURL == null ? null : com.dataiku.dip.utils.NginxUtils.ensureSafe((String)securityInfo.vanityURL);
        String regularLocationLocation = prefix + safePkey + "/" + safeId;
        String vanityLocationLocation = prefix + safeVanity;
        String regularLocationContent = null;
        String vanityLocationContent = null;
        String effectiveWebAppType = WebAppRegistry.getMeta(webAppType).isCustomWebApp() ? ((CustomWebAppMeta)WebAppRegistry.getMeta(webAppType)).getBaseType() : webAppType;
        switch (effectiveWebAppType) {
            case "STANDARD": {
                String standardBaseBackendUrl = "/dip/api/webapps/view?projectKey=" + safePkey + "&webAppId=" + safeId;
                regularLocationContent = WebAppBackend.rewriteRedirectLine(securityInfo, WebappRewrite.redirect("(" + regularLocationLocation + ")", "$1/")) + "  rewrite ^" + regularLocationLocation + "/(.*)$ " + standardBaseBackendUrl + " last;\n";
                vanityLocationContent = WebAppBackend.rewriteRedirectLine(securityInfo, WebappRewrite.redirect("(" + vanityLocationLocation + ")", "$1/")) + "  rewrite ^" + vanityLocationLocation + "/(.*)$ " + standardBaseBackendUrl + " last;\n";
                break;
            }
            case "DASH": {
                regularLocationContent = WebAppBackend.rewriteRedirectLine(securityInfo, WebappRewrite.redirect("(" + regularLocationLocation + ")", "$1/")) + "  rewrite ^" + regularLocationLocation + "/(.*)$ " + baseBackendUrlLT + "$1 last;\n";
                vanityLocationContent = WebAppBackend.rewriteRedirectLine(securityInfo, WebappRewrite.redirect("(" + vanityLocationLocation + ")", "$1/")) + "  rewrite ^" + vanityLocationLocation + "/(.*)$ " + baseBackendUrlLT + "$1 last;\n";
                break;
            }
            case "BOKEH": {
                regularLocationContent = WebAppBackend.rewriteRedirectLine(securityInfo, WebappRewrite.redirect("(" + regularLocationLocation + ")", "$1/backend"), WebappRewrite.redirect("(" + regularLocationLocation + ")/", "$1/backend")) + "  rewrite ^" + regularLocationLocation + "/(.*)$ " + baseBackendUrlLT + "$1 last;\n";
                vanityLocationContent = WebAppBackend.rewriteRedirectLine(securityInfo, WebappRewrite.redirect("(" + vanityLocationLocation + ")", "$1/backend"), WebappRewrite.redirect("(" + vanityLocationLocation + ")/", "$1/backend")) + "  rewrite ^" + vanityLocationLocation + "/(.*)$ " + baseBackendUrlLT + "$1 last;\n";
                break;
            }
            case "SHINY": {
                regularLocationContent = WebAppBackend.rewriteRedirectLine(securityInfo, WebappRewrite.redirect("(" + regularLocationLocation + ")", "$1/")) + "  rewrite ^" + regularLocationLocation + "/(.*)$ " + baseBackendUrlLT + "$1 last;\n";
                vanityLocationContent = WebAppBackend.rewriteRedirectLine(securityInfo, WebappRewrite.redirect("(" + vanityLocationLocation + ")", "$1/")) + "  rewrite ^" + vanityLocationLocation + "/(.*)$ " + baseBackendUrlLT + "$1 last;\n";
                break;
            }
            case "CODE_STUDIO_AS_WEBAPP": {
                regularLocationContent = WebAppBackend.rewriteRedirectLine(securityInfo, WebappRewrite.redirect("(" + regularLocationLocation + ")", "$1/")) + "  rewrite ^" + regularLocationLocation + "/(.*)$ " + baseBackendUrlLT + "$1 last;\n";
                vanityLocationContent = WebAppBackend.rewriteRedirectLine(securityInfo, WebappRewrite.redirect("(" + vanityLocationLocation + ")", "$1/")) + "  rewrite ^" + vanityLocationLocation + "/(.*)$ " + baseBackendUrlLT + "$1 last;\n";
            }
        }
        if (regularLocationContent != null) {
            String regularLocationFragment = "location ^~ " + regularLocationLocation + " {\n  set $custom_basehref \"" + regularLocationLocation + "\";\n" + regularLocationContent;
            nginxLocations.add(regularLocationFragment);
        }
        if (StringUtils.isNotBlank((String)safeVanity) && vanityLocationContent != null) {
            String vanityLocationFragment = "location ^~ " + vanityLocationLocation + " {\n  set $custom_basehref \"" + vanityLocationLocation + "\";\n" + vanityLocationContent;
            nginxLocations.add(vanityLocationFragment);
        }
        return nginxLocations;
    }

    public static String rewriteRedirectLine(WebAppSecurityInfo securityInfo, WebappRewrite ... redirects) {
        ArrayList lines = Lists.newArrayList();
        switch (securityInfo.redirectMode) {
            case DEFAULT: {
                lines.addAll(WebAppBackend.getDefaultRewriteRedirectLines(redirects));
                break;
            }
            case RELATIVE_URL: {
                lines.add("  absolute_redirect off;");
                for (WebappRewrite redirect : redirects) {
                    lines.add("  rewrite ^" + redirect.from + "$ " + redirect.to + " redirect;");
                }
                break;
            }
            case USE_STUDIO_URL: {
                if (StringUtils.isNotBlank((String)securityInfo.studioUrl)) {
                    Object studioUrl = securityInfo.studioUrl;
                    if (((String)studioUrl).endsWith("/")) {
                        studioUrl = ((String)studioUrl).substring(0, ((String)studioUrl).lastIndexOf("/"));
                    }
                    if (!((String)studioUrl).contains("://")) {
                        if (((String)studioUrl).startsWith("/")) {
                            studioUrl = ((String)studioUrl).substring(1);
                        }
                        studioUrl = "http://" + (String)studioUrl;
                    }
                    for (WebappRewrite redirect : redirects) {
                        lines.add("  rewrite ^" + redirect.from + "$ " + (String)studioUrl + redirect.to + " redirect;");
                    }
                    break;
                }
                lines.addAll(WebAppBackend.getDefaultRewriteRedirectLines(redirects));
            }
        }
        return Joiner.on((String)"\n").join((Iterable)lines) + "\n";
    }

    public static List<String> getDefaultRewriteRedirectLines(WebappRewrite ... redirects) {
        ArrayList lines = Lists.newArrayList();
        for (WebappRewrite redirect : redirects) {
            lines.add("  rewrite ^" + redirect.from + "$ " + redirect.to + " redirect;");
        }
        return lines;
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> addCorsHeadersAndClose(List<String> nginxLocations) {
        ArrayList fullLocations = Lists.newArrayList();
        GeneralSettingsDAO.CorsSettings corsSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().corsSettings;
        for (String string : nginxLocations) {
            void var4_17;
            if (corsSettings.accessControlAllowOriginRegExps.size() > 0) {
                String string2 = string + "  add_header 'Access-Control-Allow-Origin' '" + Joiner.on((String)", ").join(corsSettings.accessControlAllowOriginRegExps) + "';\n";
            }
            if (corsSettings.accessControlAllowHeaders.size() > 0) {
                void var4_7;
                String string3 = (String)var4_7 + "  add_header 'Access-Control-Allow-Headers' '" + Joiner.on((String)", ").join(corsSettings.accessControlAllowHeaders) + "';\n";
            }
            if (corsSettings.accessControlAllowMethods.size() > 0) {
                void var4_9;
                String string4 = (String)var4_9 + "  add_header 'Access-Control-Allow-Methods' '" + Joiner.on((String)", ").join(corsSettings.accessControlAllowMethods) + "';\n";
            }
            if (corsSettings.accessControlExposeHeaders.size() > 0) {
                void var4_11;
                String string5 = (String)var4_11 + "  add_header 'Access-Control-Allow-Headers' '" + Joiner.on((String)", ").join(corsSettings.accessControlExposeHeaders) + "';\n";
            }
            if (corsSettings.accessControlMaxAge != null) {
                void var4_13;
                String string6 = (String)var4_13 + "  add_header 'Access-Control-Max-Age' '" + String.valueOf(corsSettings.accessControlMaxAge) + "';\n";
            }
            if (corsSettings.accessControlAllowCredentials) {
                void var4_15;
                String string7 = (String)var4_15 + "  add_header 'Access-Control-Allow-Credentials' true;\n";
            }
            String string8 = (String)var4_17 + "}\n";
            fullLocations.add(string8);
        }
        return fullLocations;
    }

    private synchronized void writeNewNGINXConfig() throws Exception {
        boolean needToAddASingleWebappBackend;
        ArrayList hostPorts = Lists.newArrayList(this.registered);
        ArrayList configs = Lists.newArrayList();
        for (ExposedEndpointConsumer.ExposedEndpoint hostPort : hostPorts) {
            configs.addAll(this.getNGINXConfig(hostPort));
        }
        if (!hostPorts.isEmpty()) {
            configs.addAll(this.getDirectURLsNGINXConfig((ExposedEndpointConsumer.ExposedEndpoint)hostPorts.get(0)));
        }
        boolean bl = needToAddASingleWebappBackend = !hostPorts.isEmpty() && hostPorts.stream().allMatch(hp -> StringUtils.isNotBlank((String)hp.id));
        if (needToAddASingleWebappBackend) {
            ExposedEndpointConsumer.ExposedEndpoint hostPortWithoutId = (ExposedEndpointConsumer.ExposedEndpoint)JSON.deepCopy((Object)((ExposedEndpointConsumer.ExposedEndpoint)hostPorts.get(0)));
            hostPortWithoutId.id = null;
            configs.addAll(this.getNGINXConfig(hostPortWithoutId));
        }
        File configFile = this.getConfigFile();
        DKUFileUtils.mkdirsParent((File)configFile);
        DKUFileUtils.writeFileUTF8((File)configFile, (String)Joiner.on((String)"\n\n").join((Iterable)configs));
        NginxUtils.hupNginx();
    }

    public FutureResponse<WebAppBackendInstance.BackendState> updateCurrentState(AuthCtx authCtx, WebApp webApp, JsonObject userVariables, boolean forceRestartBackend, boolean keepFutureIdInState) throws Exception {
        WebAppBackendInstance instance = this.webAppBackendInstance;
        logger.info((Object)("Current state s=" + String.valueOf((Object)instance)));
        WebAppBackendInstance testInstance = new WebAppBackendInstance(this.buildActualAuthCtx(authCtx, webApp), webApp, userVariables, this);
        if (instance != null && instance.isRunning() && !forceRestartBackend && StringUtils.equals((String)testInstance.getHash(), (String)instance.getHash())) {
            logger.info((Object)"Server already running with proper code, code env, config and authCtx => doing nothing");
            FutureResponse fr = new FutureResponse();
            fr.hasResult = true;
            fr.result = this.getBackendState(instance, keepFutureIdInState);
            return fr;
        }
        return this.stopAndStart(authCtx, webApp, userVariables, keepFutureIdInState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureResponse<WebAppBackendInstance.BackendState> stopAndStart(AuthCtx authCtx, WebApp webApp, JsonObject userVariables, boolean keepFutureIdInState) throws Exception {
        WebAppBackendInstance instanceToStart;
        WebAppBackendInstance instanceToStop;
        AuthCtx realAuthCtx = this.buildActualAuthCtx(authCtx, webApp);
        logger.info((Object)("Starting webapp backend with authCtx: " + String.valueOf(realAuthCtx)));
        WebAppBackend webAppBackend = this;
        synchronized (webAppBackend) {
            instanceToStop = this.webAppBackendInstance;
            if (!this.stopped) {
                instanceToStart = new WebAppBackendInstance(realAuthCtx, webApp, userVariables, this);
                instanceToStart.instanceId = SecretKeyGenerator.generate((int)8);
                this.webAppBackendInstance = instanceToStart;
            } else {
                instanceToStart = null;
            }
        }
        try {
            this.stopInstance(instanceToStop);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to stop webapp backend", (Throwable)e);
        }
        if (instanceToStart != null) {
            this.dumpPersistedInstanceInfo(instanceToStart);
            this.futureService.registerAndStartNoWait(instanceToStart);
            if (webApp.isVirtual) {
                ((WebAppsService)SpringUtils.getBean(WebAppsService.class)).putVirtualWebApp(authCtx, webApp);
            }
            return this.futureService.runFuture(new WebAppBackendInstanceStartWaitThread(realAuthCtx, webApp, this, instanceToStart, keepFutureIdInState), 0L, new TypeToken<FutureResponse<WebAppBackendInstance.BackendState>>(){});
        }
        throw new Exception("Backend was stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        WebAppBackendInstance instanceToStop;
        logger.info((Object)("Stopping backend for webapp " + this.webApp.projectKey + "." + this.webApp.id + " (legacyBackendId: " + this.backendIdForLegacyMode + ")"));
        WebAppBackend webAppBackend = this;
        synchronized (webAppBackend) {
            instanceToStop = this.webAppBackendInstance;
            this.stopped = true;
        }
        this.stopInstance(instanceToStop);
    }

    private void stopInstance(WebAppBackendInstance instanceToStop) throws Exception {
        this.clearRegisteredInstances();
        if (instanceToStop != null) {
            instanceToStop.stopAndWait();
            this.clearPersistedInstanceInfo();
        } else if (this.hasPersistedInstanceInfo()) {
            try {
                WebAppBackendInstance cleanupInstance = this.getInstanceFromPersistedInfo();
                cleanupInstance.stopDanglingRun();
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to cleanup previous webapp backend", (Throwable)e);
            }
            this.clearPersistedInstanceInfo();
        }
    }

    private File getInstancePersistedInfoFile() {
        return new File(AbstractWebAppBackendRunner.getWebAppsWorkingDir(this.webApp.projectKey), "instance-info-" + this.webApp.id + ".json");
    }

    private WebAppBackendInstance getInstanceFromPersistedInfo() throws IOException {
        File f = this.getInstancePersistedInfoFile();
        WebAppBackendInstanceInfo info = (WebAppBackendInstanceInfo)JSON.parseFile((File)f, WebAppBackendInstanceInfo.class);
        WebAppBackendInstance instance = new WebAppBackendInstance(info.authCtx, this.webApp, info.userVariables, this);
        instance.instanceId = info.instanceId;
        return instance;
    }

    public boolean hasPersistedInstanceInfo() {
        File f = this.getInstancePersistedInfoFile();
        return f.exists() && f.isFile();
    }

    private void clearPersistedInstanceInfo() {
        File f = this.getInstancePersistedInfoFile();
        if (f.exists() && !f.delete()) {
            logger.warn((Object)("Unable to clear persisted instance info file: " + f.getAbsolutePath()));
        }
    }

    private void dumpPersistedInstanceInfo(WebAppBackendInstance instance) throws IOException {
        File f = this.getInstancePersistedInfoFile();
        DKUFileUtils.mkdirsParent((File)f);
        if (f.exists() && !f.delete()) {
            logger.warn((Object)("Unable to clear persisted instance info file: " + f.getAbsolutePath()));
        }
        WebAppBackendInstanceInfo info = new WebAppBackendInstanceInfo();
        info.authCtx = instance.getOwner();
        info.userVariables = instance.userVariables;
        info.instanceId = instance.instanceId;
        JSON.prettyToFile((Object)info, (File)f);
    }

    public WebAppBackendInstance.BackendState getState(boolean keepFutureIdInState) throws IOException {
        return this.getBackendState(this.webAppBackendInstance, keepFutureIdInState);
    }

    public AuthCtx getCurrentAuthCtx() {
        WebAppBackendInstance current = this.webAppBackendInstance;
        return current != null ? current.getOwner() : null;
    }

    public WebAppBackendInstance.BackendState getBackendState(WebAppBackendInstance instance, boolean keepFutureId) throws IOException {
        if (instance == null) {
            return new WebAppBackendInstance.BackendState(this.webApp);
        }
        WebAppBackendInstance.BackendState backendState = instance.getBackendState(keepFutureId);
        backendState.exposed = this.getOneRegisteredInstance();
        return backendState;
    }

    public AuthCtx buildActualAuthCtx(AuthCtx orig, WebApp webApp) throws DKUSecurityException {
        if (TransactionContext.hasAttachedTransaction()) {
            return this.webAppsService.buildActualAuthCtx_T(orig, webApp);
        }
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.webAppsService.buildActualAuthCtx_T(orig, webApp);
            return authCtx;
        }
    }

    public static class BackendProbingResult {
        public int code;
        public String html;

        public BackendProbingResult() {
            this.code = -1;
            this.html = null;
        }

        public BackendProbingResult(HttpResponse resp, boolean forceAuthentication) throws IOException {
            this.code = resp.getStatusLine().getStatusCode();
            this.html = this.code == 200 ? IOUtils.toString((InputStream)resp.getEntity().getContent(), (Charset)StandardCharsets.UTF_8) : (this.code == 401 && forceAuthentication ? "Expected auth failure because test call has no auth" : WebAppBackend.FAILED_BACKEND_PROBE_TEXT + IOUtils.toString((InputStream)resp.getEntity().getContent(), (Charset)StandardCharsets.UTF_8));
        }
    }

    private static class WebappRewrite {
        public String from;
        public String to;

        private WebappRewrite() {
        }

        public static WebappRewrite redirect(String from, String to) {
            WebappRewrite rewrite = new WebappRewrite();
            rewrite.from = from;
            rewrite.to = to;
            return rewrite;
        }
    }

    private static class WebAppBackendInstanceInfo {
        public String instanceId;
        public JsonObject userVariables;
        public DSSAuthCtx authCtx;

        private WebAppBackendInstanceInfo() {
        }
    }
}

