/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.backend;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.exposition.Exposables;
import com.dataiku.dip.exposition.ExposedEndpointConsumer;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dip.webapps.WebAppSecurityInfo;
import com.dataiku.dip.webapps.backend.WebAppBackendInstance;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface WebAppBackendKernel {
    public MainKernelProcess prepareRun(WebAppBackendInstance var1, ExposedEndpointConsumer.ExposedEndpoint var2) throws Exception;

    public void run(MainKernelProcess var1) throws Exception;

    public void kill();

    public SmartLogTail getLogTail();

    public Integer getPid();

    public Exception getWebAppProcessRunException();

    public static class KubernetesMainKernelProcess
    extends MainKernelProcess
    implements Exposables.KubernetesExposable {
        private final String executionId;
        private final int containerPort;
        private final String deploymentName;
        private final AuthCtx authCtx;
        private final String projectKey;
        private final String webappId;

        public KubernetesMainKernelProcess(ProcessBuilder pb, DKUtils.ExecOutputConsumer eoc, String executionId, int containerPort, String deploymentName, AuthCtx authCtx, String projectKey, String webappId) {
            super(pb, eoc);
            this.executionId = executionId;
            this.containerPort = containerPort;
            this.deploymentName = deploymentName;
            this.authCtx = authCtx;
            this.projectKey = projectKey;
            this.webappId = webappId;
        }

        @Override
        public File getTmpDir() {
            return this.pb.directory();
        }

        @Override
        public String getExecutionId() {
            return this.executionId;
        }

        public String getDeploymentName() {
            return this.deploymentName;
        }

        @Override
        public String getNamePrefix() {
            return "dku-webapp";
        }

        @Override
        public Map<String, String> getLabels() {
            HashMap<String, String> labels = new HashMap<String, String>();
            labels.put("dataiku.com/dku-execution-id", this.executionId);
            return labels;
        }

        @Override
        public Map<String, String> getAnnotations() {
            HashMap<String, String> annotations = new HashMap<String, String>();
            annotations.put("dataiku.com/dku-execution-type", ComputeResourceUsageContext.ComputeResourceUsageContextType.WEBAPP_BACKEND.name());
            annotations.put("dataiku.com/dku-exec-submitter", this.authCtx.getIdentifier());
            annotations.put("dataiku.com/dku-install-id", ApplicationConfigurator.getInstallId());
            annotations.put("dataiku.com/dku-project-key", this.projectKey);
            annotations.put("dataiku.com/dku-webapp-id", this.webappId);
            return annotations;
        }

        @Override
        public Map<String, String> getSelectors() {
            HashMap<String, String> selectors = new HashMap<String, String>();
            selectors.put("dataiku.com/dku-execution-id", this.executionId);
            return selectors;
        }

        @Override
        public int getContainerizedPort() {
            return this.containerPort;
        }

        @Override
        public String getExposedService() {
            return null;
        }

        @Override
        public String getPropertiesPrefix() {
            return "webapp";
        }

        @Override
        public List<SimpleKeyValue> getProperties() {
            return Lists.newArrayList();
        }
    }

    public static class DockerMainKernelProcess
    extends AlterableCommandLineMainKernelProcess
    implements Exposables.DockerExposable {
        private final int containerPort;

        public DockerMainKernelProcess(ProcessBuilder pb, DKUtils.ExecOutputConsumer eoc, int containerPort) {
            super(pb, eoc);
            this.containerPort = containerPort;
        }

        @Override
        protected int insertionPos() {
            return 2;
        }

        @Override
        public int getContainerizedPort() {
            return this.containerPort;
        }
    }

    public static class LocalMainKernelProcess
    extends AlterableCommandLineMainKernelProcess
    implements Exposables.LocalExposable {
        private final File workingDir;
        private final WebAppSecurityInfo securityInfo;

        public LocalMainKernelProcess(ProcessBuilder pb, DKUtils.ExecOutputConsumer eoc, File workingDir, WebAppSecurityInfo securityInfo) {
            super(pb, eoc);
            this.workingDir = workingDir;
            this.securityInfo = securityInfo;
        }

        @Override
        public DKUtils.ExecOutputConsumer getExecOutputConsumer() {
            return this.eoc;
        }

        @Override
        protected int insertionPos() {
            return this.pb.command().size();
        }

        @Override
        public File getTmpDir() {
            return this.workingDir;
        }

        @Override
        public WebAppSecurityInfo getSecurityInfo() {
            return this.securityInfo;
        }
    }

    public static abstract class AlterableCommandLineMainKernelProcess
    extends MainKernelProcess
    implements Exposables.AlterableCommandLineExposable {
        public AlterableCommandLineMainKernelProcess(ProcessBuilder pb, DKUtils.ExecOutputConsumer eoc) {
            super(pb, eoc);
        }

        protected abstract int insertionPos();

        /*
         * WARNING - void declaration
         */
        @Override
        public void alterCommandLine(List<List<Pattern>> removed, List<SimpleKeyValue> modified, List<List<String>> added) {
            void var6_10;
            List<String> cmd = this.pb.command();
            for (List<Pattern> list : removed) {
                for (int i = 0; i <= cmd.size() - list.size(); ++i) {
                    int j;
                    boolean matches = true;
                    for (j = 0; j < list.size(); ++j) {
                        matches &= list.get(j).matcher(cmd.get(i + j)).matches();
                    }
                    if (!matches) continue;
                    for (j = 0; j < list.size(); ++j) {
                        cmd.remove(i);
                    }
                    --i;
                }
            }
            int pos = this.insertionPos();
            for (List<String> list : added) {
                for (String x : list) {
                    cmd.add(pos, x);
                    ++pos;
                }
            }
            boolean bl = false;
            while (var6_10 < cmd.size()) {
                void var7_16;
                String string = cmd.get((int)var6_10);
                for (SimpleKeyValue modif : modified) {
                    Pattern pattern = Pattern.compile(modif.key);
                    Matcher matcher = pattern.matcher(string);
                    if (!matcher.matches()) continue;
                    StringBuffer sb = new StringBuffer();
                    matcher.appendReplacement(sb, modif.value);
                    String string2 = sb.toString();
                    break;
                }
                cmd.set((int)var6_10, (String)var7_16);
                ++var6_10;
            }
            this.pb.command(cmd);
        }
    }

    public static abstract class MainKernelProcess {
        public ProcessBuilder pb;
        public DKUtils.ExecOutputConsumer eoc;

        public MainKernelProcess(ProcessBuilder pb, DKUtils.ExecOutputConsumer eoc) {
            this.pb = pb;
            this.eoc = eoc;
        }
    }
}

