/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.plugins;

import com.dataiku.dip.custom.IElementLoadedDesc;
import com.dataiku.dip.custom.IPluginifiedMeta;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppHandler;
import com.dataiku.dip.webapps.WebAppMeta;
import com.dataiku.dip.webapps.WebAppRegistry;
import com.dataiku.dip.webapps.backend.WebAppBackend;
import com.dataiku.dip.webapps.backend.WebAppBackendInstance;
import com.dataiku.dip.webapps.backend.WebAppBackendRunner;
import com.dataiku.dip.webapps.bokeh.BokehWebAppMeta;
import com.dataiku.dip.webapps.bokeh.CustomBokehWebAppHandler;
import com.dataiku.dip.webapps.bokeh.backend.BokehWebAppBackendRunner;
import com.dataiku.dip.webapps.dash.CustomDashWebAppHandler;
import com.dataiku.dip.webapps.dash.DashWebAppMeta;
import com.dataiku.dip.webapps.dash.backend.DashWebAppBackendRunner;
import com.dataiku.dip.webapps.plugins.LoadedCustomWebApp;
import com.dataiku.dip.webapps.plugins.WebAppDesc;
import com.dataiku.dip.webapps.shiny.CustomShinyWebAppHandler;
import com.dataiku.dip.webapps.shiny.ShinyWebAppMeta;
import com.dataiku.dip.webapps.shiny.backend.ShinyWebAppBackendRunner;
import com.dataiku.dip.webapps.standard.CustomStandardWebAppHandler;
import com.dataiku.dip.webapps.standard.StandardWebAppMeta;
import com.dataiku.dip.webapps.standard.backend.StandardWebAppBackendRunner;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class CustomWebAppMeta
implements WebAppMeta,
IPluginifiedMeta {
    public final LoadedCustomWebApp loaded;

    public CustomWebAppMeta(LoadedCustomWebApp loaded) {
        this.loaded = loaded;
    }

    @Override
    public String getType() {
        return this.loaded.getType();
    }

    @Override
    public boolean isCustomWebApp() {
        return true;
    }

    @Override
    public Class<? extends WebApp.WebAppParams> getParamsClass() {
        return WebAppRegistry.getMeta(this.getBaseType()).getParamsClass();
    }

    @Override
    public WebAppBackendRunner buildRunner(WebApp webapp, WebAppBackend webappBackend, JsonObject userVariables, AuthCtx user, WebAppBackendInstance webAppBackendInstance) {
        switch (this.getBaseType()) {
            case "STANDARD": {
                return new StandardWebAppBackendRunner(webapp, webappBackend, userVariables, user, webAppBackendInstance);
            }
            case "SHINY": {
                return new ShinyWebAppBackendRunner(webapp, webappBackend, userVariables, user, webAppBackendInstance);
            }
            case "BOKEH": {
                return new BokehWebAppBackendRunner(webapp, webappBackend, userVariables, user, webAppBackendInstance);
            }
            case "DASH": {
                return new DashWebAppBackendRunner(webapp, webappBackend, userVariables, user, webAppBackendInstance);
            }
        }
        throw new Error("Not implemented");
    }

    @Override
    public WebAppHandler buildHandler(WebApp webapp) {
        IPluginsRegistryService pluginsService = (IPluginsRegistryService)SpringUtils.getBean(IPluginsRegistryService.class);
        File pluginFolder = pluginsService.getActualPluginFolder(this.loaded.ownerPluginId);
        File webappFolder = new File(pluginFolder, this.loaded.folderName);
        switch (this.getBaseType()) {
            case "STANDARD": {
                return new CustomStandardWebAppHandler(webapp, webappFolder);
            }
            case "SHINY": {
                return new CustomShinyWebAppHandler(webapp, webappFolder);
            }
            case "BOKEH": {
                return new CustomBokehWebAppHandler(webapp, webappFolder);
            }
            case "DASH": {
                return new CustomDashWebAppHandler(webapp, webappFolder);
            }
        }
        throw new Error("Not implemented");
    }

    @Override
    public WebAppDesc getWebAppDesc() {
        return this.loaded.desc;
    }

    @Override
    public List<Object> getHashElements(WebApp webApp) {
        switch (this.getBaseType()) {
            case "STANDARD": {
                StandardWebAppMeta.StandardWebAppParams params = webApp.getParamsAs(StandardWebAppMeta.StandardWebAppParams.class);
                ArrayList elements = Lists.newArrayList((Object[])new Object[]{webApp.config, params.python, params.envSelection});
                elements.addAll(Lists.newArrayList((Object[])new Object[]{params.html, params.js, params.css, params.libraries, params.enableJavascriptModules}));
                return elements;
            }
            case "SHINY": {
                ShinyWebAppMeta.ShinyWebAppParams params = webApp.getParamsAs(ShinyWebAppMeta.ShinyWebAppParams.class);
                return Lists.newArrayList((Object[])new Object[]{webApp.config, params.ui, params.server, params.envSelection});
            }
            case "BOKEH": {
                BokehWebAppMeta.BokehWebAppParams params = webApp.getParamsAs(BokehWebAppMeta.BokehWebAppParams.class);
                return Lists.newArrayList((Object[])new Object[]{webApp.config, params.python, params.envSelection});
            }
            case "DASH": {
                DashWebAppMeta.DashWebAppParams params = webApp.getParamsAs(DashWebAppMeta.DashWebAppParams.class);
                return Lists.newArrayList((Object[])new Object[]{webApp.config, params.python, params.envSelection});
            }
        }
        throw new Error("Not implemented");
    }

    public String getBaseType() {
        return this.loaded.desc.baseType;
    }

    public String getOwnerPluginId() {
        return this.loaded.ownerPluginId;
    }

    @Override
    public IElementLoadedDesc getLoadedDesc() {
        return this.loaded;
    }
}

