/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.standard;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.coremodel.DkuComponentMetadataWithCategory;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.MetaWithSelectableCodeEnv;
import com.dataiku.dip.recipes.ParamsWithSelectableCodeEnv;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppHandler;
import com.dataiku.dip.webapps.WebAppMeta;
import com.dataiku.dip.webapps.WebAppTemplate;
import com.dataiku.dip.webapps.backend.WebAppBackend;
import com.dataiku.dip.webapps.backend.WebAppBackendInstance;
import com.dataiku.dip.webapps.backend.WebAppBackendRunner;
import com.dataiku.dip.webapps.plugins.WebAppDesc;
import com.dataiku.dip.webapps.standard.StandardWebAppHandler;
import com.dataiku.dip.webapps.standard.backend.StandardWebAppBackendRunner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class StandardWebAppMeta
implements WebAppMeta,
MetaWithSelectableCodeEnv {
    public static final String TYPE = "STANDARD";
    public static final String LIVELINESS_CHECK_PATH = "/__ping";
    private static final WebAppDesc desc = StandardWebAppMeta.makeDesc();
    public static final StandardWebAppMeta META = new StandardWebAppMeta();

    @Override
    public Class<? extends WebApp.WebAppParams> getParamsClass() {
        return StandardWebAppParams.class;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public boolean isCustomWebApp() {
        return false;
    }

    @Override
    public WebAppBackendRunner buildRunner(WebApp webApp, WebAppBackend webAppBackend, JsonObject variables, AuthCtx user, WebAppBackendInstance webAppBackendInstance) {
        return new StandardWebAppBackendRunner(webApp, webAppBackend, variables, user, webAppBackendInstance);
    }

    @Override
    public WebAppHandler buildHandler(WebApp webapp) {
        return new StandardWebAppHandler(webapp);
    }

    @Override
    public CodeEnvModel.EnvLang getEnvLang() {
        return CodeEnvModel.EnvLang.PYTHON;
    }

    private static WebAppDesc makeDesc() {
        String shortDesc = "Standard HTML webapp with JavaScript, CSS and an optional python server";
        DkuComponentMetadataWithCategory data = new DkuComponentMetadataWithCategory("Standard", shortDesc, "dku-icon-code-48", null);
        return new WebAppDesc(TYPE, data);
    }

    @Override
    public WebAppDesc getWebAppDesc() {
        return desc;
    }

    @Override
    public List<Object> getHashElements(WebApp webApp) {
        StandardWebAppParams params = webApp.getParamsAs(StandardWebAppParams.class);
        ArrayList ret = Lists.newArrayList();
        ret.add(params.forceAuthentication);
        ret.add(params.python);
        ret.add(params.envSelection);
        ret.add(params.html);
        ret.add(params.css);
        ret.add(params.js);
        ret.add(params.enableJavascriptModules);
        ret.add(params.libraries);
        ret.add(params.nbProcesses);
        return ret;
    }

    public static class StandardWebAppParams
    extends WebApp.WebAppParams
    implements ParamsWithSelectableCodeEnv {
        @JSON.FileTransient
        public String html = "<!-- Body of your app -->";
        @JSON.FileTransient
        public String css = "body {\n}";
        @JSON.FileTransient
        public String js;
        @JSON.FileTransient
        public String python;
        public boolean backendEnabled;
        public boolean enableJavascriptModules;
        public boolean autoStartBackend;
        public boolean hideJSSecurityPanel;
        public boolean hideWebAppConfig;
        public CodeEnvSelection envSelection = new CodeEnvSelection();
        public int nbProcesses = 0;
        public boolean backendAPIAccessEnabled;
        public Set<WebAppTemplate.JavaScriptLibrary> libraries = EnumSet.of(WebAppTemplate.JavaScriptLibrary.jquery, WebAppTemplate.JavaScriptLibrary.dataiku);

        @Override
        public boolean isBackendEnabled() {
            return this.backendEnabled;
        }

        @Override
        public boolean isAutoStartBackend() {
            return this.backendEnabled && this.autoStartBackend;
        }

        @Override
        public JsonObject getSensitiveSettings(AuthCtx authCtx) throws IOException, DKUSecurityException {
            Preconditions.checkNotNull((Object)this.html);
            JsonObject ret = super.getSensitiveSettings(authCtx);
            ret.addProperty("type", StandardWebAppMeta.TYPE);
            ret.addProperty("html", this.html);
            ret.addProperty("css", this.css);
            ret.addProperty("js", this.js);
            ret.addProperty("backendEnabled", Boolean.valueOf(this.backendEnabled));
            if (this.backendEnabled) {
                ret.addProperty("python", this.python);
            }
            return ret;
        }

        @Override
        public boolean isLoadingPythonLibraries() {
            return this.backendEnabled;
        }

        @Override
        public boolean isLoadingRLibraries() {
            return false;
        }

        @Override
        public CodeEnvSelection getCodeEnvSelection() {
            return this.envSelection;
        }

        @Override
        public void setCodeEnvSelection(CodeEnvSelection envSelection) {
            this.envSelection = envSelection;
        }

        @Override
        public List<CodeEnvModel.CodeEnvUsage> collectCodeEnvUsage(TaggableObjectsService.TaggableObject object) {
            ArrayList usages = Lists.newArrayList();
            if (this.envSelection.envMode == CodeEnvSelection.EnvMode.EXPLICIT_ENV) {
                usages.add(new CodeEnvModel.CodeEnvUsage(CodeEnvModel.EnvLang.PYTHON, this.envSelection.envName, CodeEnvModel.EnvUsage.WEBAPP, object.getProjectKey(), object.getId()));
            }
            return usages;
        }
    }

    public static class StandardWebAppTemplate
    extends WebAppTemplate {
        public List<String> libraries = new ArrayList<String>();
        public boolean backendEnabled = false;
        public boolean autoStartBackend = false;
    }
}

