/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.standard.backend;

import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppLaunchInfo;
import com.dataiku.dip.webapps.WebAppSecurityInfo;
import com.dataiku.dip.webapps.backend.AbstractWebAppBackendRunner;
import com.dataiku.dip.webapps.backend.WebAppBackend;
import com.dataiku.dip.webapps.backend.WebAppBackendInstance;
import com.dataiku.dip.webapps.backend.WebAppBackendKernel;
import com.dataiku.dip.webapps.standard.backend.StandardWebAppDockerKernel;
import com.dataiku.dip.webapps.standard.backend.StandardWebAppKubernetesKernel;
import com.dataiku.dip.webapps.standard.backend.StandardWebAppLocalKernel;
import com.google.gson.JsonObject;
import java.io.File;

public class StandardWebAppBackendRunner
extends AbstractWebAppBackendRunner {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.webapps.standard");

    public StandardWebAppBackendRunner(WebApp webApp, WebAppBackend backend, JsonObject userVariables, AuthCtx user, WebAppBackendInstance webAppBackendInstance) {
        super(webApp, backend, userVariables, user, webAppBackendInstance);
    }

    @Override
    protected WebAppBackendKernel createKernel(WebAppLaunchInfo launchInfo, WebAppSecurityInfo securityInfo, ContainerExecRuntimeConfig containerConfig, APITicketService.Ticket ticket, File workingDir, DKUtils.LineSubscriptionAttacher mainLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) {
        if (containerConfig == null) {
            return new StandardWebAppLocalKernel(this.webApp, this.authCtx, this.userVariables, launchInfo, securityInfo, workingDir, ticket, mainLog, smartLogTailBuilder);
        }
        if (containerConfig.type == ContainerExecRuntimeConfig.Container.DOCKER) {
            return new StandardWebAppDockerKernel(this.webApp, containerConfig, this.authCtx, this.userVariables, launchInfo, securityInfo, workingDir, ticket, mainLog, smartLogTailBuilder);
        }
        if (containerConfig.type == ContainerExecRuntimeConfig.Container.KUBERNETES) {
            return new StandardWebAppKubernetesKernel(this.webApp, containerConfig, this.authCtx, this.userVariables, launchInfo, securityInfo, workingDir, ticket, mainLog, smartLogTailBuilder);
        }
        return null;
    }

    @Override
    public String getLivelinessPath() {
        return "/__ping";
    }

    public static class StartCommand {
        public String projectKey;
        public String webAppId;
        public String code;
        public String html;
        public String htmlDepsBase;
        public int nbProcesses;
        public WebAppSecurityInfo securityInfo;
    }
}

