/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.standard.backend;

import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppHandler;
import com.dataiku.dip.webapps.WebAppRegistry;
import com.dataiku.dip.webapps.WebAppSecurityInfo;
import com.dataiku.dip.webapps.proxy.ProxyWebAppHandler;
import com.dataiku.dip.webapps.standard.AbstractStandardWebAppHandler;
import com.dataiku.dip.webapps.standard.StandardWebAppMeta;
import com.dataiku.dip.webapps.standard.backend.StandardWebAppBackendRunner;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class StandardWebAppCommandUtils {
    private final WebApp webApp;

    public StandardWebAppCommandUtils(WebApp webApp) {
        this.webApp = webApp;
    }

    protected StandardWebAppBackendRunner.StartCommand makeCommand(WebAppSecurityInfo securityInfo, File workingDir) throws IOException {
        StandardWebAppMeta.StandardWebAppParams params = this.webApp.getParamsAs(StandardWebAppMeta.StandardWebAppParams.class);
        StandardWebAppBackendRunner.StartCommand command = new StandardWebAppBackendRunner.StartCommand();
        command.projectKey = this.webApp.projectKey;
        command.webAppId = this.webApp.id;
        command.code = params.python;
        command.nbProcesses = params.nbProcesses;
        command.securityInfo = securityInfo;
        WebAppHandler rawHandler = WebAppRegistry.getMeta(this.webApp.type).buildHandler(this.webApp);
        if (rawHandler instanceof AbstractStandardWebAppHandler) {
            AbstractStandardWebAppHandler handler = (AbstractStandardWebAppHandler)rawHandler;
            AbstractStandardWebAppHandler.HtmlAndDeps htmlAndDeps = handler.getHtmlAndDeps(true);
            command.html = htmlAndDeps.html;
            command.htmlDepsBase = "deps";
            File depsFolder = new File(workingDir, "deps");
            handler.prepareDepsFolder(htmlAndDeps, new ArrayList<String>(), depsFolder);
        } else if (rawHandler instanceof ProxyWebAppHandler) {
            command.html = null;
            command.htmlDepsBase = "deps";
        } else {
            throw new UnsupportedOperationException("Unexpected webapp handler type " + rawHandler.getClass().getCanonicalName());
        }
        return command;
    }
}

