/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.standard.backend;

import com.dataiku.dip.autorestart.AutoRestartingProcessRunner;
import com.dataiku.dip.code.CodeEnvResolutionService;
import com.dataiku.dip.exposition.ExposedEndpointConsumer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IImpersonatedKernel;
import com.dataiku.dip.security.impersonation.ImpersonationResolverService;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppLaunchInfo;
import com.dataiku.dip.webapps.WebAppSecurityInfo;
import com.dataiku.dip.webapps.backend.AbstractWebAppLocalProcessKernel;
import com.dataiku.dip.webapps.backend.WebAppBackendInstance;
import com.dataiku.dip.webapps.backend.WebAppBackendKernel;
import com.dataiku.dip.webapps.standard.backend.StandardWebAppBackendRunner;
import com.dataiku.dip.webapps.standard.backend.StandardWebAppCommandUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class StandardWebAppLocalKernel
extends AbstractWebAppLocalProcessKernel
implements IImpersonatedKernel {
    @Autowired
    private ImpersonationResolverService impersonationResolverService;
    @Autowired
    private CodeEnvResolutionService codeEnvResolutionService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.webapps.standard");

    public StandardWebAppLocalKernel(WebApp webApp, AuthCtx authCtx, JsonObject userVariables, WebAppLaunchInfo launchInfo, WebAppSecurityInfo securityInfo, File workingDir, APITicketService.Ticket ticket, DKUtils.LineSubscriptionAttacher mainLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) {
        super(webApp, authCtx, workingDir, mainLog, smartLogTailBuilder, userVariables, launchInfo, securityInfo, ticket);
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    protected String getLogPrefix() {
        return "[local] ";
    }

    @Override
    protected boolean impersonate() {
        return true;
    }

    private List<String> getRunCmd(File backendCommandFile) throws AutoRestartingProcessRunner.BackendStartFailedException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(backendCommandFile.getAbsolutePath());
        try {
            ArrayList args = Lists.newArrayList((Object[])new String[]{"-m", "dataiku.webapps.backend"});
            args.addAll(cmd);
            return this.codeEnvResolutionService.getPythonCmd(this.launchInfo.envName, this.webApp.projectKey, args);
        }
        catch (IOException e) {
            throw new AutoRestartingProcessRunner.BackendStartFailedException("Unable to start code env for standard webapp", e, null);
        }
    }

    private File writeTempCommandFile() throws Exception {
        StandardWebAppBackendRunner.StartCommand command = new StandardWebAppCommandUtils(this.webApp).makeCommand(null, this.workingDir);
        File tmpFile = new File(this.workingDir, "start_command.json");
        JSON.prettyToFile((Object)command, (File)tmpFile);
        return tmpFile;
    }

    @Override
    public WebAppBackendKernel.MainKernelProcess prepareRun(WebAppBackendInstance webAppBackendInstance, ExposedEndpointConsumer.ExposedEndpoint expectedExposedEndpoint) throws Exception {
        File commandFile = this.writeTempCommandFile();
        List<String> cmd = this.getRunCmd(commandFile);
        logger.info((Object)("Webapp start command: " + cmd.toString()));
        HashMap pythonLibs = Maps.newHashMap();
        if (StringUtils.isNotBlank((String)this.launchInfo.pythonLibFolder)) {
            pythonLibs.put("python-lib", this.launchInfo.pythonLibFolder);
        }
        ProcessBuilder builder = this.getProcessBuilder(cmd, true, pythonLibs, this.impersonationResolverService);
        builder.environment().putAll(this.codeEnvResolutionService.getEnvironmentVariablesForPythonCmd(this.launchInfo.envName, this.webApp.projectKey));
        return new WebAppBackendKernel.LocalMainKernelProcess(builder, this.outputConsumer, this.workingDir, this.securityInfo);
    }
}

