/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.workspaces;

import com.dataiku.dip.security.BasePermissions;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@UIModel
public class Workspace
extends TaggableObjectsService.TaggableObject {
    public String workspaceKey;
    public String displayName;
    public String color;
    public List<BasePermissions.PermissionItem> permissions = new ArrayList<BasePermissions.PermissionItem>();
    @JSON.FileTransient
    public BasePermissions.Permissions currentUserPermissions;
    public List<WorkspaceObject> workspaceObjects = new ArrayList<WorkspaceObject>();

    @Override
    public ITaggingService.TaggableType getTaggableType() {
        return ITaggingService.TaggableType.WORKSPACE;
    }

    @Override
    public String getProjectKey() {
        return null;
    }

    @Override
    public String getId() {
        return this.workspaceKey;
    }

    @Override
    public void setProjectKey(String projectKey) {
    }

    @Override
    public void setId(String id) {
        this.workspaceKey = id;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public TaggableObjectsService.TaggableObjectRef getRef() {
        return new TaggableObjectsService.TaggableObjectRef(null, ITaggingService.TaggableType.WORKSPACE, this.workspaceKey, this.workspaceKey);
    }

    public boolean contains(String projectKey, @Nullable ITaggingService.TaggableType type, @Nullable String objectId) {
        return this.workspaceObjects.stream().anyMatch(workspaceObject -> this.matchesObject(workspaceObject.reference, projectKey, type, objectId));
    }

    private boolean matchesObject(TaggableObjectsService.TaggableObjectRef tor, String projectKey, @Nullable ITaggingService.TaggableType type, @Nullable String objectId) {
        Preconditions.checkNotNull((Object)projectKey, (Object)"projectKey");
        return !(tor == null || !projectKey.equals(tor.projectKey) || type != null && !type.equals((Object)tor.type) || objectId != null && !objectId.equals(tor.id));
    }

    public static class WorkspaceObject {
        public String id;
        @Nullable
        public TaggableObjectsService.TaggableObjectRef reference;
        @Nullable
        public String appId;
        @Nullable
        public HtmlLink htmlLink;
        @Nullable
        public Story story;
        @Nullable
        public String customName;
        @JSON.FileTransient
        public String displayName;
        @JSON.FileTransient
        public String defaultName;
        @JSON.FileTransient
        public String subType;
        @Nullable
        ThumbnailMode thumbnailMode;
        @Nullable
        public String customThumbnailImage;
        @Nullable
        public String customThumbnailDescription;
        @JSON.FileTransient
        public String thumbnailData;
        @JSON.FileTransient
        public String defaultThumbnailData;
        @JSON.FileTransient
        public String shortDesc;
        @JSON.FileTransient
        public String description;
        @JSON.FileTransient
        public long lastModifiedOn;
        @JSON.FileTransient
        public String lastModifiedBy;
        @JSON.FileTransient
        public boolean starred;
        @JSON.FileTransient
        @Nullable
        public JsonElement extraInfo;

        public WorkspaceObject(@Nullable TaggableObjectsService.TaggableObjectRef reference) {
            this.reference = reference;
        }

        public WorkspaceObject(@Nullable HtmlLink link) {
            this.htmlLink = link;
        }

        public WorkspaceObject(@Nullable String appId) {
            this.appId = appId;
        }

        public WorkspaceObject() {
        }

        public String getType() {
            if (this.reference != null) {
                return this.reference.type.name();
            }
            if (this.appId != null) {
                return "APP";
            }
            if (this.htmlLink != null) {
                return "LINK";
            }
            if (this.story != null) {
                return "STORY";
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WorkspaceObject workspaceObject = (WorkspaceObject)o;
            return Objects.equals(this.reference, workspaceObject.reference) && Objects.equals(this.htmlLink, workspaceObject.htmlLink) && Objects.equals(this.appId, workspaceObject.appId) && Objects.equals(this.story, workspaceObject.story);
        }

        public int hashCode() {
            return Objects.hash(this.reference, this.htmlLink, this.appId, this.story);
        }

        public String toString() {
            StringJoiner joiner = new StringJoiner(", ", "{", "}");
            if (this.reference != null) {
                joiner.add("reference:" + String.valueOf(this.reference));
            } else if (this.appId != null) {
                joiner.add("appId:" + this.appId);
            } else if (this.htmlLink != null) {
                joiner.add("htmlLink=" + String.valueOf(this.htmlLink));
            } else if (this.story != null) {
                joiner.add("story=" + String.valueOf(this.story));
            } else {
                return "Unknown";
            }
            return joiner.toString();
        }
    }

    public static class Story {
        public Set<String> references = new HashSet<String>();
        public String title;
        public String id;
        public String description;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Story)) {
                return false;
            }
            Story story = (Story)o;
            return Objects.equals(this.references, story.references) && Objects.equals(this.title, story.title) && Objects.equals(this.id, story.id) && Objects.equals(this.description, story.description);
        }

        public int hashCode() {
            return Objects.hash(this.references, this.title, this.id, this.description);
        }
    }

    public static enum ThumbnailMode {
        DEFAULT,
        UPLOAD,
        DESCRIPTION;

    }

    public static class HtmlLink {
        public String name;
        public String url;
        public String description;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HtmlLink htmlLink = (HtmlLink)o;
            return Objects.equals(this.name, htmlLink.name) && Objects.equals(this.url, htmlLink.url) && Objects.equals(this.description, htmlLink.description);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.url, this.description);
        }
    }
}

