/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.model.serverconfig;

import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.model.serverconfig.CustomPythonPredictionEndpointConfig;
import com.dataiku.lambda.model.serverconfig.CustomRPredictionEndpointConfig;
import com.dataiku.lambda.model.serverconfig.DatasetsLookupEndpointConfig;
import com.dataiku.lambda.model.serverconfig.PredictionEndpointConfig;
import com.dataiku.lambda.model.serverconfig.PyFunctionEndpointConfig;
import com.dataiku.lambda.model.serverconfig.RFunctionEndpointConfig;
import com.dataiku.lambda.model.serverconfig.SQLQueryEndpointConfig;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import javax.annotation.Nullable;

public abstract class LambdaEndpointConfig {
    public String id;
    public EndpointType type = EndpointType.STD_PREDICTION;

    public boolean hasCustomCode() {
        return this.type.equals((Object)EndpointType.CUSTOM_R_PREDICTION) || this.type.equals((Object)EndpointType.R_FUNCTION) || this.type.equals((Object)EndpointType.PY_FUNCTION) || this.type.equals((Object)EndpointType.CUSTOM_PREDICTION);
    }

    @Nullable
    public String getCodeFileExtension() {
        if (this.hasCustomCode()) {
            return this.type.equals((Object)EndpointType.CUSTOM_R_PREDICTION) || this.type.equals((Object)EndpointType.R_FUNCTION) ? "R" : "py";
        }
        return null;
    }

    static {
        JSON.registerAdapter(LambdaEndpointConfig.class, (Object)new JSON.Adapter<LambdaEndpointConfig>(){

            public LambdaEndpointConfig deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
                JsonObject jsonObj = jsonElement.getAsJsonObject();
                if (jsonObj.get("type").getAsString().equals(EndpointType.STD_PREDICTION.toString()) || jsonObj.get("type").getAsString().equals(EndpointType.STD_FORECAST.toString()) || jsonObj.get("type").getAsString().equals(EndpointType.STD_CAUSAL_PREDICTION.toString()) || jsonObj.get("type").getAsString().equals(EndpointType.STD_CLUSTERING.toString())) {
                    return (LambdaEndpointConfig)jsonDeserializationContext.deserialize(jsonElement, PredictionEndpointConfig.class);
                }
                if (jsonObj.get("type").getAsString().equals("CUSTOM_PREDICTION")) {
                    return (LambdaEndpointConfig)jsonDeserializationContext.deserialize(jsonElement, CustomPythonPredictionEndpointConfig.class);
                }
                if (jsonObj.get("type").getAsString().equals("CUSTOM_R_PREDICTION")) {
                    return (LambdaEndpointConfig)jsonDeserializationContext.deserialize(jsonElement, CustomRPredictionEndpointConfig.class);
                }
                if (jsonObj.get("type").getAsString().equals(EndpointType.R_FUNCTION.toString())) {
                    return (LambdaEndpointConfig)jsonDeserializationContext.deserialize(jsonElement, RFunctionEndpointConfig.class);
                }
                if (jsonObj.get("type").getAsString().equals(EndpointType.PY_FUNCTION.toString())) {
                    return (LambdaEndpointConfig)jsonDeserializationContext.deserialize(jsonElement, PyFunctionEndpointConfig.class);
                }
                if (jsonObj.get("type").getAsString().equals(EndpointType.SQL_QUERY.toString())) {
                    return (LambdaEndpointConfig)jsonDeserializationContext.deserialize(jsonElement, SQLQueryEndpointConfig.class);
                }
                if (jsonObj.get("type").getAsString().equals(EndpointType.DATASETS_LOOKUP.toString())) {
                    return (LambdaEndpointConfig)jsonDeserializationContext.deserialize(jsonElement, DatasetsLookupEndpointConfig.class);
                }
                if (jsonObj.get("type").getAsString().equals("LLM_PROMPT")) {
                    LambdaEndpointConfig dummyConfig = new LambdaEndpointConfig(){};
                    dummyConfig.id = jsonObj.get("id").getAsString();
                    return dummyConfig;
                }
                throw new Error("Unknown endpoint type: " + String.valueOf(jsonObj.get("type")));
            }

            public JsonElement serialize(LambdaEndpointConfig task, Type type, JsonSerializationContext ctx) {
                return ctx.serialize((Object)task);
            }
        });
    }

    public static enum EndpointType {
        STD_PREDICTION,
        STD_FORECAST,
        STD_CAUSAL_PREDICTION,
        CUSTOM_PREDICTION,
        CUSTOM_R_PREDICTION,
        R_FUNCTION,
        PY_FUNCTION,
        DATASETS_LOOKUP,
        SQL_QUERY,
        STD_CLUSTERING;

    }
}

