/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.model.studioconfig;

import com.dataiku.dip.recipes.ParamsWithSelectableCodeEnv;
import com.dataiku.dip.recipes.ParamsWithSelectableConnection;
import com.dataiku.dip.recipes.SelectableCodeEnvContainer;
import com.dataiku.dip.recipes.SelectableConnectionContainer;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.model.serverconfig.AuthRealm;
import com.dataiku.lambda.model.serverconfig.LambdaAuthMethod;
import com.dataiku.lambda.model.serverconfig.LambdaServiceConfig;
import com.dataiku.lambda.model.serverconfig.LambdaServiceGenTag;
import com.dataiku.lambda.model.serverconfig.OAuth2Config;
import com.dataiku.lambda.model.studioconfig.DSSLambdaEndpointConfig;
import com.dataiku.lambda.model.studioconfig.DeploymentMonitoringConfig;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class LambdaService
extends TaggableObjectsService.TaggableObject
implements SelectableCodeEnvContainer,
SelectableConnectionContainer {
    @JSON.FileTransient
    public String projectKey;
    @JSON.FileTransient
    public String id;
    public String name;
    public String error;
    public List<DSSLambdaEndpointConfig> endpoints = new ArrayList<DSSLambdaEndpointConfig>();
    public LambdaAuthMethod authMethod;
    public AuthRealm authRealm = new AuthRealm();
    public OAuth2Config oauth2Config;
    public List<DeploymentMonitoringConfig> deploymentMonitoring = new ArrayList<DeploymentMonitoringConfig>();
    @Nullable
    public String releaseNotes;

    public LambdaService() {
    }

    public LambdaService(String name, String error) {
        this.name = name;
        this.error = error;
    }

    @Deprecated
    public void setPublicAccess(Boolean publicAccess) {
        this.authMethod = publicAccess != false ? LambdaAuthMethod.PUBLIC : LambdaAuthMethod.API_KEYS;
    }

    @Override
    public ITaggingService.TaggableType getTaggableType() {
        return ITaggingService.TaggableType.LAMBDA_SERVICE;
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public List<ParamsWithSelectableCodeEnv> collectCodeEnvUsers() {
        ArrayList codeEnvUsers = Lists.newArrayList();
        for (DSSLambdaEndpointConfig endpoint : this.endpoints) {
            if (!(endpoint instanceof ParamsWithSelectableCodeEnv)) continue;
            codeEnvUsers.add((ParamsWithSelectableCodeEnv)((Object)endpoint));
        }
        return codeEnvUsers;
    }

    public DeploymentMonitoringConfig getDeploymentMonitoringConfig(String deploymentId, String endpointId) {
        return this.deploymentMonitoring.stream().filter(deploymentMonitoringConfig -> deploymentMonitoringConfig.deploymentId.equals(deploymentId) && deploymentMonitoringConfig.endpointId.equals(endpointId)).findFirst().orElse(null);
    }

    public List<DeploymentMonitoringConfig> getDeploymentMonitoringConfigs(String deploymentId) {
        return this.deploymentMonitoring.stream().filter(deploymentMonitoringConfig -> deploymentMonitoringConfig.deploymentId.equals(deploymentId)).collect(Collectors.toList());
    }

    public String getAPIKeyOrNull() {
        switch (this.authMethod) {
            case API_KEYS: {
                if (this.authRealm == null || this.authRealm.queryKeys == null || this.authRealm.queryKeys.isEmpty()) {
                    return null;
                }
                PasswordEncryptionService passwordEncryptionService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
                return passwordEncryptionService.decryptIfEncrypted(this.authRealm.queryKeys.get((int)0).key);
            }
        }
        return null;
    }

    @Override
    public List<ParamsWithSelectableConnection> collectConnectionUsers() {
        ArrayList connectionUsers = Lists.newArrayList();
        for (DSSLambdaEndpointConfig endpoint : this.endpoints) {
            if (!(endpoint instanceof ParamsWithSelectableConnection)) continue;
            connectionUsers.add((ParamsWithSelectableConnection)((Object)endpoint));
        }
        return connectionUsers;
    }

    public static class LambdaServiceSummary
    extends TaggableObjectsService.TaggableObjectSummary {
        public List<Package> packages;

        public static class Package {
            public String id;
            public long mtime;
            public LambdaServiceConfig config;
            @Nullable
            public String releaseNotes;

            public Package(String id, long mtime, LambdaServiceConfig config, @Nullable LambdaServiceGenTag tagInfo) {
                this.id = id;
                this.mtime = mtime;
                this.config = config;
                if (tagInfo != null) {
                    this.releaseNotes = tagInfo.releaseNotes;
                }
            }
        }
    }

    public static class LambdaServiceListItem
    extends TaggableObjectsService.TaggableListItem {
        public final List<DSSLambdaEndpointConfig> endpoints;
        public final String error;

        @Override
        public ITaggingService.TaggableType getTaggableType() {
            return ITaggingService.TaggableType.LAMBDA_SERVICE;
        }

        public LambdaServiceListItem(LambdaService service) {
            super(service);
            this.endpoints = service.endpoints;
            this.error = service.error;
        }
    }
}

