/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.grel.controls;

import com.dataiku.dip.DKUApp;
import com.google.refine.expr.EvalError;
import com.google.refine.expr.Evaluable;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.grel.Control;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.GrelControlFunctionRegistry;
import com.google.refine.grel.ast.VariableExpr;
import java.util.ArrayList;
import java.util.Properties;

public class ForRange
implements Control {
    public static final String MAX_STEP_COUNT = "dku.formula.forRange.maxStepCount";

    @Override
    public String checkArguments(Evaluable[] args) {
        if (args.length != 5) {
            return GrelControlFunctionRegistry.getInstance().getControlName(this) + " expects 5 arguments";
        }
        if (!(args[3] instanceof VariableExpr)) {
            return GrelControlFunctionRegistry.getInstance().getControlName(this) + " expects fourth argument to be the element's variable name";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call(Properties bindings, Evaluable[] args) {
        int maxStepCount = DKUApp.getParams().getIntParam(MAX_STEP_COUNT, Integer.valueOf(10000));
        Object fromO = args[0].evaluate(bindings);
        Object toO = args[1].evaluate(bindings);
        Object stepO = args[2].evaluate(bindings);
        if (ExpressionUtils.isError(fromO)) {
            return fromO;
        }
        if (ExpressionUtils.isError(toO)) {
            return toO;
        }
        if (ExpressionUtils.isError(stepO)) {
            return stepO;
        }
        if (!(fromO instanceof Number && toO instanceof Number && stepO instanceof Number)) {
            return new EvalError("First, second, and third arguments of forRange must all be numbers");
        }
        String indexName = ((VariableExpr)args[3]).getName();
        Object oldIndexValue = bindings.get(indexName);
        try {
            ArrayList<Object> results = new ArrayList<Object>();
            if (ForRange.isIntegral((Number)fromO) && ForRange.isIntegral((Number)stepO)) {
                long from = ((Number)fromO).longValue();
                long step = ((Number)stepO).longValue();
                double to = ((Number)toO).doubleValue();
                if (to == (double)from) {
                    Object[] objectArray = results.toArray();
                    return objectArray;
                }
                if (step == 0L) {
                    EvalError evalError = new EvalError("Step must not be 0");
                    return evalError;
                }
                if (Math.signum(to - (double)from) != (double)Math.signum(step)) {
                    EvalError evalError = new EvalError("Step must be of the same sign as (to - from)");
                    return evalError;
                }
                if (Math.abs(to - (double)from) / (double)maxStepCount > (double)Math.abs(step)) {
                    EvalError evalError = new EvalError("Maximum number of steps exceeded (" + maxStepCount + ")");
                    return evalError;
                }
                while (Math.signum(to - (double)from) == (double)Math.signum(step)) {
                    bindings.put(indexName, (Object)from);
                    Object r = args[4].evaluate(bindings);
                    results.add(r);
                    from += step;
                }
            } else {
                double from = ((Number)fromO).doubleValue();
                double step = ((Number)stepO).doubleValue();
                double to = ((Number)toO).doubleValue();
                if (to == from) {
                    Object[] r = results.toArray();
                    return r;
                }
                if (step == 0.0) {
                    EvalError r = new EvalError("Step must not be 0");
                    return r;
                }
                if (Math.signum(to - from) != Math.signum(step)) {
                    EvalError r = new EvalError("Step must be of the same sign as (to - from)");
                    return r;
                }
                if (Math.abs(to - from) / (double)maxStepCount > Math.abs(step)) {
                    EvalError r = new EvalError("Maximum number of steps exceeded (" + maxStepCount + ")");
                    return r;
                }
                while (Math.signum(to - from) == Math.signum(step)) {
                    bindings.put(indexName, (Object)from);
                    Object r = args[4].evaluate(bindings);
                    results.add(r);
                    from += step;
                }
            }
            Object[] objectArray = results.toArray();
            return objectArray;
        }
        finally {
            if (oldIndexValue != null) {
                bindings.put(indexName, oldIndexValue);
            } else {
                bindings.remove(indexName);
            }
        }
    }

    private static boolean isIntegral(Number o) {
        if (o instanceof Integer || o instanceof Long) {
            return true;
        }
        return o.doubleValue() - (double)o.longValue() == 0.0;
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.ForRange.DOCUMENTATION", "Iterates, starting at <code>from</code>, incrementing by <code>step</code> each time while less than <code>to</code>. At each iteration, binds the variable <code>v</code> to the iteration value, evaluates expression <code>e</code>, and pushes the result onto the result array.").withParams("from, to, step, variable  v, expression e").withReturns("array").withCategory("GREL.FUNCTIONS.CATEGORY.CONTROL_STRUCTURES", "Control structures").withExample(Example.with("0", "21", "3", "v", "v").returns("[0,3,6,9,12,15,18]")).withExample(Example.with("0", "21", "3", "v", "v*5").returns("[0,15,30,45,60,75,90]"));
    }
}

