/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector;

import com.dataiku.dip.input.formats.hive.serde.DSSInspectionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.serde2.objectinspector.DSSBaseInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.json.JSONException;
import org.json.JSONObject;

public class DSSObjectObjectInspector
extends StructObjectInspector
implements DSSBaseInspector {
    private final List<Field> fieldsByIndex = new ArrayList<Field>();
    private final Map<String, Field> fieldsByNames = new HashMap<String, Field>();
    private DSSBaseInspector parent;

    public DSSObjectObjectInspector(List<String> names, List<? extends ObjectInspector> ois) {
        assert (names.size() == ois.size());
        for (int i = 0; i < names.size(); ++i) {
            Field field = new Field(names.get(i), ois.get(i));
            this.fieldsByIndex.add(field);
            this.fieldsByNames.put(names.get(i).toLowerCase(), field);
        }
    }

    public List<? extends StructField> getAllStructFieldRefs() {
        return this.fieldsByIndex;
    }

    public StructField getStructFieldRef(String s) {
        return this.fieldsByNames.get(s);
    }

    private JSONObject get(Object data) {
        if (data != null && !JSONObject.NULL.equals(data)) {
            if (data instanceof JSONObject) {
                return (JSONObject)data;
            }
            throw new DSSInspectionException((DSSBaseInspector)this, "JSONObject expected : " + String.valueOf(data));
        }
        return null;
    }

    public Object getStructFieldData(Object data, StructField structField) {
        JSONObject obj = this.get(data);
        if (obj != null) {
            Object ret = null;
            try {
                Field sf = (Field)structField;
                if (obj.has(sf.getCaseSensitiveFieldName())) {
                    ret = obj.get(sf.getCaseSensitiveFieldName());
                }
            }
            catch (JSONException e) {
                throw new DSSInspectionException((DSSBaseInspector)this, (Throwable)e);
            }
            if (JSONObject.NULL.equals(ret)) {
                ret = null;
            }
            return ret;
        }
        return null;
    }

    public List<Object> getStructFieldsDataAsList(Object o) {
        ArrayList<Object> out = new ArrayList<Object>();
        for (Field field : this.fieldsByIndex) {
            out.add(this.getStructFieldData(o, field));
        }
        return out;
    }

    public String getTypeName() {
        return ObjectInspectorUtils.getStandardStructTypeName((StructObjectInspector)this);
    }

    public ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.STRUCT;
    }

    @Override
    public DSSBaseInspector getParent() {
        return this.parent;
    }

    @Override
    public void setParent(DSSBaseInspector parent) {
        this.parent = parent;
    }

    private static class Field
    implements StructField {
        public final String name;
        public final ObjectInspector oi;

        private Field(String name, ObjectInspector oi) {
            this.name = name;
            this.oi = oi;
        }

        public String getCaseSensitiveFieldName() {
            return this.name;
        }

        public String getFieldName() {
            return this.name.toLowerCase();
        }

        public ObjectInspector getFieldObjectInspector() {
            return this.oi;
        }

        public String getFieldComment() {
            return null;
        }
    }
}

