/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.hive.HiveSerdeShimsLoader;
import com.dataiku.dip.input.formats.hive.serde.DSSInspectionException;
import com.dataiku.dip.input.formats.hive.serde.ObjectInspectorBuilder;
import com.dataiku.dip.shaker.types.Boolean;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.serde2.objectinspector.DSSBaseInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DSSRowObjectInspector
extends StructObjectInspector
implements DSSBaseInspector {
    private static final Boolean boolMeaning = new Boolean();
    private final List<Field> fieldsByIndex = new ArrayList<Field>();
    private final Map<String, Field> fieldsByLowerCaseName = new HashMap<String, Field>();
    private DSSBaseInspector parent;

    public DSSRowObjectInspector(ObjectInspectorBuilder objectInspectorBuilder, Schema schema, ColumnFactory cf) {
        for (SchemaColumn sc : schema.getColumns()) {
            DSSBaseInspector inspector = objectInspectorBuilder.buildObjectInspector(sc);
            inspector.setParent(this);
            Column col = cf.column(sc.getName());
            Field field = new Field(sc, inspector, col);
            this.fieldsByIndex.add(field);
            this.fieldsByLowerCaseName.put(sc.getName().toLowerCase(), field);
        }
    }

    public List<Field> getAllStructFieldRefs() {
        return this.fieldsByIndex;
    }

    public StructField getStructFieldRef(String s) {
        return this.fieldsByLowerCaseName.get(s);
    }

    private Row getRow(Object o) {
        if (!(o instanceof Row)) {
            throw new RuntimeException("Must be a non-null row");
        }
        return (Row)o;
    }

    public Object getStructFieldData(Object o, StructField structField) {
        Row row = this.getRow(o);
        Field field = (Field)structField;
        DSSBaseInspector oi = field.getFieldObjectInspector();
        Type type = ((Field)structField).getSchemaColumn().getType();
        String val = row.get(field.getColumn());
        if (val == null) {
            return null;
        }
        if (type != Type.STRING && StringUtils.isBlank((String)val)) {
            return null;
        }
        switch (type) {
            case TINYINT: {
                try {
                    return Byte.valueOf(val);
                }
                catch (NumberFormatException e) {
                    throw new DSSInspectionException(oi, (Throwable)e);
                }
            }
            case SMALLINT: {
                try {
                    return Short.valueOf(val);
                }
                catch (NumberFormatException e) {
                    throw new DSSInspectionException(oi, (Throwable)e);
                }
            }
            case INT: {
                try {
                    return Integer.valueOf(val);
                }
                catch (NumberFormatException e) {
                    throw new DSSInspectionException(oi, (Throwable)e);
                }
            }
            case BIGINT: {
                try {
                    return Long.valueOf(val);
                }
                catch (NumberFormatException e) {
                    throw new DSSInspectionException(oi, (Throwable)e);
                }
            }
            case FLOAT: {
                try {
                    return Float.valueOf(val);
                }
                catch (NumberFormatException e) {
                    throw new DSSInspectionException(oi, (Throwable)e);
                }
            }
            case DOUBLE: {
                try {
                    return Double.valueOf(val);
                }
                catch (NumberFormatException e) {
                    throw new DSSInspectionException(oi, (Throwable)e);
                }
            }
            case BOOLEAN: {
                try {
                    return boolMeaning.parse(val);
                }
                catch (NumberFormatException e) {
                    throw new DSSInspectionException(oi, (Throwable)e);
                }
            }
            case STRING: {
                try {
                    return val;
                }
                catch (NumberFormatException e) {
                    throw new DSSInspectionException(oi, (Throwable)e);
                }
            }
            case DATE: {
                return HiveSerdeShimsLoader.get().asTimestamp(oi, val);
            }
            case DATETIMENOTZ: {
                return HiveSerdeShimsLoader.get().asLocalTimestamp(oi, val);
            }
            case DATEONLY: {
                return HiveSerdeShimsLoader.get().asDate(oi, val);
            }
            case ARRAY: {
                if (StringUtils.equalsIgnoreCase((String)val, (String)"null") || StringUtils.isBlank((String)val)) {
                    return null;
                }
                try {
                    return new JSONArray(val);
                }
                catch (JSONException e) {
                    throw new DSSInspectionException(oi, "Unable to parse JSON array : " + val, e);
                }
            }
            case MAP: 
            case OBJECT: {
                if (StringUtils.equalsIgnoreCase((String)val, (String)"null") || StringUtils.isBlank((String)val)) {
                    return null;
                }
                try {
                    return new JSONObject(val);
                }
                catch (JSONException e) {
                    throw new DSSInspectionException(oi, "Unable to parse JSON object: " + val, e);
                }
            }
        }
        throw new DSSInspectionException(oi, "Unsupported type: " + type.name(), null);
    }

    public List<Object> getStructFieldsDataAsList(Object o) {
        ArrayList<Object> out = new ArrayList<Object>();
        for (Field field : this.fieldsByIndex) {
            out.add(this.getStructFieldData(o, field));
        }
        return out;
    }

    public String getTypeName() {
        return ObjectInspectorUtils.getStandardStructTypeName((StructObjectInspector)this);
    }

    public ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.STRUCT;
    }

    @Override
    public DSSBaseInspector getParent() {
        return this.parent;
    }

    @Override
    public void setParent(DSSBaseInspector parent) {
        this.parent = parent;
    }

    public static class Field
    implements StructField {
        private final SchemaColumn schemaColumn;
        private final DSSBaseInspector inspector;
        private final Column col;

        public Field(SchemaColumn schemaColumn, DSSBaseInspector inspector, Column col) {
            this.schemaColumn = (SchemaColumn)Preconditions.checkNotNull((Object)schemaColumn);
            this.inspector = (DSSBaseInspector)Preconditions.checkNotNull((Object)inspector);
            this.col = (Column)Preconditions.checkNotNull((Object)col);
        }

        public String getCaseSensitiveFieldName() {
            return this.schemaColumn.getName();
        }

        public String getFieldName() {
            return this.schemaColumn.getName().toLowerCase();
        }

        public Column getColumn() {
            return this.col;
        }

        public SchemaColumn getSchemaColumn() {
            return this.schemaColumn;
        }

        public DSSBaseInspector getFieldObjectInspector() {
            return this.inspector;
        }

        public String getFieldComment() {
            return this.schemaColumn.comment;
        }
    }
}

