/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import java.util.ArrayList;
import java.util.List;
import org.geotools.geometry.jts.GrowableOrdinateArray;
import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.locationtech.jts.algorithm.Distance;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.simplify.DouglasPeuckerSimplifier;

public class OffsetCurveBuilder {
    public static int QUADRANT_SEGMENTS_DEFAULT = 8;
    public static double DEFAULT_THRESHOLD_RATIO = 2.0;
    static double EPS = 1.0E-9;
    double offset;
    int quadrantSegments;
    double thresholdRatio = DEFAULT_THRESHOLD_RATIO;
    double maxSearchDistanceSquared;

    public OffsetCurveBuilder(double offset) {
        this(offset, QUADRANT_SEGMENTS_DEFAULT);
    }

    public OffsetCurveBuilder(double offset, int quadrantSegments) {
        this.offset = offset;
        this.maxSearchDistanceSquared = offset * offset * this.thresholdRatio * this.thresholdRatio;
        if (quadrantSegments < 1) {
            throw new IllegalArgumentException("Invalid number of quadrantSegments, must be greater than zero: " + quadrantSegments);
        }
        this.quadrantSegments = quadrantSegments;
    }

    public Geometry offset(Geometry g) {
        if (Math.abs(this.offset) < EPS) {
            return g;
        }
        if (g == null) {
            return null;
        }
        double threshold = Math.abs(this.offset) / 10.0;
        List<LineString> lines = this.extractLineStrings(g);
        ArrayList<LineString> offsets = new ArrayList<LineString>();
        for (LineString ls : lines) {
            LineString offsetLine;
            LineString simplified = (LineString)DouglasPeuckerSimplifier.simplify((Geometry)ls, (double)threshold);
            if (simplified == null) {
                return null;
            }
            if (ls.isClosed() && !simplified.isClosed()) {
                CoordinateSequence source = simplified.getCoordinateSequence();
                int numCoordinates = source.size();
                LiteCoordinateSequence dest = new LiteCoordinateSequence(numCoordinates + 1, 2);
                for (int i = 0; i < numCoordinates; ++i) {
                    dest.setOrdinate(i, 0, source.getOrdinate(i, 0));
                    dest.setOrdinate(i, 1, source.getOrdinate(i, 1));
                }
                dest.setOrdinate(numCoordinates, 0, source.getOrdinate(0, 0));
                dest.setOrdinate(numCoordinates, 1, source.getOrdinate(0, 1));
                simplified = simplified.getFactory().createLinearRing((CoordinateSequence)dest);
            }
            if ((offsetLine = this.offset(simplified)) == null) continue;
            offsets.add(offsetLine);
        }
        if (offsets.isEmpty()) {
            return null;
        }
        if (offsets.size() == 1) {
            return (Geometry)offsets.get(0);
        }
        GeometryFactory factory = ((LineString)offsets.get(0)).getFactory();
        MultiLineString result = factory.createMultiLineString(offsets.toArray(new LineString[offsets.size()]));
        return result;
    }

    private List<LineString> extractLineStrings(Geometry g) {
        if (g instanceof Polygon) {
            g.normalize();
        } else if (g instanceof GeometryCollection) {
            g.apply(geom -> {
                if (geom instanceof Polygon) {
                    geom.normalize();
                }
            });
        }
        ArrayList<LineString> lines = new ArrayList<LineString>();
        if (g instanceof LineString) {
            lines.add((LineString)g);
        } else {
            g.apply(geom -> {
                if (geom instanceof LineString) {
                    lines.add((LineString)geom);
                }
            });
        }
        return lines;
    }

    private LineString offset(LineString ls) {
        double c1y;
        double c1x;
        double c0y;
        double c0x;
        boolean closed = ls instanceof LinearRing;
        CoordinateSequence cs = ls.getCoordinateSequence();
        int numPoints = cs.size();
        GrowableOrdinateArray ordinates = new GrowableOrdinateArray(numPoints * 2);
        if (closed) {
            c0x = cs.getOrdinate(cs.size() - 2, 0);
            c0y = cs.getOrdinate(cs.size() - 2, 1);
            c1x = cs.getOrdinate(0, 0);
            c1y = cs.getOrdinate(0, 1);
        } else {
            c0x = cs.getOrdinate(0, 0);
            c0y = cs.getOrdinate(0, 1);
            c1x = c0x;
            c1y = c0y;
        }
        double c2x = cs.getOrdinate(1, 0);
        double c2y = cs.getOrdinate(1, 1);
        double dx10 = c0x - c1x;
        double dy10 = c0y - c1y;
        double dx12 = c2x - c1x;
        double dy12 = c2y - c1y;
        double angle10 = Math.atan2(-dy10, -dx10);
        double angle12 = Math.atan2(dy12, dx12);
        if (closed) {
            this.addPoint(ordinates, c1x, c1y, dx10, dy10, dx12, dy12, angle10, angle12);
        } else {
            this.appendPerpendicular(c1x, c1y, angle12, ordinates);
        }
        for (int i = 2; i < numPoints; ++i) {
            c1x = c2x;
            c1y = c2y;
            c2x = cs.getOrdinate(i, 0);
            c2y = cs.getOrdinate(i, 1);
            dx10 = -dx12;
            dy10 = -dy12;
            angle10 = angle12;
            dx12 = c2x - c1x;
            dy12 = c2y - c1y;
            angle12 = Math.atan2(dy12, dx12);
            this.addPoint(ordinates, c1x, c1y, dx10, dy10, dx12, dy12, angle10, angle12);
        }
        if (closed) {
            ordinates.close();
        } else {
            this.appendPerpendicular(c2x, c2y, angle12, ordinates);
        }
        ordinates = this.cleanupOrdinates(ordinates, closed);
        LineString result = this.buildLineString(ls, ordinates);
        return result;
    }

    private GrowableOrdinateArray cleanupOrdinates(GrowableOrdinateArray ordinates, boolean closed) {
        int max = ordinates.size();
        if (max <= 8 && closed || max < 8 && !closed) {
            return ordinates;
        }
        double[] data = ordinates.getDataRaw();
        if (max > data.length) {
            throw new ArrayIndexOutOfBoundsException(max);
        }
        GrowableOrdinateArray result = ordinates;
        Coordinate c1 = new Coordinate();
        Coordinate c2 = new Coordinate();
        Coordinate c3 = new Coordinate();
        Coordinate c4 = new Coordinate();
        RobustLineIntersector intersector = new RobustLineIntersector();
        c1.x = data[0];
        c1.y = data[1];
        boolean lastCurlEliminated = false;
        for (int i = 2; i < max - 3; i += 2) {
            c2.x = data[i];
            c2.y = data[i + 1];
            c3.x = data[i + 2];
            c3.y = data[i + 3];
            for (int j = i + 4; j < max - 1; j += 2) {
                double distancePointLine;
                c4.x = data[j];
                c4.y = data[j + 1];
                if (this.squaredDistance(c1, c3) > this.maxSearchDistanceSquared && this.squaredDistance(c1, c4) > this.maxSearchDistanceSquared && this.squaredDistance(c2, c3) > this.maxSearchDistanceSquared && this.squaredDistance(c2, c4) > this.maxSearchDistanceSquared) break;
                intersector.computeIntersection(c1, c2, c3, c4);
                if (intersector.hasIntersection()) {
                    Coordinate intersection = intersector.getIntersection(0);
                    c2.x = intersection.x;
                    c2.y = intersection.y;
                    if (result == ordinates) {
                        result = new GrowableOrdinateArray();
                        if (i > 3) {
                            result.copy(ordinates, 0, i - 3);
                        }
                    }
                    i = j - 2;
                    break;
                }
                if (j == max - 2 && !closed && (distancePointLine = Distance.pointToLinePerpendicular((Coordinate)c4, (Coordinate)c1, (Coordinate)c2)) < Math.abs(this.offset) / 10.0) {
                    c2.x = c4.x;
                    c2.y = c4.y;
                    if (result == ordinates) {
                        result = new GrowableOrdinateArray();
                        if (i > 3) {
                            result.copy(ordinates, 0, i - 3);
                        }
                    }
                    i = j - 2;
                    lastCurlEliminated = true;
                    break;
                }
                c3.x = c4.x;
                c3.y = c4.y;
            }
            if (result != ordinates) {
                result.add(c1.x, c1.y);
            }
            c1.x = c2.x;
            c1.y = c2.y;
        }
        if (result != ordinates) {
            result.add(c1.x);
            result.add(c1.y);
            if (!lastCurlEliminated) {
                result.add(data[max - 2]);
                result.add(data[max - 1]);
            }
        }
        return result;
    }

    private double squaredDistance(Coordinate a, Coordinate b) {
        double dx = a.x - b.x;
        double dy = a.y - b.y;
        return this.squaredDistance(dx, dy);
    }

    private double squaredDistance(double dx, double dy) {
        return dx * dx + dy * dy;
    }

    private void addPoint(GrowableOrdinateArray ordinates, double c1x, double c1y, double dx10, double dy10, double dx12, double dy12, double angle10, double angle12) {
        double jointAngle = this.computeJointAngle(dx10, dy10, dx12, dy12);
        if (Math.abs(jointAngle) > Math.PI) {
            this.addBulge(ordinates, c1x, c1y, angle10, angle12);
        } else {
            this.appendInternalJoint(c1x, c1y, angle10, angle12, dx10, dy10, dx12, dy12, ordinates);
        }
    }

    private void addBulge(GrowableOrdinateArray ordinates, double c1x, double c1y, double angle10, double angle12) {
        double curveAngle = this.reflexAngle(angle12 - angle10);
        double segmentTurns = (double)this.quadrantSegments * Math.abs(curveAngle);
        int steps = 1 + (int)(segmentTurns / Math.PI * 2.0);
        for (int step = 0; step <= steps; ++step) {
            this.appendPerpendicular(c1x, c1y, angle10 + curveAngle * (double)step / (double)steps, ordinates);
        }
    }

    private LineString buildLineString(LineString ls, GrowableOrdinateArray ordinates) {
        GeometryFactory factory = ls.getFactory();
        CoordinateSequence cs = ordinates.toCoordinateSequence(factory);
        if (ls instanceof LinearRing) {
            if (cs.size() >= 4) {
                return factory.createLinearRing(cs);
            }
            return null;
        }
        return factory.createLineString(cs);
    }

    private double reflexAngle(double angle) {
        if (angle > Math.PI) {
            return angle - Math.PI * 2;
        }
        if (angle < -Math.PI) {
            return angle + Math.PI * 2;
        }
        return angle;
    }

    private double computeJointAngle(double dx10, double dy10, double dx12, double dy12) {
        double det = dx10 * dy12 - dy10 * dx12;
        double dot = dx10 * dx12 + dy10 * dy12;
        double angle = Math.atan2(det, dot);
        if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        angle %= Math.PI * 2;
        if (this.offset > 0.0) {
            angle = Math.PI * 2 - angle;
        }
        return angle;
    }

    private void appendPerpendicular(double x, double y, double angle, GrowableOrdinateArray ordinates) {
        double px = x - this.offset * Math.sin(angle);
        double py = y + this.offset * Math.cos(angle);
        ordinates.add(px, py);
    }

    private void appendInternalJoint(double x, double y, double angle01, double angle12, double dx10, double dy10, double dx12, double dy12, GrowableOrdinateArray ordinates) {
        double sa = this.offset * Math.sin(angle01);
        double ca = this.offset * Math.cos(angle01);
        double h = Math.tan(0.5 * (angle12 - angle01));
        double hsa = h * sa;
        double hca = h * ca;
        double px = x - sa - hca;
        double py = y + ca - hsa;
        double maxAllowedDistanceSquared = Math.max(this.maxSearchDistanceSquared, Math.max(this.squaredDistance(dx10, dy10), this.squaredDistance(dx12, dy12)));
        if (this.squaredDistance(px - x, py - y) > maxAllowedDistanceSquared) {
            double angle = Math.atan2(py - y, px - x);
            double maxAllowedDistance = Math.sqrt(maxAllowedDistanceSquared);
            px = x + maxAllowedDistance * Math.cos(angle);
            py = y + maxAllowedDistance * Math.sin(angle);
        }
        ordinates.add(px, py);
    }
}

