/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hproxy.server.pig.checker;

import com.dataiku.hproxy.model.pig.ValidationResult;
import com.dataiku.hproxy.server.Context;
import com.dataiku.hproxy.server.pig.checker.IPigCheckerImpl;
import com.dataiku.hproxy.utils.Reflector;
import org.apache.log4j.Logger;

public class Checker {
    private static Logger logger = Logger.getLogger(Checker.class);
    private ValidationResult resp = null;
    private Exception exception = null;
    private Context ctx;

    public Checker(Context ctx) {
        this.ctx = ctx;
    }

    public ValidationResult check(final String query) throws Exception {
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                logger.info((Object)"Instanciating a new pig checker");
                ClassLoader cl = null;
                IPigCheckerImpl checker = null;
                try {
                    cl = Checker.this.ctx.getClassLoaderPool().requirePooled("sandbox", "pig");
                    Thread.currentThread().setContextClassLoader(cl);
                    checker = (IPigCheckerImpl)new Reflector(cl).newInstance("com.dataiku.hproxy.sandbox.pig.checker.PigCheckerImpl", new Object[0]);
                    checker.init(cl, query);
                    Checker.this.resp = checker.checkCompile();
                }
                catch (Exception e) {
                    try {
                        Checker.this.exception = e;
                        logger.error((Object)"Pig checker failed", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        logger.info((Object)"Pig cleanup");
                        if (checker != null) {
                            checker.close();
                        }
                        if (cl != null) {
                            Checker.this.ctx.getClassLoaderPool().release(cl);
                        }
                        throw throwable;
                    }
                    logger.info((Object)"Pig cleanup");
                    if (checker != null) {
                        checker.close();
                    }
                    if (cl != null) {
                        Checker.this.ctx.getClassLoaderPool().release(cl);
                    }
                }
                logger.info((Object)"Pig cleanup");
                if (checker != null) {
                    checker.close();
                }
                if (cl != null) {
                    Checker.this.ctx.getClassLoaderPool().release(cl);
                }
            }
        });
        t.start();
        t.join();
        if (this.exception != null) {
            throw this.exception;
        }
        return this.resp;
    }
}

