/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.kernels;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.io.AbstractImpersonableSecretProtectedPythonKernel;
import com.dataiku.dip.io.ResponderKernelLink;
import com.dataiku.dip.io.SecretProtectedKernelLink;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.process.IsolableProcess;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.ServiceGenContext;
import com.dataiku.lambda.auth.LambdaIntercomApiSecretAuthService;
import com.dataiku.lambda.distributed.workers.LambdaWorkerService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractLambdaPythonKernel
extends AbstractImpersonableSecretProtectedPythonKernel<ResponderKernelLink> {
    private final List<String> userCodePaths;
    private final File codeEnvFolder;
    private final ServiceGenContext ctx;

    protected AbstractLambdaPythonKernel(ResponderKernelLink link, ServiceGenContext ctx, String endpointId, List<String> userCodePaths, File codeEnvFolder, File kernelWorkDir, boolean impersonate, GeneralSettingsDAO.CGrouppableProcessType cGrouppableProcessType) {
        super((SecretProtectedKernelLink)link, cGrouppableProcessType, ((APITicketService)SpringUtils.getBean(APITicketService.class)).createTicket((AuthCtx)DSSAuthCtx.newNone(), null, null), null, false, null, kernelWorkDir, impersonate, null, (AuthCtx)DSSAuthCtx.newNone(), null, ((LambdaWorkerService)((Object)SpringUtils.getBean(LambdaWorkerService.class))).createWorkerPool(ctx, endpointId, userCodePaths));
        this.ctx = ctx;
        this.userCodePaths = userCodePaths;
        this.codeEnvFolder = codeEnvFolder;
        this.kernelEnvVariables.put("LAMBDA_INTERCOM_API_SECRET", ((LambdaIntercomApiSecretAuthService)SpringUtils.getBean(LambdaIntercomApiSecretAuthService.class)).getInternalApiSecret());
    }

    protected List<String> getPythonCmd() {
        return AbstractLambdaPythonKernel.buildPythonCmd(this.codeEnvFolder);
    }

    protected Map<String, String> getCodeEnvResourcesEnvVariables() throws IOException {
        File resourcesEnvVariablesFile = DKUFileUtils.getWithin((File)this.codeEnvFolder, (String[])new String[]{"desc", "actual", "resources_env.json"});
        if (resourcesEnvVariablesFile.exists()) {
            CodeEnvModel.CodeEnvResourcesEnvVariables resourcesEnvVariables = (CodeEnvModel.CodeEnvResourcesEnvVariables)JSON.parseFile((File)resourcesEnvVariablesFile, CodeEnvModel.CodeEnvResourcesEnvVariables.class);
            return resourcesEnvVariables.resolve(DKUFileUtils.getWithin((File)this.codeEnvFolder, (String[])new String[]{"resources"}));
        }
        return new HashMap<String, String>();
    }

    protected IsolableProcess createAndStartProcess(ProcessBuilder pb, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType) throws DKUSecurityException, IOException, InterruptedException {
        AbstractLambdaPythonKernel.setPythonPath(pb, this.userCodePaths);
        AbstractLambdaPythonKernel.setApiServiceEnvVars(pb, this.ctx);
        return super.createAndStartProcess(pb, cgrouppableProcessType);
    }

    public static void setApiServiceEnvVars(ProcessBuilder pb, ServiceGenContext ctx) {
        pb.environment().put("DKU_CURRENT_APISERVICE", ctx.getServiceId());
        pb.environment().put("DKU_CURRENT_APISERVICE_GENERATION", ctx.getGenerationId());
        pb.environment().put("IS_LAMBDA_SERVER", "true");
    }

    public static List<String> buildPythonCmd(File codeEnvFolder) {
        ArrayList<String> cmd = new ArrayList<String>();
        if (codeEnvFolder != null && codeEnvFolder.isDirectory() && new File(codeEnvFolder, "env/bin/python").isFile()) {
            cmd.add(new File(codeEnvFolder, "env/bin/python").getAbsolutePath());
        } else {
            String pythonBin = System.getenv("DKUPYTHONBIN");
            if (pythonBin == null) {
                throw new Error("environment variable DKUPYTHONBIN not defined");
            }
            cmd.add(new File(pythonBin).getAbsolutePath());
        }
        cmd.add("-u");
        return cmd;
    }

    public static void setPythonPath(ProcessBuilder pb, List<String> paths) {
        String pythonPath = System.getenv("PYTHONPATH");
        if (pythonPath == null) {
            pythonPath = "";
        }
        StringBuilder pythonPathBuilder = new StringBuilder(pythonPath);
        for (String path : paths) {
            if (StringUtils.isBlank((String)path)) continue;
            pythonPathBuilder.append(File.pathSeparator).append(path);
        }
        pythonPath = pythonPathBuilder.toString();
        while (pythonPath.startsWith(File.pathSeparator)) {
            pythonPath = pythonPath.substring(File.pathSeparator.length());
        }
        if (!StringUtils.isBlank((String)pythonPath)) {
            pb.environment().put("PYTHONPATH", pythonPath);
        }
    }
}

