/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.BuiltinsLoader;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.MockableSystem;
import com.dataiku.dip.analysis.ml.hf.HuggingFaceClientFactory;
import com.dataiku.dip.analysis.ml.hf.ModelCacheDataProvider;
import com.dataiku.dip.analysis.ml.hf.ModelCacheDownloadService;
import com.dataiku.dip.analysis.ml.hf.ModelCacheService;
import com.dataiku.dip.analysis.model.core.ResolvedCoreParams;
import com.dataiku.dip.code.AutomationNodeCodeEnvsAccessService;
import com.dataiku.dip.code.CodeEnvResolutionService;
import com.dataiku.dip.code.DesignNodeCodeEnvsAccessService;
import com.dataiku.dip.connections.SQLBaseConnectionService;
import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.license.LocalOnlyBackendLicenseStatusService;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.reports.NoopReflectedEventsService;
import com.dataiku.dip.security.RegularPasswordEncryptionService;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.audit.NoopAuditTrailBufferService;
import com.dataiku.dip.security.auth.SharedSecretAuthService;
import com.dataiku.dip.security.impersonation.NoopImpersonationResolverService;
import com.dataiku.dip.security.impersonation.UserImpersonationTarget;
import com.dataiku.dip.security.jwt.JwtVerificationService;
import com.dataiku.dip.security.model.NoopCredentialsService;
import com.dataiku.dip.security.process.InsecureProcessesLaunchService;
import com.dataiku.dip.security.tickets.SingleTicketService;
import com.dataiku.dip.server.DkuStandardServletMultipartResolver;
import com.dataiku.dip.server.JettyUtils;
import com.dataiku.dip.server.SharedSecretUtils;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.controllers.AuditedCallAspect;
import com.dataiku.dip.server.services.DKUTransactionService;
import com.dataiku.dip.server.services.GraphiteReportingService;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.util.ApiKeyUtils;
import com.dataiku.dip.util.ServletUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.MainUtils;
import com.dataiku.dip.utils.OperatingSystemInformation;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.ServletHolder;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.ConnectionFactory;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Connector;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Handler;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.HttpConfiguration;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.HttpConnectionFactory;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Server;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.ServerConnector;
import com.dataiku.lambda.LambdaCallTracingAspect;
import com.dataiku.lambda.LambdaCodeEnvSettingsProvider;
import com.dataiku.lambda.LambdaContext;
import com.dataiku.lambda.MetricsServlet;
import com.dataiku.lambda.StdLambdaContext;
import com.dataiku.lambda.admin.AuthAdminController;
import com.dataiku.lambda.admin.CodeEnvsAdminController;
import com.dataiku.lambda.admin.InternalApiKeyPrivilegedIntercomController;
import com.dataiku.lambda.admin.IsAliveController;
import com.dataiku.lambda.admin.ModelCacheAdminController;
import com.dataiku.lambda.admin.MonitoringController;
import com.dataiku.lambda.admin.ServerSettingsAdminController;
import com.dataiku.lambda.admin.ServicesAdminController;
import com.dataiku.lambda.auth.AdminAuthCRUDService;
import com.dataiku.lambda.auth.ApiNodeAuthVerificationService;
import com.dataiku.lambda.auth.AuthVerificationService;
import com.dataiku.lambda.auth.LambdaIntercomApiSecretAuthService;
import com.dataiku.lambda.codeenvs.CodeEnvsService;
import com.dataiku.lambda.controllers.DebugController;
import com.dataiku.lambda.controllers.FullyManagedEndpointsController;
import com.dataiku.lambda.controllers.FunctionEndpointsController;
import com.dataiku.lambda.controllers.LookupEndpointsController;
import com.dataiku.lambda.controllers.ModelCacheLambdaIntercomController;
import com.dataiku.lambda.controllers.OpenAPIController;
import com.dataiku.lambda.controllers.PingController;
import com.dataiku.lambda.controllers.PredictionEndpointsController;
import com.dataiku.lambda.controllers.SQLEndpointsController;
import com.dataiku.lambda.dataload.DataLoadManager;
import com.dataiku.lambda.distributed.workers.LambdaWorkerService;
import com.dataiku.lambda.endpoints.EndpointFactory;
import com.dataiku.lambda.misc.LambdaAuditTrailSettingsProvider;
import com.dataiku.lambda.misc.LambdaConnectionsDAO;
import com.dataiku.lambda.misc.LambdaVariablesService;
import com.dataiku.lambda.model.serverconfig.LambdaEndpointConfig;
import com.dataiku.lambda.model.serverconfig.LambdaServerConfig;
import com.dataiku.lambda.monitoring.ActivityMonitoringService;
import com.dataiku.lambda.monitoring.MonitoringService;
import com.dataiku.lambda.services.AliveService;
import com.dataiku.lambda.services.LambdaAuditTrailTargetFactory;
import com.dataiku.lambda.services.LambdaComputeResourceUsageReportingService;
import com.dataiku.lambda.services.LambdaOpenAPIService;
import com.dataiku.lambda.services.ServicesService;
import com.google.common.annotations.VisibleForTesting;
import jakarta.servlet.Servlet;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.CommonAnnotationBeanPostProcessor;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;

public class LambdaServerMain {
    private static Logger logger;

    @VisibleForTesting
    static AnnotationConfigWebApplicationContext createAppContext() {
        AnnotationConfigWebApplicationContext appContext = new AnnotationConfigWebApplicationContext();
        appContext.register(new Class[]{SpringUtils.class});
        appContext.register(new Class[]{ControllersProxySupport.class});
        appContext.register(new Class[]{StdLambdaContext.class});
        appContext.register(new Class[]{EndpointFactory.class});
        appContext.register(new Class[]{ServicesService.class});
        appContext.register(new Class[]{CodeEnvsService.class});
        appContext.register(new Class[]{AdminAuthCRUDService.class});
        appContext.register(new Class[]{SharedSecretAuthService.class});
        appContext.register(new Class[]{JwtVerificationService.class});
        appContext.register(new Class[]{AuthVerificationService.class});
        appContext.register(new Class[]{ApiNodeAuthVerificationService.class});
        appContext.register(new Class[]{NoopAuditTrailBufferService.class});
        appContext.register(new Class[]{AuditTrailService.class});
        appContext.register(new Class[]{NoopCredentialsService.class});
        appContext.register(new Class[]{RegularPasswordEncryptionService.class});
        appContext.register(new Class[]{DKUTransactionService.class});
        appContext.register(new Class[]{LambdaVariablesService.class});
        appContext.register(new Class[]{LambdaConnectionsDAO.class});
        appContext.register(new Class[]{DataLoadManager.class});
        appContext.register(new Class[]{PredictionEndpointsController.class});
        appContext.register(new Class[]{FunctionEndpointsController.class});
        appContext.register(new Class[]{SQLEndpointsController.class});
        appContext.register(new Class[]{LookupEndpointsController.class});
        appContext.register(new Class[]{FullyManagedEndpointsController.class});
        appContext.register(new Class[]{OpenAPIController.class});
        appContext.register(new Class[]{AuthAdminController.class});
        appContext.register(new Class[]{InternalApiKeyPrivilegedIntercomController.class});
        appContext.register(new Class[]{ServicesAdminController.class});
        appContext.register(new Class[]{CodeEnvsAdminController.class});
        appContext.register(new Class[]{ServerSettingsAdminController.class});
        appContext.register(new Class[]{ModelCacheAdminController.class});
        appContext.register(new Class[]{MonitoringController.class});
        appContext.register(new Class[]{PingController.class});
        appContext.register(new Class[]{IsAliveController.class});
        appContext.register(new Class[]{DebugController.class});
        appContext.register(new Class[]{AliveService.class});
        appContext.register(new Class[]{LambdaCodeEnvSettingsProvider.class});
        appContext.register(new Class[]{LambdaAuditTrailSettingsProvider.class});
        appContext.register(new Class[]{LambdaOpenAPIService.class});
        appContext.register(new Class[]{LocalOnlyBackendLicenseStatusService.class});
        appContext.register(new Class[]{MonitoringService.class});
        appContext.register(new Class[]{ActivityMonitoringService.class});
        appContext.register(new Class[]{LambdaAuditTrailTargetFactory.class});
        appContext.register(new Class[]{LambdaComputeResourceUsageReportingService.class});
        appContext.register(new Class[]{LambdaWorkerService.class});
        appContext.register(new Class[]{AutomationNodeCodeEnvsAccessService.class});
        appContext.register(new Class[]{DesignNodeCodeEnvsAccessService.class});
        appContext.register(new Class[]{CodeEnvResolutionService.class});
        appContext.register(new Class[]{LambdaIntercomApiSecretAuthService.class});
        appContext.register(new Class[]{HuggingFaceClientFactory.class});
        appContext.register(new Class[]{ModelCacheDataProvider.class});
        appContext.register(new Class[]{ModelCacheService.class});
        appContext.register(new Class[]{ModelCacheDownloadService.class});
        appContext.register(new Class[]{NoopReflectedEventsService.class});
        appContext.register(new Class[]{ModelCacheLambdaIntercomController.class});
        appContext.register(new Class[]{SingleTicketService.class});
        appContext.register(new Class[]{NoopImpersonationResolverService.class});
        appContext.register(new Class[]{InsecureProcessesLaunchService.class});
        appContext.register(new Class[]{SQLBaseConnectionService.class});
        appContext.register(new Class[]{OperatingSystemInformation.class});
        return appContext;
    }

    public static void main(String[] args) throws Exception {
        ApplicationConfigurator.autoconfigure();
        MainLoggingConfigurator.configure((MainLoggingConfigurator.ProcessType)MainLoggingConfigurator.ProcessType.APIMAIN);
        DKUApp.setProcessType((MainLoggingConfigurator.ProcessType)MainLoggingConfigurator.ProcessType.APIMAIN);
        long init = System.currentTimeMillis();
        File errFile = null;
        try {
            Logger.getLogger((String)"com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.WebAppClassLoader").setLevel(Level.INFO);
            if (System.getenv("DKU_APIMAIN_PORT") == null) {
                throw new IllegalArgumentException("Missing DKU_APIMAIN_PORT environment variable");
            }
            if (System.getenv("DKU_LAMBDA_HOME") == null) {
                throw new IllegalArgumentException("Missing DKU_LAMBDA_HOME environment variable");
            }
            File homeDir = new File(System.getenv("DKU_LAMBDA_HOME"));
            if (!homeDir.isDirectory()) {
                throw new IllegalAccessException("Home dir does not exist: " + homeDir.getAbsolutePath());
            }
            errFile = new File(homeDir, "error.json");
            if (errFile.exists() && !errFile.delete()) {
                logger.error((Object)("Can't delete pre-existing error file: " + errFile.getAbsolutePath()));
            }
            if (System.getenv("DKUINSTALLDIR") == null) {
                throw new IllegalArgumentException("Missing DKUINSTALLDIR environment variable");
            }
            MainLoggingConfigurator.configureLimits();
            MainUtils.printLambdaHello();
            BuiltinsLoader.load();
            DKUtils.forceInit(FormatParams.class);
            ScriptStep.loadClass();
            DKUtils.forceInit(LambdaEndpointConfig.class);
            AnnotationConfigWebApplicationContext appContext = LambdaServerMain.createAppContext();
            ServletContextHandler sch = ServletUtils.createServletContext((int)100000000, (String)"/");
            appContext.setServletContext(sch.getServletContext());
            appContext.refresh();
            appContext.getBeanFactory().addBeanPostProcessor((BeanPostProcessor)new CommonAnnotationBeanPostProcessor());
            logger.info((Object)"Creating the dispatcher servlet");
            ServletHolder servletHolder = new ServletHolder((Servlet)new DispatcherServlet((WebApplicationContext)appContext));
            sch.addServlet(servletHolder, "/*");
            ServletUtils.addMultiPartElementConfig((ServletHolder)servletHolder, (File)new File(ApplicationConfigurator.getBaseFolderF(), "tmp/upload-multipart"), (int)1000000);
            long servicesReady = System.currentTimeMillis();
            logger.info((Object)("Services ready after " + (servicesReady - init) + "ms"));
            LambdaContext lambdaContext = (LambdaContext)SpringUtils.getBean(StdLambdaContext.class);
            lambdaContext.checkMayRun();
            LambdaServerConfig serverConfig = lambdaContext.getMandatoryConfig();
            if (serverConfig.hideStackTracesAndLogTails) {
                logger.info((Object)"Configuring hiding stack traces and log tails in error replies");
                DKUApp.setSecurityFlags((boolean)false, (boolean)true, (boolean)true, (boolean)false, (boolean)false);
            } else {
                logger.info((Object)"Configuring NOT hiding stack traces and log tails in error replies");
            }
            if (!lambdaContext.getAuditConfig().logQueryCalls) {
                LambdaCallTracingAspect.setIgnoredQueryCalls();
            }
            NoopImpersonationResolverService resolver = (NoopImpersonationResolverService)SpringUtils.getBean(NoopImpersonationResolverService.class);
            if (null != serverConfig.devLambdaServerSettings) {
                DKUtils.forceInit(ResolvedCoreParams.class);
                if (null != serverConfig.devLambdaServerSettings.unixUser) {
                    resolver.setSettings(true, new UserImpersonationTarget(serverConfig.devLambdaServerSettings.unixUser, null));
                }
            }
            ApiKeyUtils.setUseHashedApiKeys((boolean)serverConfig.hashApiKeys);
            DSSMetrics.registerJVMMetrics();
            DSSMetrics.startJMXReporter();
            LambdaServerMain.startGraphiteReporterIfNeeded();
            LambdaServerMain.startActivityReporterIfNeeded();
            SharedSecretUtils.getSharedSecret((boolean)true);
            Integer backendPort = Integer.parseInt(System.getenv("DKU_APIMAIN_PORT"));
            logger.info((Object)("Starting on port " + backendPort));
            Server server = new Server(backendPort.intValue());
            HttpConfiguration httpConfig = JettyUtils.createHttpConfiguration();
            HttpConnectionFactory http = new HttpConnectionFactory(httpConfig);
            ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{http});
            connector.setPort(backendPort.intValue());
            connector.setIdleTimeout(-1L);
            server.setConnectors((Connector[])new ServerConnector[]{connector});
            JettyUtils.addHandlers((Server)server, (ServletContextHandler)sch);
            logger.info((Object)"Loaded the servlet");
            server.start();
            long serverStarted = System.currentTimeMillis();
            logger.info((Object)("Server started after " + (serverStarted - servicesReady) + "ms"));
            String localMetricsPort = System.getenv("DKU_APINODE_LOCAL_METRICS_PORT");
            if (StringUtils.isNotBlank((String)localMetricsPort)) {
                int metricsPort = Integer.parseInt(localMetricsPort);
                logger.info((Object)("Starting local metrics server on port " + metricsPort));
                Server metricsServer = new Server(InetSocketAddress.createUnresolved("127.0.0.1", metricsPort));
                HttpConfiguration metricsHttpConfig = JettyUtils.createHttpConfiguration();
                HttpConnectionFactory metricsHttp = new HttpConnectionFactory(metricsHttpConfig);
                ServerConnector metricsConnector = new ServerConnector(metricsServer, new ConnectionFactory[]{metricsHttp});
                metricsConnector.setPort(metricsPort);
                metricsConnector.setIdleTimeout(-1L);
                metricsServer.setConnectors((Connector[])new ServerConnector[]{metricsConnector});
                ServletContextHandler metricsSch = ServletUtils.createServletContext((int)100000000, (String)"/");
                metricsSch.addServlet(new ServletHolder((Servlet)new MetricsServlet()), "/*");
                metricsServer.setHandler((Handler)metricsSch);
                metricsServer.start();
            }
            server.join();
        }
        catch (Exception e) {
            logger.error((Object)"Server start failed", (Throwable)e);
            try {
                JSON.prettyToFile((Object)new SerializedError((Throwable)e, true), errFile);
            }
            catch (Throwable t) {
                logger.error((Object)"Can't serialize error", t);
            }
            System.exit(1);
        }
    }

    private static void startGraphiteReporterIfNeeded() throws IOException {
        LambdaServerConfig lsc = ((StdLambdaContext)((Object)SpringUtils.getBean(StdLambdaContext.class))).getMandatoryConfig();
        if (!StringUtils.isBlank((String)lsc.graphiteCarbonServerURL)) {
            Object graphitePrefix = GraphiteReportingService.getPrefix((String)lsc.graphiteCarbonPrefix);
            if (System.getenv("DKU_GRAPHITE_ADDITIONAL_PREFIX") != null) {
                graphitePrefix = (String)graphitePrefix + "." + System.getenv("DKU_GRAPHITE_ADDITIONAL_PREFIX");
            }
            Pair hostPort = GraphiteReportingService.getUrl((String)lsc.graphiteCarbonServerURL);
            Graphite graphite = new Graphite((String)hostPort.first, ((Integer)hostPort.second).intValue());
            GraphiteReporter reporter = GraphiteReporter.forRegistry((MetricRegistry)DSSMetrics.registry()).prefixedWith((String)graphitePrefix + ".apinodeserver").convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).build(graphite);
            reporter.start((long)lsc.graphiteCarbonIntervalMinutes, TimeUnit.MINUTES);
        }
    }

    private static void startActivityReporterIfNeeded() throws IOException {
        ActivityMonitoringService activityMonitoringService = (ActivityMonitoringService)SpringUtils.getBean(ActivityMonitoringService.class);
        activityMonitoringService.scheduleSendActivityIfNeeded(1);
    }

    static {
        System.setProperty("DIP_HOME", MockableSystem.getenv((String)"DIP_HOME"));
        logger = Logger.getLogger((String)"dku");
    }

    @Configuration
    @EnableAspectJAutoProxy
    public static class ControllersProxySupport
    extends WebMvcConfigurationSupport {
        @Bean
        public LambdaCallTracingAspect tracer() {
            return new LambdaCallTracingAspect();
        }

        @Bean
        public AuditedCallAspect auditer() {
            return new AuditedCallAspect();
        }

        @Bean
        public MultipartResolver multipartResolver() {
            return new DkuStandardServletMultipartResolver();
        }

        public void configurePathMatch(PathMatchConfigurer configurer) {
            configurer.setUseTrailingSlashMatch(Boolean.valueOf(true));
        }
    }
}

