/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda;

import com.codahale.metrics.json.MetricsModule;
import com.dataiku.common.server.APIError;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.exceptions.ICodedException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.dropwizard.DropwizardExports;
import io.prometheus.client.exporter.common.TextFormat;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class MetricsServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.metrics");

    protected void writeJSON(HttpServletResponse resp, Object o) throws IOException {
        resp.setContentType("application/json; charset=UTF-8");
        resp.getWriter().write(JSON.json((Object)o));
    }

    protected void sendError(HttpServletResponse resp, Throwable error) throws IOException {
        ICodedException ie;
        logger.error((Object)"Call failed", error);
        System.err.flush();
        System.out.flush();
        resp.setStatus(500);
        resp.setContentType("application/json");
        APIError reflectedError = new APIError(error, true);
        if (error instanceof ICodedException && (ie = (ICodedException)error).getCode() != null) {
            reflectedError.withCode(ie.getCode());
        }
        resp.getWriter().write(JSON.json((Object)reflectedError));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = req.getPathInfo();
        long startTime = System.currentTimeMillis();
        if (!path.equals("/ping")) {
            logger.debug((Object)("Received command : " + path));
        }
        try {
            switch (path) {
                case "/ping": {
                    this.writeJSON(resp, new JSONObject());
                    return;
                }
                case "/metrics-json": {
                    System.gc();
                    ObjectMapper om = new ObjectMapper().registerModule((Module)new MetricsModule(TimeUnit.SECONDS, TimeUnit.MILLISECONDS, false));
                    om.writerWithDefaultPrettyPrinter().writeValue((OutputStream)resp.getOutputStream(), (Object)DSSMetrics.registry());
                    return;
                }
                case "/metrics-prometheus": {
                    CollectorRegistry collector = new CollectorRegistry();
                    collector.register((Collector)new DropwizardExports(DSSMetrics.registry()));
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)resp.getOutputStream());
                    TextFormat.write004((Writer)writer, (Enumeration)collector.metricFamilySamples());
                    writer.flush();
                    return;
                }
                default: {
                    throw new Exception("Unknown command " + path);
                }
            }
        }
        catch (Throwable e) {
            this.sendError(resp, e);
            return;
        }
        finally {
            long endTime = System.currentTimeMillis();
            if (!path.equals("/ping")) {
                logger.debug((Object)("Command " + path + " processed in " + (endTime - startTime) + "ms"));
            }
        }
    }
}

