/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.auth;

import com.dataiku.common.audit.AuditContextBase;
import com.dataiku.common.audit.AuthError;
import com.dataiku.common.server.APIKeyBase;
import com.dataiku.dip.exceptions.NotAuthenticatedException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.auth.APIAuthUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.lambda.auth.AuthMethod;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang.Validate;

public class ApiKeyAuthMethod<T extends APIKeyBase>
implements AuthMethod<T> {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.apinode.auth.service");
    public static final String AUDIT_LOG_REF_FAILED_API_KEY = "failedAPIKey";
    public static final String AUDIT_LOG_REF_API_KEY_ID = "apiKeyId";
    public static final String AUDIT_LOG_REF_API_KEY_LABEL = "apiKeyLabel";
    private final Function<String, Optional<T>> apiKeySupplier;

    public ApiKeyAuthMethod(Function<String, Optional<T>> apiKeySupplier) {
        this.apiKeySupplier = apiKeySupplier;
    }

    public ApiKeyAuthMethod(List<T> apiKeys) {
        this((String apiKey) -> apiKeys.stream().filter(key -> key.key.equals(apiKey)).findAny());
        Validate.notNull(apiKeys, (String)"Bad config (null realm)");
    }

    @Override
    public void validate(HttpServletRequest request) throws UnauthorizedException, NotAuthenticatedException {
        logger.trace((Object)"API apiKey configured, verifying the api apiKey");
        String reqApiKey = APIAuthUtils.extractApiKey((HttpServletRequest)request);
        APIKeyBase apiKey = (APIKeyBase)this.apiKeySupplier.apply(reqApiKey).orElseThrow(() -> {
            AuditContextBase.addCustom((String)AUDIT_LOG_REF_FAILED_API_KEY, (String)reqApiKey);
            return new UnauthorizedException("Unknown API apiKey", AuthError.UNKNOWN_API_KEY.name());
        });
        AuditContextBase.addCustom((String)AUDIT_LOG_REF_API_KEY_ID, (String)apiKey.id);
        AuditContextBase.addCustom((String)AUDIT_LOG_REF_API_KEY_LABEL, (String)apiKey.label);
    }

    @Override
    public T getApiKeyForInternalCalls(HttpServletRequest request) {
        try {
            return (T)((APIKeyBase)this.apiKeySupplier.apply(APIAuthUtils.extractApiKey((HttpServletRequest)request)).orElse(null));
        }
        catch (Exception e) {
            throw ErrorContext.iae((String)"Could not fetch API key from request", (Exception)e);
        }
    }
}

