/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.auth;

import com.dataiku.dip.exceptions.NotAuthenticatedException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dss.shadelib.com.google.common.cache.CacheBuilder;
import com.dataiku.dss.shadelib.com.google.common.cache.CacheLoader;
import com.dataiku.dss.shadelib.com.google.common.cache.LoadingCache;
import com.dataiku.lambda.auth.ApiKeyAuthMethod;
import com.dataiku.lambda.auth.AuthMethod;
import com.dataiku.lambda.model.serverconfig.QueryAPIKey;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class TemporaryAPIKeyService
implements AuthMethod<QueryAPIKey> {
    private final LoadingCache<String, QueryAPIKey> cache;
    private final ApiKeyAuthMethod<QueryAPIKey> apiKeyAuthMethod;

    public TemporaryAPIKeyService() {
        CacheLoader<String, QueryAPIKey> loader = new CacheLoader<String, QueryAPIKey>(){

            public QueryAPIKey load(String key) {
                QueryAPIKey apiKey = new QueryAPIKey();
                apiKey.id = SecretKeyGenerator.generate((int)16);
                apiKey.key = key;
                apiKey.createdOn = new Date().getTime();
                apiKey.description = "Temporary key";
                apiKey.label = "TempKey";
                apiKey.createdBy = "API_NODE";
                return apiKey;
            }
        };
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build((CacheLoader)loader);
        this.apiKeyAuthMethod = new ApiKeyAuthMethod(apiKey -> Optional.ofNullable((QueryAPIKey)this.cache.getIfPresent(apiKey)));
    }

    @Override
    public void validate(HttpServletRequest request) throws NotAuthenticatedException, UnauthorizedException {
        this.apiKeyAuthMethod.validate(request);
    }

    public QueryAPIKey getCurrentAPIKey(HttpServletRequest req) {
        try {
            return this.apiKeyAuthMethod.getApiKeyForInternalCalls(req);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public QueryAPIKey getApiKeyForInternalCalls(HttpServletRequest req) {
        return (QueryAPIKey)this.cache.getUnchecked((Object)SecretKeyGenerator.generate((int)32));
    }
}

