/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.controllers;

import com.dataiku.dip.analysis.ml.hf.ModelCacheService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.lambda.auth.LambdaIntercomApiSecretAuthService;
import com.dataiku.lambda.server.LambdaAPIControllerBase;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ModelCacheLambdaIntercomController
extends LambdaAPIControllerBase {
    @Autowired
    private ModelCacheService modelCacheService;
    @Autowired
    private LambdaIntercomApiSecretAuthService authService;

    @RequestMapping(value={"lambda-intercom/ml/hf/model/local-path"}, produces={"application/json"}, method={RequestMethod.GET})
    public void getModelLocalPath(HttpServletRequest req, HttpServletResponse resp, @RequestParam String modelKey) throws Exception {
        this.authService.failIfNoInternalApiSecret(req);
        ModelCacheLambdaIntercomController.writeJSON(resp, new LocalModelInfo(this.modelCacheService.getLocalModelPath(modelKey)));
    }

    @RequestMapping(value={"lambda-intercom/ml/hf/model/base-model-key"}, produces={"application/json"}, method={RequestMethod.GET})
    public void getBaseModelKey(HttpServletRequest req, HttpServletResponse resp, @RequestParam String modelKey) throws Exception {
        this.authService.failIfNoInternalApiSecret(req);
        ModelCacheLambdaIntercomController.writeJSON(resp, this.modelCacheService.getBaseModelKey(modelKey));
    }

    @RequestMapping(value={"lambda-intercom/ml/hf/download-model-if-needed"}, method={RequestMethod.POST})
    public void downloadModel(HttpServletRequest req, @RequestParam String modelKey, @RequestParam(required=false) String connectionName) throws Exception {
        this.authService.failIfNoInternalApiSecret(req);
        this.modelCacheService.downloadModelIfNeeded_Check(modelKey, (AuthCtx)DSSAuthCtx.newNone(), connectionName);
    }

    @RequestMapping(value={"lambda-intercom/ml/hf/model/metadata"}, produces={"application/json"}, method={RequestMethod.GET})
    public void getMetadata(HttpServletRequest req, HttpServletResponse resp, @RequestParam String modelKey, @RequestParam(required=false) String connectionName) throws Exception {
        this.authService.failIfNoInternalApiSecret(req);
        ModelCacheLambdaIntercomController.writeJSON(resp, this.modelCacheService.getModelMetadata_Check(modelKey, (AuthCtx)DSSAuthCtx.newNone(), connectionName));
    }

    public static class LocalModelInfo {
        public final String modelPath;

        LocalModelInfo(String modelPath) {
            this.modelPath = modelPath;
        }
    }
}

