/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.endpoints.pyfunction;

import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.io.SocketBlockLinkKernelException;
import com.dataiku.dip.kernels.IDSSKernelBase;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.APINodeMetrics;
import com.dataiku.lambda.LambdaContext;
import com.dataiku.lambda.ServiceGenContext;
import com.dataiku.lambda.controllers.RequestMetadata;
import com.dataiku.lambda.endpoints.functioncommon.FunctionEndpointHandlerBase;
import com.dataiku.lambda.endpoints.pool.PipelinePool;
import com.dataiku.lambda.endpoints.pyfunction.PyFunctionKernel;
import com.dataiku.lambda.endpoints.pyfunction.PyFunctionPipeline;
import com.dataiku.lambda.model.api.FunctionResponse;
import com.dataiku.lambda.model.serverconfig.PyFunctionEndpointConfig;
import com.dataiku.lambda.model.serverconfig.QueryAPIKey;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class PyFunctionEndpointHandler
extends FunctionEndpointHandlerBase<PyFunctionEndpointConfig, PyFunctionPipeline> {
    @Autowired
    protected LambdaContext lmContext;
    @Autowired
    PasswordEncryptionService passwordEncryptionService;
    protected PipelinePool<PyFunctionPipeline> pool;
    protected Meter requestsMeter;
    protected Meter successRequestMeter;
    protected Timer totalTimer;
    private static Logger logger = Logger.getLogger((String)"dku.lambda.endpoints.pyfunction");

    public PyFunctionEndpointHandler(PyFunctionEndpointConfig config) {
        super(config);
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public final void init(ServiceGenContext context) throws Exception {
        super.init(context);
        assert (this.lmContext != null);
        this.pool = new PipelinePool<PyFunctionPipeline>(this, context.getServiceId(), ((PyFunctionEndpointConfig)this.config).id, this.serverEndpointConfig.pool);
        this.requestsMeter = APINodeMetrics.endpointMeter(context.getServiceId(), ((PyFunctionEndpointConfig)this.config).id, "requests");
        this.successRequestMeter = APINodeMetrics.endpointMeter(context.getServiceId(), ((PyFunctionEndpointConfig)this.config).id, "successRequests");
        this.totalTimer = APINodeMetrics.endpointTimer(context.getServiceId(), ((PyFunctionEndpointConfig)this.config).id, "totalProcessing");
        this.pool.init();
    }

    @Override
    public PyFunctionPipeline instantiatePipeline() throws Exception {
        return new PyFunctionPipeline((PyFunctionEndpointConfig)this.config, this.context);
    }

    @Override
    public synchronized void destroy() {
        logger.info((Object)"Destroy endpoint");
        this.pool.destroy();
    }

    @Override
    public FunctionResponse run(JsonObject input, QueryAPIKey apiKey, @Nonnull RequestMetadata requestMetadata) throws Exception {
        FunctionResponse resp = new FunctionResponse();
        this.requestsMeter.mark();
        long beforeAcquire = System.nanoTime();
        PyFunctionPipeline pipeline = this.pool.acquire();
        long afterAcquire = System.nanoTime();
        try {
            FunctionResponse functionResponse;
            block16: {
                DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((Timer)this.totalTimer);
                try {
                    PyFunctionKernel.FunctionRequest kernelReq = new PyFunctionKernel.FunctionRequest();
                    kernelReq.params = input;
                    kernelReq.httpRequestMetadata = JSON.toJsonObject((Object)requestMetadata);
                    if (apiKey != null) {
                        kernelReq.usedAPIKey = this.passwordEncryptionService.decryptIfEncrypted(apiKey.key);
                    }
                    PyFunctionKernel.FunctionResponse kernelRet = (PyFunctionKernel.FunctionResponse)pipeline.getLink().execute((Object)kernelReq, PyFunctionKernel.FunctionResponse.class, "Failed to run function");
                    long afterExecute = System.nanoTime();
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Kernel returned " + JSON.json((Object)kernelRet)));
                    }
                    if (!kernelRet.ok) {
                        throw new Exception(kernelRet.reason);
                    }
                    this.successRequestMeter.mark();
                    if (kernelRet.resp == null || kernelRet.resp.isJsonNull()) {
                        resp.responseIsEmpty = true;
                    } else {
                        resp.response = kernelRet.resp;
                    }
                    resp.timing.wait = (afterAcquire - beforeAcquire) / 1000L;
                    resp.timing.execution = (afterExecute - afterAcquire) / 1000L;
                    resp.timing.functionInternal = kernelRet.execTimeUS;
                    this.pool.release(pipeline);
                    functionResponse = resp;
                    if (tctx == null) break block16;
                }
                catch (Throwable throwable) {
                    try {
                        if (tctx != null) {
                            try {
                                tctx.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SocketBlockLinkKernelException e) {
                        e.withLogTail((IDSSKernelBase)pipeline.getKernel());
                        throw e;
                    }
                    finally {
                    }
                }
                tctx.close();
            }
            return functionResponse;
        }
        finally {
            this.pool.destroyOnError(pipeline);
        }
    }

    public boolean hasCustomResponse() {
        return ((PyFunctionEndpointConfig)this.config).hasCustomResponse;
    }
}

