/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.endpoints.sqlquery;

import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.queries.QueryParams;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.queries.SQLQueryRuntime;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.APINodeMetrics;
import com.dataiku.lambda.ServiceGenContext;
import com.dataiku.lambda.endpoints.LambdaEndpointHandler;
import com.dataiku.lambda.model.api.ResponseElements;
import com.dataiku.lambda.model.serverconfig.SQLQueryEndpointConfig;
import com.dataiku.lambda.services.ServiceManager;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.springframework.beans.factory.annotation.Autowired;

public class SQLQueryEndpointHandler
extends LambdaEndpointHandler<SQLQueryEndpointConfig> {
    @Autowired
    private PasswordEncryptionService cryptoService;
    private final SQLConnectionProvider.SQLConnectionData connData;
    private final PoolableObjectFactory<SQLConnectionProvider.SQLConnectionWrapper> connectionFactory = new BasePoolableObjectFactory<SQLConnectionProvider.SQLConnectionWrapper>(){

        public SQLConnectionProvider.SQLConnectionWrapper makeObject() throws Exception {
            logger.info((Object)"Creating a new SQL connection");
            return SQLConnectionProvider.newConnection((String)((SQLQueryEndpointConfig)((SQLQueryEndpointHandler)SQLQueryEndpointHandler.this).config).connection, (AuthCtx)DSSAuthCtx.newNone(), null);
        }

        public void activateObject(SQLConnectionProvider.SQLConnectionWrapper connection) throws Exception {
            logger.debug((Object)"Activate SQLServer connection");
        }

        public void destroyObject(SQLConnectionProvider.SQLConnectionWrapper connection) throws Exception {
            logger.debug((Object)"Destroy SQL connection");
            connection.close();
        }

        public void passivateObject(SQLConnectionProvider.SQLConnectionWrapper connection) throws Exception {
            logger.debug((Object)"Passivate SQL connection");
        }

        public boolean validateObject(SQLConnectionProvider.SQLConnectionWrapper connection) {
            boolean bl;
            block8: {
                logger.debug((Object)"Validate SQL connection");
                ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
                SelectQueryBuilder qb = new SelectQueryBuilder();
                qb.select(ef.cst((Object)1));
                String select1 = qb.toSQL(SQLQueryEndpointHandler.this.connData.getDialect());
                Statement statement = connection.createStatement();
                try {
                    statement.execute(select1);
                    bl = true;
                    if (statement == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        logger.info((Object)"SQL connection is not functional, dropping it", (Throwable)e);
                        return false;
                    }
                }
                statement.close();
            }
            return bl;
        }
    };
    private GenericObjectPool<SQLConnectionProvider.SQLConnectionWrapper> connectionsPool = new GenericObjectPool(this.connectionFactory);
    private static DKULogger logger = DKULogger.getLogger((String)"dku.lambda.custPredEPH");

    public SQLQueryEndpointHandler(SQLQueryEndpointConfig config) throws IOException, SQLException, DKUSecurityException {
        super(config);
        SpringUtils.getInstance().autowire((Object)this);
        this.connData = SQLConnectionProvider.getConnectionData_NT((AuthCtx)DSSAuthCtx.newNone(), null, (String)config.connection);
    }

    @Override
    public final void init(ServiceGenContext context) throws Exception {
        super.init(context);
        assert (this.lmContext != null);
        this.connectionsPool.setLifo(false);
        this.connectionsPool.setTestOnBorrow(false);
        this.connectionsPool.setTestOnReturn(false);
        this.connectionsPool.setTestWhileIdle(true);
        this.connectionsPool.setWhenExhaustedAction((byte)1);
        this.connectionsPool.setMinEvictableIdleTimeMillis(this.serverEndpointConfig.sql.connectionsEvictionTimeMS);
        this.connectionsPool.setTimeBetweenEvictionRunsMillis(this.serverEndpointConfig.sql.evictionIntervalMS);
        this.connectionsPool.setMaxActive(this.serverEndpointConfig.sql.maxPooledConnections);
    }

    @Override
    public synchronized void destroy() {
        logger.info((Object)"Destroy endpoint");
        try {
            this.connectionsPool.close();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to destroy endpoint", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueriesResult run(JsonObject input, ServiceManager.RefcountedEndpoint re) throws Exception {
        QueriesResult ret = new QueriesResult();
        ret.apiContext = this.newContext();
        APINodeMetrics.endpointMeter(this.context.getServiceId(), ((SQLQueryEndpointConfig)this.config).id, "requests").mark();
        Exception error = null;
        try (DSSMetrics.TimeCtx tctx = APINodeMetrics.endpointTimeCtx(this.context.getServiceId(), ((SQLQueryEndpointConfig)this.config).id, "totalProcessing");){
            SQLConnectionProvider.SQLConnectionWrapper wrapper = (SQLConnectionProvider.SQLConnectionWrapper)this.connectionsPool.borrowObject();
            try {
                for (SQLQueryEndpointConfig.SQLQueryEndpointQuery eq : ((SQLQueryEndpointConfig)this.config).queries) {
                    ArrayList<Object> paramValues = new ArrayList<Object>();
                    for (SQLQueryEndpointConfig.SQLQueryEndpointParam queryParam : eq.inputParameters) {
                        JsonElement value = input.get(queryParam.name);
                        if (value == null) {
                            paramValues.add(null);
                            continue;
                        }
                        if (value instanceof JsonPrimitive) {
                            JsonPrimitive jp = (JsonPrimitive)value;
                            if (jp.isNumber()) {
                                paramValues.add(jp.getAsNumber());
                                continue;
                            }
                            if (jp.isBoolean()) {
                                paramValues.add(jp.getAsBoolean());
                                continue;
                            }
                            paramValues.add(jp.getAsString());
                            continue;
                        }
                        throw new IllegalArgumentException("Bad value kind for parameter " + queryParam.name);
                    }
                    QueryParams queryParams = new QueryParams();
                    queryParams.sql = eq.query;
                    SQLQueryRuntime runtime = new SQLQueryRuntime(queryParams, paramValues, this.connData, wrapper, (AuthCtx)DSSAuthCtx.newNone(), null);
                    logger.info((Object)("Run query " + queryParams.sql + "\nwith params " + JSON.json(paramValues)));
                    try {
                        runtime.init(eq.maxResults);
                        QueryRunResult qrr = runtime.getPage(0, eq.maxResults > 0 ? eq.maxResults : Integer.MAX_VALUE, null);
                        if (qrr.errorMessage != null) {
                            throw new SQLException("Query failed: " + qrr.errorMessage);
                        }
                        QueryResult qr = new QueryResult();
                        for (QueryRunResult.ScriptRunResultColumn origColumn : qrr.columns) {
                            qr.columns.add(new QueryResultColumn(origColumn.name, origColumn.type));
                        }
                        for (String[] origRow : qrr.rows) {
                            qr.rows.add(origRow);
                        }
                        qr.updatedRows = qrr.updatedRows;
                        ret.results.add(qr);
                    }
                    finally {
                        runtime.close(false, false);
                    }
                    if (!eq.postCommit) continue;
                    logger.debug((Object)"Committing as requested by query");
                    wrapper.commit();
                }
            }
            finally {
                this.connectionsPool.returnObject((Object)wrapper);
            }
        }
        catch (Exception exc) {
            error = exc;
            throw exc;
        }
        finally {
            this.audit(re, input, ret, ret.apiContext, error);
        }
        return ret;
    }

    private void audit(ServiceManager.RefcountedEndpoint re, JsonObject input, QueriesResult ret, ResponseElements.Context apiContext, Exception error) {
        try {
            this.createEvent(re, logger, input, this.createResult(JSON.toJsonArray(ret.results)), error, JSON.json((Object)ret), JSON.json((Object)apiContext)).ifPresent(AuditTrailService.EmittableAuditObj::emit);
        }
        catch (Exception e) {
            logger.warn((Object)"failed to log queries", (Throwable)e);
        }
    }

    @Override
    protected String getMessageType() {
        return "sql-query";
    }

    @Override
    protected String getQueryType() {
        return "sql-query";
    }

    public static class QueriesResult {
        public List<QueryResult> results = new ArrayList<QueryResult>();
        public ResponseElements.Context apiContext;
    }

    public static class QueryResult {
        public List<QueryResultColumn> columns = new ArrayList<QueryResultColumn>();
        public List<Object[]> rows = new ArrayList<Object[]>();
        public long updatedRows;
    }

    public static class QueryResultColumn {
        public String name;
        public String type;

        public QueryResultColumn(String name, String type) {
            this.name = name;
            this.type = type;
        }
    }
}

