(function() {
    "use strict";

    function aiDatasetDescriptionsModalController(
        $scope,
        $rootScope,
        AIExplanationService,
    ) {
        $scope.init = function (object, canWriteProjectFn) {
            $scope.object = object
            $scope.canWriteProject = canWriteProjectFn
        };
        
        $scope.canCloseModal = function() {
            if (!$scope.explanationRequested) {
                return true;
            }
            if (!$scope.abortRequested) {
                AIExplanationService.abortExplain($scope.lastJobId).catch(function(r) {
                    setErrorInScope.bind($rootScope)(r.data, r.status, r.headers);
                });
                $scope.abortRequested = true;
                $scope.explanationRequested = false;
            }
            return true;
        };
    }

    angular.module("dataiku.aiDatasetDescriptions")
        .controller("AIDatasetDescriptionsModalController", aiDatasetDescriptionsModalController);
})();
