(function() {
    'use strict';

    const app = angular.module('dataiku.analysis.mlcore');

    app.component("timeseriesIdentifiersFilters", {
        bindings: {
            objectId: '@',
            identifiers: '<'
        },
        templateUrl: "/templates/ml/prediction-model/timeseries/identifiers-filters.html",
        controller: function($scope, LocalStorage) {
            const $ctrl = this;

            $ctrl.$onInit = function() {
                // restore selection from session or local storage
                const storedSelectionKey = $ctrl.getStoredSelectionKey();
                $ctrl.filtersModel = JSON.parse(sessionStorage.getItem(storedSelectionKey) || '{}');
                if (JSON.stringify($ctrl.filtersModel) === '{}') {
                    $ctrl.filtersModel = LocalStorage.get(storedSelectionKey) || {};
                }

                $ctrl.emit($ctrl.filtersModel);
            };

            $ctrl.onChange = function() {
                $ctrl.emit($ctrl.filtersModel);

                // store selection
                const storedSelectionKey = $ctrl.getStoredSelectionKey();
                LocalStorage.set(storedSelectionKey, $ctrl.filtersModel);
                sessionStorage.setItem(storedSelectionKey, JSON.stringify($ctrl.filtersModel));
            };

            $ctrl.emit = function(filtersModel) {
                $scope.$emit('timeseriesIdentifiersFiltersUpdated', filtersModel);
            };

            $ctrl.getStoredSelectionKey = function() {
                // backward compatible
                return 'dss.ml.forecastChart.' + $ctrl.objectId + '.filters';
            };
        }
    });
})();
