(function() {
    'use strict';
    /** @typedef {import('../../types').ChartType} ChartType */

    /** @type {Record<string, ChartType>} */
    const CHART_TYPES = {
        GROUPED_COLUMNS: 'grouped_columns',
        STACKED_BARS: 'stacked_bars',
        STACKED_COLUMNS: 'stacked_columns',
        MULTI_COLUMNS_LINES: 'multi_columns_lines',
        LINES: 'lines',
        STACKED_AREA: 'stacked_area',
        PIVOT_TABLE: 'pivot_table',
        SCATTER: 'scatter',
        SCATTER_MULTIPLE_PAIRS: 'scatter_multiple_pairs',
        GROUPED_XY: 'grouped_xy',
        BINNED_XY: 'binned_xy',
        DENSITY_2D: 'density_2d',
        KPI: 'kpi',
        MAP: 'map',
        SCATTER_MAP: 'scatter_map',
        DENSITY_HEAT_MAP: 'density_heat_map',
        GEOMETRY_MAP: 'geom_map',
        ADMINISTRATIVE_MAP: 'admin_map',
        GRID_MAP: 'grid_map',
        BOXPLOTS: 'boxplots',
        PIE: 'pie',
        LIFT: 'lift',
        WEBAPP: 'webapp',
        TREEMAP: 'treemap',
        HEATMAP: 'heatmap',
        HEATMAP_MAP: 'heatmap_map',
        GROUPED_SCATTER_MAP: 'grouped_scatter_map',
        RADAR: 'radar',
        GAUGE: 'gauge',
        SANKEY: 'sankey',
        NUMERICAL_HEATMAP: 'numerical_heatmap',
        FILTERS: 'filters'
    }

    angular.module('dataiku.constants')
        .constant('CHART_TYPES', CHART_TYPES);

}());
