(function(){
    'use strict';

    const app = angular.module('dataiku.dashboards');

    /**
     * Was previously located here: src/main/platypus/static/dataiku/js/dashboards/view.js
     */
    app.directive('dashboardTile', function($stateParams, TileUtils, FiltersPanelPosition, FiltersPanelDirection, $timeout, ColorUtils, DashboardPageUtils, Debounce) {
        return {
            restrict: 'EA',
            templateUrl: '/templates/dashboards/tile.html',
            scope: {
                tile: '<',
                selected: '<', // boolean
                insight: '<',
                editable: '<',
                hook: '<',
                activeFilters: '<',
                filters: '<',
                page: '<',
                dashboardTheme: '<',
                currentGroupTileIdInEditMode: '<', // string | null
                showGrid: '<', // boolean
                tileSpacing: '<', // number
                preselectedTile: '<', // DashboardTile
                canExportDatasets: '<', // boolean
                insightsMap: '<', // { [insightId: string]: Insight }
                accessMap: '<', // { [insightId: string]: string }

                filtersChange: '&', // ({ $filters }) => void
                filtersParamsChange: '&', // ({ $filtersParams }) => void,
                isDeactivatedChange: '&', // ({ $isDeactivated }) => void
                preselectedTileChange: '&', // ({ $preselectedTile }) => void
                raiseError: '&', // ({ $errorData }) => void,
                isTileLockedChange: '&' // () => void,
            },
            link: function($scope, $element) {
                $scope.$stateParams = $stateParams;
                $scope.FiltersPanelPosition = FiltersPanelPosition;
                $scope.FiltersPanelDirection = FiltersPanelDirection;
                $scope.openUploadPictureDialog = TileUtils.openUploadPictureDialog;

                $scope.getResizeImageClass = function(resizeImageMode) { //convert mode to css class name
                    switch (resizeImageMode) {
                        case 'STRETCH_SIZE': return 'stretch-size';
                        case 'ORIG_SIZE': return 'orig-size';
                        case 'FIT_CROP_SIZE': return 'fit-crop-size';
                        default: return 'fit-size';
                    }

                };

                if (TileUtils.isGroupTile($scope.tile)) {
                    $scope.tileHeight = 0;
                    const { backgroundColor, gridColor } = computeColors();
                    $scope.backgroundColor = backgroundColor;
                    $scope.gridColor = gridColor;
                    $scope.groupTileContainerBackgroundColor = DashboardPageUtils.computeGridContainerBackgroundColor($scope.showGrid, $scope.editable, backgroundColor, gridColor);

                    const updateTileHeight = Debounce().withDelay(50, 50).wrap(() => {
                        $timeout(() => {
                            const boundingClientRect = $element[0].getBoundingClientRect();
                            $scope.tileHeight = boundingClientRect.height;
                            $scope.tileWidth = boundingClientRect.width;
                        });
                    });

                    updateTileHeight();

                    $scope.$watchGroup(
                        ['tile.backgroundColor', 'tile.backgroundOpacity', 'showGrid', 'editable'], () => {
                            const { backgroundColor, gridColor } = computeColors();
                            $scope.backgroundColor = backgroundColor;
                            $scope.gridColor = gridColor;
                            $scope.groupTileContainerBackgroundColor = DashboardPageUtils.computeGridContainerBackgroundColor($scope.showGrid, $scope.editable, backgroundColor, gridColor);
                        }
                    );

                    $scope.$watchCollection('tile.box', () => {
                        updateTileHeight();
                    });

                    $(window).on('resize', updateTileHeight);

                    $scope.$on('$destroy', function() {
                        $(window).off('resize', updateTileHeight);
                    });
                }

                function computeColors() {
                    const backgroundColor = ColorUtils.getHexWithAlpha($scope.tile.backgroundColor, $scope.tile.backgroundOpacity);
                    const gridColor = DashboardPageUtils.getGridColor($scope.tile.backgroundColor, $scope.tile.backgroundOpacity);
                    return { backgroundColor, gridColor };
                }
            }
        };
    });
})();
