(function(){
    'use strict';

    const app = angular.module('dataiku.dashboards');

    /**
     * Was previously located here: src/main/platypus/static/dataiku/js/dashboards/view.js
     */
    app.directive('dashboardZone', function($rootScope, DataikuAPI, $stateParams, $state, $location, DashboardFilters, $timeout) {
        return {
            restrict: 'EA',
            templateUrl: '/templates/dashboards/zone.html',
            replace: true,
            link: function($scope, elements, attrs) {
                $scope.editable = $scope.$eval(attrs.editable);
                $scope.insightsMap = {};
                $scope.insightAccessMap = {};
                DashboardFilters.setInsightsMap($scope.insightsMap);

                if ($scope.dashboard && $scope.dashboard.pages) {
                    $scope.dashboard.pages.forEach(function(page) {
                        delete page.$enriched;
                    });
                }

                $scope.loadPage = function(pageIdx, forceRefresh, onlyAccessMap) {
                    if (!($scope.dashboard.pages[pageIdx] || {}).id) {
                        return;
                    } // Page has not been saved yet
                    if (!$scope.dashboard.pages[pageIdx].$enriched || forceRefresh) {
                        DataikuAPI.dashboards.getEnrichedPage($scope.dashboard.projectKey, $scope.dashboard.id, pageIdx)
                            .success(function(data) {
                                $scope.currentPageIdx = pageIdx;
                                if (!onlyAccessMap) {
                                    angular.extend($scope.insightsMap, data.insightsData);
                                }
                                angular.extend($scope.insightAccessMap, data.insightAccessData);
                                $scope.dashboard.pages[pageIdx].$enriched = true;
                            })
                            .error(setErrorInScope.bind($scope));
                    } else {
                        $scope.currentPageIdx = pageIdx;
                    }
                };

                $scope.hasPagesToDisplay = () => {
                    return $scope.uiState.currentPageIdx != null && !!$scope.dashboard.pages[$scope.uiState.currentPageIdx];
                };

                $scope.$on('dashboardReaderAccessChanged', function() {
                    $scope.loadPage($scope.uiState.currentPageIdx, true, true);
                });

                $scope.$watch('dashboard', function(nv) {
                    if (!nv) {
                        return;
                    }

                    $scope.canEdit = $scope.canEditDashboard(nv);

                    if (!$scope.dashboard.pages.length) {
                        $scope.dashboard.pages.push({});
                    }

                    const firstVisiblePageIdx = $scope.editable ? 0 : nv.pages.findIndex(page => page.show);
                    if ($scope.uiState.currentPageIdx == null && firstVisiblePageIdx >= 0) {
                        if ($stateParams.pageId) {
                            $scope.uiState.currentPageIdx = Math.max(getPageIdxById($stateParams.pageId), firstVisiblePageIdx);
                        } else {
                            $scope.uiState.currentPageIdx = firstVisiblePageIdx;
                        }
                    } else {
                        updateUrl();
                    }
                });

                $scope.$on('dashboardSelectLastTile', function() {
                    if ($scope.uiState.currentPageIdx != null && $scope.dashboard.pages[$scope.uiState.currentPageIdx] != null) {
                        const lastTileIndex = $scope.dashboard.pages[$scope.uiState.currentPageIdx].grid.tiles.length - 1;
                        $scope.uiState.selectedTile = $scope.dashboard.pages[$scope.uiState.currentPageIdx].grid.tiles[lastTileIndex];
                    }
                });

                $scope.$watch('uiState.currentPageIdx', function(nv) {
                    if (nv != null) {
                        $scope.loadPage($scope.uiState.currentPageIdx);
                        updateUrl();
                    }
                });

                $scope.$watch('uiState.pageFilters', function(nv, ov) {
                    if (nv != null && !_.isEqual(nv, ov)) {
                        updateUrl();
                    }
                });

                // On dashboard save
                $scope.$watch('origDashboard', updateUrl);

                function getPageIdxById(pageId) {
                    for (let i = 0; i < $scope.dashboard.pages.length; i++) {
                        if ($scope.dashboard.pages[i].id == pageId) {
                            return i;
                        }
                    }

                    return -1;
                }

                function updateUrl() {

                    const handleUiRouterStateTransition = (statePromise) => statePromise.catch((err) => {
                        /*
                         * A 'transition superseded' error occurs because updateUrl is called twice
                         * before the first ui-router state transition has completed.
                         * In this case, only the last transition is applied.
                         * This error can be safely ignored.
                         */
                        if (err.message !== 'transition superseded') {
                            throw err;
                        }
                    }).finally(() => {
                        $rootScope.$broadcast('dashboardUrlUpdateDone');
                    });

                    const stateOptions = {
                        location: 'replace',
                        inherit: true,
                        notify: false,
                        reload: false
                    };

                    if ($scope.uiState.currentPageIdx == null || $scope.uiState.currentPageIdx === '') {
                        handleUiRouterStateTransition($state.go($state.current, { pageId: '' }, stateOptions));
                        return;
                    }
                    const pageId = ($scope.dashboard.pages[$scope.uiState.currentPageIdx] || {}).id || $scope.uiState.currentPageIdx;
                    const hasUiStateFilters = $scope.uiState.pageFilters || $scope.uiState.pageFilters === '' ;
                    const pageFilters = hasUiStateFilters ? $scope.uiState.pageFilters : $state.params.pageFilters;
                    const filters = pageFilters == null ? $state.params.filters : null;
                    const dashboardId = $scope.dashboard.id;
                    const dashboardName = $scope.dashboard.name;
                    // ensure filters are set in the location as we might load them from it before the async $state.go
                    if (pageFilters != null) {
                        $location.search('pageFilters', pageFilters);
                    } else if (filters != null) {
                        $location.search('filters', filters);
                    } else {
                        $location.search('filters', null);
                        $location.search('pageFilters', null);
                    }
                    handleUiRouterStateTransition(
                        $state.go($state.current,
                            {
                                dashboardId,
                                dashboardName,
                                pageId,
                                pageFilters,
                                filters
                            }, stateOptions)
                    );
                }
            }
        };
    });
})();
