(function(){
    'use strict';

    const app = angular.module('dataiku.dashboards.insights');

    app.directive('descriptionInsight', function(TileLoadingState){
        return {
            restrict: 'A',
            scope: {
                hook: '=',
                tile: '='
            },
            link: function($scope){

                if ($scope.tile.tileType !== 'INSIGHT' || $scope.tile.displayMode !== 'INSIGHT_DESC') {
                    return;
                }

                $scope.load = function(resolve) {
                    $scope.hook.loadStates[$scope.tile.$tileId] = TileLoadingState.COMPLETE;
                    resolve();
                };
                $scope.hook.loadPromises[$scope.tile.$tileId] = $scope.load;
                $scope.hook.reloadPromises[$scope.tile.$tileId] = $scope.load;
                $scope.hook.loadStates[$scope.tile.$tileId] = TileLoadingState.WAITING;
            }
        };
    });
})();
