(function(){
    'use strict';

    const app = angular.module('dataiku.dashboards.insights');

    app.directive('textTile', function(TileLoadingState){
        return {
            templateUrl: '/templates/dashboards/insights/text/text_tile.html',
            scope: {
                tileParams: '=',
                hook: '=',
                tile: '='
            },
            link: function($scope){

                $scope.load = function(resolve) {
                    $scope.hook.loadStates[$scope.tile.$tileId] = TileLoadingState.COMPLETE;
                    resolve();
                };
                $scope.hook.loadPromises[$scope.tile.$tileId] = $scope.load;
                $scope.hook.reloadPromises[$scope.tile.$tileId] = $scope.load;
                $scope.hook.loadStates[$scope.tile.$tileId] = TileLoadingState.WAITING;
            }
        };
    });

    app.directive('textTileParams', function(CodeMirrorSettingService){
        return {
            templateUrl: '/templates/dashboards/insights/text/text_tile_params.html',
            scope: {
                tileParams: '=',
                setHorizontalAlignment: '&',
                setVerticalAlignment: '&'
            },
            link: function($scope){
                $scope.editorOptions = CodeMirrorSettingService.get('text/plain');
            }
        };
    });
})();
