(function() {
    'use strict';

    angular.module('dataiku.savedmodels').factory('SavedModelHelperService', helperService);

    function helperService() {
        function suggestedVersionId(smStatus) {
            const versionCount = smStatus.versions.length;
            const biggerVersion = smStatus.versions.reduce((acc, el) => {
                const match = el.versionId.match(/\d+$/);
                if (match && parseInt(match[0]) > acc) {
                    acc = parseInt(match[0]);
                }
                return acc;
            }, 0);
    
            let result = 'v'
            if (biggerVersion > versionCount) {
                result += biggerVersion + 1;
            } else {
                result += versionCount + 1;
            }
    
            return result;
        }

        return { suggestedVersionId };
    }
})();
