(function() {
    'use strict';

    /**
     * List of available chart types used in the chart picker ordered by usage data from analytics
     */

    const app = angular.module('dataiku.charts');

    app.factory('ChartsAvailableTypes', function(CHART_TYPES, CHART_VARIANTS, PluginsService, translate) {

        const svc = {};

        const KEYWORDS = {
            ADMINISTRATIVE: translate('CHARTS.TYPE_PICKER.KEYWORD.ADMINISTRATIVE', 'administrative'),
            AGGREGATION: translate('CHARTS.TYPE_PICKER.KEYWORD.AGGREGATION','aggregation'),
            ASSOCIATIONS: translate('CHARTS.TYPE_PICKER.KEYWORD.ASSOCIATIONS', 'associations'),
            BARS: translate('CHARTS.TYPE_PICKER.KEYWORD.BARS', 'bars'),
            BINNED: translate('CHARTS.TYPE_PICKER.KEYWORD.BINNED', 'binned'),
            CHANGE: translate('CHARTS.TYPE_PICKER.KEYWORD.CHANGE', 'change'),
            COMPARISON: translate('CHARTS.TYPE_PICKER.KEYWORD.COMPARISON', 'comparison'),
            CURVES: translate('CHARTS.TYPE_PICKER.KEYWORD.CURVES', 'curves'),
            DISTRIBUTION: translate('CHARTS.TYPE_PICKER.KEYWORD.DISTRIBUTION', 'distribution'),
            DONUTS: translate('CHARTS.TYPE_PICKER.KEYWORD.DONUTS', 'donuts'),
            DOUGHNUT: translate('CHARTS.TYPE_PICKER.KEYWORD.DOUGHNUT', 'doughnut'),
            FLOW: translate('CHARTS.TYPE_PICKER.KEYWORD.FLOW', 'flow'),
            GEOGRAPHICAL: translate('CHARTS.TYPE_PICKER.KEYWORD.GEOGRAPHICAL', 'geographical'),
            GROUP: translate('CHARTS.TYPE_PICKER.KEYWORD.GROUP','group'),
            HIERARCHY: translate('CHARTS.TYPE_PICKER.KEYWORD.HIERARCHY','hierarchy'),
            HISTOGRAM: translate('CHARTS.TYPE_PICKER.KEYWORD.HISTOGRAM', 'histogram'),
            LEARNING: translate('CHARTS.TYPE_PICKER.KEYWORD.LEARNING', 'learning'),
            LINES: translate('CHARTS.TYPE_PICKER.KEYWORD.LINES', 'lines'),
            LOCATION: translate('CHARTS.TYPE_PICKER.KEYWORD.LOCATION', 'location'),
            MACHINE: translate('CHARTS.TYPE_PICKER.KEYWORD.MACHINE', 'machine'),
            MAGNITUDE: translate('CHARTS.TYPE_PICKER.KEYWORD.MAGNITUDE', 'magnitude'),
            MAPS: translate('CHARTS.TYPE_PICKER.KEYWORD.MAPS', 'maps'),
            METRIC: translate('CHARTS.TYPE_PICKER.KEYWORD.METRIC', 'metric'),
            MODELS: translate('CHARTS.TYPE_PICKER.KEYWORD.MODELS', 'models'),
            PART: translate('CHARTS.TYPE_PICKER.KEYWORD.PART', 'part'),
            PATTERNS: translate('CHARTS.TYPE_PICKER.KEYWORD.PATTERNS', 'patterns'),
            PERCENTAGE: translate('CHARTS.TYPE_PICKER.KEYWORD.PERCENTAGE', 'percentage'),
            PIES: translate('CHART.KEYWORDS.PIES', 'pies'),
            PROPORTION: translate('CHARTS.TYPE_PICKER.KEYWORD.PROPORTION', 'proportion'),
            RANGE: translate('CHARTS.TYPE_PICKER.KEYWORD.RANGE', 'range'),
            RELATIONSHIPS: translate('CHARTS.TYPE_PICKER.KEYWORD.RELATIONSHIPS', 'relationships'),
            SCATTERS: translate('CHARTS.TYPE_PICKER.KEYWORD.SCATTERS', 'scatters'),
            SPEEDOMETER: translate('CHARTS.TYPE_PICKER.KEYWORD.SPEEDOMETER', 'speedometer'),
            SPIDER: translate('CHARTS.TYPE_PICKER.KEYWORD.SPIDER', 'spider'),
            SUMMARY: translate('CHARTS.TYPE_PICKER.KEYWORD.SUMMARY','summary'),
            TABLES: translate('CHARTS.TYPE_PICKER.KEYWORD.TABLES','tables'),
            TIME: translate('CHARTS.TYPE_PICKER.KEYWORD.TIME', 'time'),
            WEB: translate('CHARTS.TYPE_PICKER.KEYWORD.WEB', 'web')
        };

        svc.getAvailableChartTypes = function() {
            // Keep in sync with dip/pivot/frontend/model/ChartDef.java::getChartDisplayName()
            return [
                {
                    id: 'qa_charts_histogram-chart-type',
                    type: CHART_TYPES.GROUPED_COLUMNS,
                    variant: CHART_VARIANTS.normal,
                    displayName: translate('CHARTS.TYPE_PICKER.NAME.VERTICAL_BARS', 'Vertical bars'),
                    keywords: [KEYWORDS.MAGNITUDE, KEYWORDS.COMPARISON, KEYWORDS.PATTERNS, KEYWORDS.PROPORTION, KEYWORDS.HISTOGRAM, KEYWORDS.BARS],
                    similar: ['qa_charts_stacked-chart-type', 'qa_charts_stacked-100-chart-type', 'qa_charts_bars-chart-type', 'qa_charts_bars-100-chart-type', 'qa_charts_pivot-chart-type', 'qa_charts_treemap-chart-type'],
                    tooltip: translate('CHARTS.TYPE_PICKER.TOOLTIP.VERTICAL_BARS', 'Compares values across grouped items or within a subgroup vertically')
                },
                {
                    id: 'qa_charts_stacked-chart-type',
                    type: CHART_TYPES.STACKED_COLUMNS,
                    variant: CHART_VARIANTS.normal,
                    displayName: translate('CHARTS.TYPE_PICKER.NAME.VERTICAL_STACKED_BARS', 'Vertical stacked bars'),
                    keywords: [KEYWORDS.MAGNITUDE, KEYWORDS.COMPARISON, KEYWORDS.PATTERNS, KEYWORDS.PROPORTION, KEYWORDS.BARS],
                    similar: ['qa_charts_histogram-chart-type', 'qa_charts_stacked-100-chart-type', 'qa_charts_bars-chart-type', 'qa_charts_bars-100-chart-type', 'qa_charts_pivot-chart-type', 'qa_charts_treemap-chart-type'],
                    tooltip: translate('CHARTS.TYPE_PICKER.TOOLTIP.VERTICAL_STACKED_BARS', 'Shows part-to-whole relationship within a group vertically')
                },
                {
                    id: 'qa_charts_stacked-100-chart-type',
                    type: CHART_TYPES.STACKED_COLUMNS,
                    variant: CHART_VARIANTS.stacked100,
                    displayName: translate('CHARTS.TYPE_PICKER.NAME.VERTICAL_STACKED_BARS_100', 'Vertical stacked bars 100%'),
                    keywords: [KEYWORDS.MAGNITUDE, KEYWORDS.COMPARISON, KEYWORDS.PATTERNS, KEYWORDS.PROPORTION, KEYWORDS.PERCENTAGE, KEYWORDS.BARS],
                    similar: ['qa_charts_histogram-chart-type', 'qa_charts_stacked-chart-type', 'qa_charts_bars-chart-type', 'qa_charts_bars-100-chart-type', 'qa_charts_pivot-chart-type', 'qa_charts_treemap-chart-type'],
                    tooltip: translate('CHARTS.TYPE_PICKER.TOOLTIP.VERTICAL_STACKED_BARS_100', 'Highlights the relative difference among values in each group - each bar is always 100%')
                },
                {
                    id: 'qa_charts_bars-chart-type',
                    type: CHART_TYPES.STACKED_BARS,
                    variant: CHART_VARIANTS.normal,
                    displayName: translate('CHARTS.TYPE_PICKER.NAME.HORIZONTAL_STACKED_BARS', 'Horizontal stacked bars'),
                    keywords: [KEYWORDS.MAGNITUDE, KEYWORDS.COMPARISON, KEYWORDS.PATTERNS, KEYWORDS.PROPORTION, KEYWORDS.BARS],
                    similar: ['qa_charts_histogram-chart-type', 'qa_charts_stacked-chart-type', 'qa_charts_stacked-100-chart-type', 'qa_charts_bars-100-chart-type', 'qa_charts_pivot-chart-type', 'qa_charts_treemap-chart-type'],
                    tooltip: translate('CHARTS.TYPE_PICKER.TOOLTIP.HORIZONTAL_STACKED_BARS', 'Compares values across grouped items or within a subgroup horizontally')
                },
                {
                    id: 'qa_charts_bars-100-chart-type',
                    type: CHART_TYPES.STACKED_BARS,
                    variant: CHART_VARIANTS.stacked100,
                    displayName: translate('CHARTS.TYPE_PICKER.NAME.HORIZONTAL_STACKED_BARS_100', 'Horizontal stacked bars 100%'),
                    keywords: [KEYWORDS.MAGNITUDE, KEYWORDS.COMPARISON, KEYWORDS.PATTERNS, KEYWORDS.PROPORTION, KEYWORDS.PERCENTAGE, KEYWORDS.BARS],
                    similar: ['qa_charts_histogram-chart-type', 'qa_charts_stacked-chart-type', 'qa_charts_stacked-100-chart-type', 'qa_charts_bars-chart-type', 'qa_charts_pivot-chart-type', 'qa_charts_treemap-chart-type'],
                    tooltip: translate('CHARTS.TYPE_PICKER.TOOLTIP.HORIZONTAL_STACKED_BARS_100', 'Highlights the relative difference among values in each group - each bar is always 100%')
                },
                {
                    id: 'qa_charts_lines-chart-type',
                    type: CHART_TYPES.LINES,
                    variant: CHART_VARIANTS.normal,
                    displayName: translate('CHARTS.TYPE_PICKER.NAME.LINES', 'Lines'),
                    keywords: [KEYWORDS.CHANGE, KEYWORDS.TIME, KEYWORDS.PATTERNS, KEYWORDS.LINES, KEYWORDS.CURVES],
                    similar: ['qa_charts_mix-chart-type', 'qa_charts_stacked-area-chart-type', 'qa_charts_stacked-area-100-chart-type'],
                    tooltip: translate('CHARTS.TYPE_PICKER.TOOLTIP.LINES', 'Display quantitative values over a continuous interval or time period')
                },
                {
                    id: 'qa_charts_stacked-area-chart-type',
                    type: CHART_TYPES.STACKED_AREA,
                    variant: CHART_VARIANTS.normal,
                    displayName: translate('CHARTS.TYPE_PICKER.NAME.STACKED_AREAS', 'Stacked areas'),
                    keywords: [KEYWORDS.CHANGE, KEYWORDS.TIME, KEYWORDS.PATTERNS, KEYWORDS.MAGNITUDE, KEYWORDS.COMPARISON, KEYWORDS.PROPORTION, KEYWORDS.PERCENTAGE, KEYWORDS.LINES, KEYWORDS.CURVES],
                    similar: ['qa_charts_stacked-area-100-chart-type', 'qa_charts_lines-chart-type', 'qa_charts_mix-chart-type'],
                    tooltip: translate('CHARTS.TYPE_PICKER.TOOLTIP.STACKED_AREAS', 'Shows how values evolve over a continuous interval or time period')
                },
                {
                    id: 'qa_charts_stacked-area-100-chart-type',
                    type: CHART_TYPES.STACKED_AREA,
                    variant: CHART_VARIANTS.stacked100,
                    displayName: translate('CHARTS.TYPE_PICKER.NAME.STACKED_AREAS_100', 'Stacked areas 100%'),
                    keywords: [KEYWORDS.CHANGE, KEYWORDS.TIME, KEYWORDS.PATTERNS, KEYWORDS.MAGNITUDE, KEYWORDS.COMPARISON, KEYWORDS.PROPORTION, KEYWORDS.PERCENTAGE, KEYWORDS.LINES, KEYWORDS.CURVES],
                    similar: ['qa_charts_stacked-area-chart-type', 'qa_charts_lines-chart-type', 'qa_charts_mix-chart-type'],
                    tooltip: translate('CHARTS.TYPE_PICKER.TOOLTIP.STACKED_AREAS_100', 'Highlights the relative difference among values evolving over a continuous time period')
                },
                {
                    id: 'qa_charts_pie-chart-type',
                    type: CHART_TYPES.PIE,
                    variant: CHART_VARIANTS.normal,
                    displayName: translate('CHARTS.TYPE_PICKER.NAME.PIE', 'Pie'),
                    keywords: [KEYWORDS.PART, KEYWORDS.PROPORTION, KEYWORDS.PIES, KEYWORDS.DONUTS],
                    similar: ['qa_charts_donut-chart-type'],
                    tooltip: translate('CHARTS.TYPE_PICKER.TOOLTIP.PIE', 'Shows a quick part-to-whole comparison')
                },
                {
                    id: 'qa_charts_donut-chart-type',
                    type: CHART_TYPES.PIE,
                    variant: CHART_VARIANTS.donut,
                    displayName: translate('CHARTS.TYPE_PICKER.NAME.DONUT', 'Donut'),
                    keywords: [KEYWORDS.PART, KEYWORDS.PROPORTION, KEYWORDS.PIES, KEYWORDS.DONUTS, KEYWORDS.DOUGHNUT],
                    similar: ['qa_charts_pie-chart-type'],
                    tooltip: translate('CHARTS.TYPE_PICKER.TOOLTIP.DONUT', 'Shows a quick part-to-whole comparison with a hole inside')
                },
                {
                    id: 'qa_charts_mix-chart-type',
                    type: CHART_TYPES.MULTI_COLUMNS_LINES,
                    variant: CHART_VARIANTS.normal,
                    displayName: translate('CHARTS.TYPE_PICKER.NAME.MIX', 'Mix'),
                    keywords: [KEYWORDS.CHANGE, KEYWORDS.TIME, KEYWORDS.MAGNITUDE, KEYWORDS.COMPARISON, KEYWORDS.PATTERNS, KEYWORDS.PROPORTION, KEYWORDS.PERCENTAGE, KEYWORDS.BARS, KEYWORDS.LINES, KEYWORDS.CURVES],
                    similar: ['qa_charts_lines-chart-type', 'qa_charts_stacked-area-chart-type', 'qa_charts_stacked-area-100-chart-type'],
                    tooltip: translate('CHARTS.TYPE_PICKER.TOOLTIP.MIX', 'Shows a direct comparison between two sets of values with separate axes')
                },
                {
                    id: 'qa_charts_pivot-chart-type',
                    type: CHART_TYPES.PIVOT_TABLE,
                    variant: CHART_VARIANTS.normal,
                    displayName: translate('CHARTS.TYPE_PICKER.NAME.PIVOT_TABLE', 'Pivot table'),
                    keywords: [KEYWORDS.SUMMARY, KEYWORDS.GROUP, KEYWORDS.AGGREGATION, KEYWORDS.HIERARCHY, KEYWORDS.TABLES],
                    similar: ['qa_charts_histogram-chart-type', 'qa_charts_stacked-chart-type', 'qa_charts_stacked-100-chart-type', 'qa_charts_bars-chart-type', 'qa_charts_bars-100-chart-type', 'qa_charts_treemap-chart-type'],
                    tooltip: translate('CHARTS.TYPE_PICKER.TOOLTIP.PIVOT_TABLE', 'Displays aggregated values in a table grouped across several dimensions')
                },
                {
                    id: 'qa_charts_kpi-chart-type',
                    type: CHART_TYPES.KPI,
                    variant: CHART_VARIANTS.normal,
                    displayName: translate('CHARTS.TYPE_PICKER.NAME.KPI', 'KPIs'),
                    keywords: [KEYWORDS.METRIC],
                    similar: ['qa_charts_gauge-chart-type'],
                    tooltip: translate('CHARTS.TYPE_PICKER.TOOLTIP.KPI', 'Displays a simple value visualization for single or multiple aggregations')
                },
                {
                    id: 'qa_charts_radar-chart-type',
                    type: CHART_TYPES.RADAR,
                    variant: CHART_VARIANTS.normal,
                    displayName: translate('CHARTS.TYPE_PICKER.NAME.RADAR', 'Radar'),
                    keywords: [KEYWORDS.WEB, KEYWORDS.SPIDER],
                    tooltip: translate('CHARTS.TYPE_PICKER.TOOLTIP.RADAR', 'Displays data in a radial axis, where the radii represents the performance of values')
                },
                {
                    id: 'qa_charts_gauge-chart-type',
                    type: CHART_TYPES.GAUGE,
                    variant: CHART_VARIANTS.normal,
                    displayName: translate('CHARTS.TYPE_PICKER.NAME.GAUGE', 'Gauge'),
                    keywords: [KEYWORDS.SPEEDOMETER],
                    similar: ['qa_charts_kpi-chart-type'],
                    tooltip: translate('CHARTS.TYPE_PICKER.TOOLTIP.GAUGE', 'Displays how a value performs in a semi-circular scale')
                },
                {
                    id: 'qa_charts_sankey-chart-type',
                    type: CHART_TYPES.SANKEY,
                    variant: CHART_VARIANTS.normal,
                    displayName: translate('CHARTS.TYPE_PICKER.NAME.SANKEY', 'Sankey'),
                    keywords: [KEYWORDS.FLOW],
                    tooltip: translate('CHARTS.TYPE_PICKER.TOOLTIP.SANKEY', 'Displays a weighted flow of resources')
                },
                {
                    id: 'qa_charts_treemap-chart-type',
                    type: CHART_TYPES.TREEMAP,
                    variant: CHART_VARIANTS.normal,
                    displayName: translate('CHARTS.TYPE_PICKER.NAME.TREEMAP', 'Treemap'),
                    keywords: [KEYWORDS.HIERARCHY, KEYWORDS.COMPARISON, KEYWORDS.PROPORTION, KEYWORDS.PART],
                    similar: ['qa_charts_pivot-chart-type', 'qa_charts_histogram-chart-type', 'qa_charts_stacked-chart-type', 'qa_charts_stacked-100-chart-type', 'qa_charts_bars-chart-type', 'qa_charts_bars-100-chart-type'],
                    tooltip: translate('CHARTS.TYPE_PICKER.TOOLTIP.TREEMAP', 'Displays hierarchical data as nested rectangles with proportional sizes')
                },
                {
                    id: 'qa_charts_scatter-plot-chart-type',
                    type: CHART_TYPES.SCATTER,
                    variant: CHART_VARIANTS.normal,
                    displayName: translate('CHARTS.TYPE_PICKER.NAME.SCATTER_PLOT', 'Scatter plot'),
                    keywords: [KEYWORDS.ASSOCIATIONS, KEYWORDS.PATTERNS, KEYWORDS.RELATIONSHIPS, KEYWORDS.SCATTERS],
                    similar: ['qa_charts_scatter-plot-multiple-pairs-chart-type', 'qa_charts_bubble-chart-type', 'qa_charts_rectangle-chart-type', 'qa_charts_hexagon-chart-type', 'qa_charts_grouped-bubbles-chart-type'],
                    tooltip: translate('CHARTS.TYPE_PICKER.TOOLTIP.SCATTER_PLOT', 'Shows the relationships between numerical variables drawn on the axes')
                },
                {
                    id: 'qa_charts_scatter-plot-multiple-pairs-chart-type',
                    type: CHART_TYPES.SCATTER_MULTIPLE_PAIRS,
                    variant: CHART_VARIANTS.normal,
                    displayName: translate('CHARTS.TYPE_PICKER.NAME.SCATTER_MULTI_PAIR', 'Scatter multi-pair'),
                    keywords: [KEYWORDS.ASSOCIATIONS, KEYWORDS.PATTERNS, KEYWORDS.RELATIONSHIPS, KEYWORDS.SCATTERS],
                    similar: ['qa_charts_scatter-plot-chart-type', 'qa_charts_bubble-chart-type', 'qa_charts_rectangle-chart-type', 'qa_charts_hexagon-chart-type', 'qa_charts_grouped-bubbles-chart-type'],
                    tooltip: translate('CHARTS.TYPE_PICKER.TOOLTIP.SCATTER_MULTI_PAIR', 'Shows the relationships between numerical variables drawn on the axes (with multiple pairs)')
                },
                {
                    id: 'qa_charts_geo-map-chart-type',
                    type: CHART_TYPES.GEOMETRY_MAP,
                    variant: CHART_VARIANTS.normal,
                    displayName: translate('CHARTS.TYPE_PICKER.NAME.GEOMETRY_MAP', 'Geometry map'),
                    keywords: [KEYWORDS.GEOGRAPHICAL, KEYWORDS.LOCATION, KEYWORDS.SCATTERS, KEYWORDS.MAPS],
                    similar: ['qa_charts_scatter-map-chart-type', 'qa_charts_bubble-map-chart-type', 'qa_charts_filled-map-chart-type', 'qa_charts_grid-map-chart-type', 'qa_charts_density-map-chart-type'],
                    tooltip: translate('CHARTS.TYPE_PICKER.TOOLTIP.GEOMETRY_MAP', 'Shows geometries as areas on a map')
                },
                {
                    id: 'qa_charts_grid-map-chart-type',
                    type: CHART_TYPES.GRID_MAP,
                    variant: CHART_VARIANTS.normal,
                    displayName: translate('CHARTS.TYPE_PICKER.NAME.GRID_MAP', 'Grid map'),
                    keywords: [KEYWORDS.GEOGRAPHICAL, KEYWORDS.LOCATION, KEYWORDS.BINNED, KEYWORDS.MAPS],
                    similar: ['qa_charts_scatter-map-chart-type', 'qa_charts_bubble-map-chart-type', 'qa_charts_filled-map-chart-type', 'qa_charts_geo-map-chart-type', 'qa_charts_density-map-chart-type'],
                    tooltip: translate('CHARTS.TYPE_PICKER.TOOLTIP.GRID_MAP', 'Shows geographical data at administrative level on a map as a grid')
                },
                {
                    id: 'qa_charts_scatter-map-chart-type',
                    type: CHART_TYPES.SCATTER_MAP,
                    variant: CHART_VARIANTS.normal,
                    displayName: translate('CHARTS.TYPE_PICKER.NAME.SCATTER_MAP', 'Scatter map'),
                    keywords: [KEYWORDS.GEOGRAPHICAL, KEYWORDS.LOCATION, KEYWORDS.SCATTERS, KEYWORDS.MAPS],
                    similar: ['qa_charts_bubble-map-chart-type', 'qa_charts_filled-map-chart-type', 'qa_charts_geo-map-chart-type', 'qa_charts_grid-map-chart-type', 'qa_charts_density-map-chart-type'],
                    tooltip: translate('CHARTS.TYPE_PICKER.TOOLTIP.SCATTER_MAP', 'Shows geographical data as points on a map')
                },
                {
                    id: 'qa_charts_filled-map-chart-type',
                    type: CHART_TYPES.ADMINISTRATIVE_MAP,
                    variant: CHART_VARIANTS.filledMap,
                    displayName: translate('CHARTS.TYPE_PICKER.NAME.ADMINISTRATIVE_MAP_FILLED', 'Administrative map (filled)'),
                    keywords: [KEYWORDS.GEOGRAPHICAL, KEYWORDS.LOCATION, KEYWORDS.ADMINISTRATIVE, KEYWORDS.MAPS],
                    similar: ['qa_charts_scatter-map-chart-type', 'qa_charts_bubble-map-chart-type', 'qa_charts_geo-map-chart-type', 'qa_charts_grid-map-chart-type', 'qa_charts_density-map-chart-type'],
                    tooltip: translate('CHARTS.TYPE_PICKER.TOOLTIP.ADMINISTRATIVE_MAP_FILLED', 'Draws the boundary of geographic data at administrative level as a filled shaped)'),
                    requiredPluginId: 'geoadmin',
                    isRequiredPluginInstalled: PluginsService.isPluginLoaded('geoadmin')
                },
                {
                    id: 'qa_charts_bubble-map-chart-type',
                    type: CHART_TYPES.ADMINISTRATIVE_MAP,
                    variant: CHART_VARIANTS.normal,
                    displayName: translate('CHARTS.TYPE_PICKER.NAME.ADMINISTRATIVE_MAP_BUBBLES', 'Administrative map (bubbles)'),
                    keywords: [KEYWORDS.GEOGRAPHICAL, KEYWORDS.LOCATION, KEYWORDS.ADMINISTRATIVE, KEYWORDS.MAPS],
                    similar: ['qa_charts_scatter-map-chart-type', 'qa_charts_filled-map-chart-type', 'qa_charts_geo-map-chart-type', 'qa_charts_grid-map-chart-type', 'qa_charts_density-map-chart-type'],
                    tooltip: translate('CHARTS.TYPE_PICKER.TOOLTIP.ADMINISTRATIVE_MAP_BUBBLES', 'Shows geographical data at administrative level on the map as a circle'),
                    requiredPluginId: 'geoadmin',
                    isRequiredPluginInstalled: PluginsService.isPluginLoaded('geoadmin')
                },
                {
                    id: 'qa_charts_density-map-chart-type',
                    type: CHART_TYPES.DENSITY_HEAT_MAP,
                    variant: CHART_VARIANTS.normal,
                    displayName: translate('CHARTS.TYPE_PICKER.NAME.DENSITY_MAP', 'Density map'),
                    keywords: [KEYWORDS.GEOGRAPHICAL, KEYWORDS.LOCATION, KEYWORDS.SCATTERS, KEYWORDS.MAPS],
                    similar: ['qa_charts_scatter-map-chart-type', 'qa_charts_bubble-map-chart-type', 'qa_charts_filled-map-chart-type', 'qa_charts_geo-map-chart-type', 'qa_charts_grid-map-chart-type'],
                    tooltip: translate('CHARTS.TYPE_PICKER.TOOLTIP.DENSITY_MAP', 'Shows where points are concentrated on a map by their spatial proximity')
                },
                {
                    id: 'qa_charts_grouped-bubbles-chart-type',
                    type: CHART_TYPES.GROUPED_XY,
                    variant: CHART_VARIANTS.normal,
                    displayName: translate('CHARTS.TYPE_PICKER.NAME.GROUPED_BUBBLES', 'Grouped bubbles'),
                    keywords: [KEYWORDS.ASSOCIATIONS, KEYWORDS.PATTERNS, KEYWORDS.RELATIONSHIPS, KEYWORDS.SCATTERS],
                    similar: ['qa_charts_scatter-plot-chart-type', 'qa_charts_scatter-plot-multiple-pairs-chart-type', 'qa_charts_bubble-chart-type', 'qa_charts_rectangle-chart-type', 'qa_charts_hexagon-chart-type'],
                    tooltip: translate('CHARTS.TYPE_PICKER.TOOLTIP.GROUPED_BUBBLES', 'Shows where points are concentrated on a map by their spatial proximity')
                },
                {
                    id: 'qa_charts_bubble-chart-type',
                    type: CHART_TYPES.BINNED_XY,
                    variant: CHART_VARIANTS.normal,
                    displayName: translate('CHARTS.TYPE_PICKER.NAME.BINNED_BUBBLES', 'Binned bubbles'),
                    keywords: [KEYWORDS.ASSOCIATIONS, KEYWORDS.PATTERNS, KEYWORDS.RELATIONSHIPS, KEYWORDS.SCATTERS, KEYWORDS.BINNED],
                    similar: ['qa_charts_scatter-plot-chart-type', 'qa_charts_scatter-plot-multiple-pairs-chart-type', 'qa_charts_rectangle-chart-type', 'qa_charts_hexagon-chart-type', 'qa_charts_grouped-bubbles-chart-type'],
                    tooltip: translate('CHARTS.TYPE_PICKER.TOOLTIP.BINNED_BUBBLES', 'Shows the relationships between categorical or binned numerical variables on the axes')
                },
                {
                    id: 'qa_charts_hexagon-chart-type',
                    type: CHART_TYPES.BINNED_XY,
                    variant: CHART_VARIANTS.binnedXYHexagon,
                    displayName: translate('CHARTS.TYPE_PICKER.NAME.BINNED_HEXAGONS', 'Binned hexagons'),
                    keywords: [KEYWORDS.ASSOCIATIONS, KEYWORDS.PATTERNS, KEYWORDS.RELATIONSHIPS, KEYWORDS.SCATTERS, KEYWORDS.BINNED],
                    similar: ['qa_charts_scatter-plot-chart-type', 'qa_charts_scatter-plot-multiple-pairs-chart-type', 'qa_charts_bubble-chart-type', 'qa_charts_rectangle-chart-type', 'qa_charts_grouped-bubbles-chart-type'],
                    tooltip: translate('CHARTS.TYPE_PICKER.TOOLTIP.BINNED_HEXAGONS', 'Shows a regular array of hexagons to show density for large datasets')
                },
                {
                    id: 'qa_charts_rectangle-chart-type',
                    type: CHART_TYPES.BINNED_XY,
                    variant: CHART_VARIANTS.binnedXYRectangle,
                    displayName: translate('CHARTS.TYPE_PICKER.NAME.BINNED_RECTANGLES', 'Binned rectangles'),
                    keywords: [KEYWORDS.ASSOCIATIONS, KEYWORDS.PATTERNS, KEYWORDS.RELATIONSHIPS, KEYWORDS.SCATTERS, KEYWORDS.BINNED],
                    similar: ['qa_charts_scatter-plot-chart-type', 'qa_charts_scatter-plot-multiple-pairs-chart-type', 'qa_charts_bubble-chart-type', 'qa_charts_hexagon-chart-type', 'qa_charts_grouped-bubbles-chart-type'],
                    tooltip: translate('CHARTS.TYPE_PICKER.TOOLTIP.BINNED_RECTANGLES', 'Shows the relationships between categorical or binned numerical variables')
                },
                {
                    id: 'qa_charts_boxplot-chart-type',
                    type: CHART_TYPES.BOXPLOTS,
                    variant: CHART_VARIANTS.normal,
                    keywords: [KEYWORDS.DISTRIBUTION, KEYWORDS.RANGE],
                    displayName: translate('CHARTS.TYPE_PICKER.NAME.BOXPLOT', 'Boxplot'),
                    tooltip: translate('CHARTS.TYPE_PICKER.TOOLTIP.BOXPLOT', 'Displays the distribution of data showing minimum, Q1, median, Q3 and maximum')
                },
                {
                    id: 'qa_charts_density-2d-chart-type',
                    type: CHART_TYPES.DENSITY_2D,
                    variant: CHART_VARIANTS.normal,
                    keywords: [KEYWORDS.DISTRIBUTION],
                    displayName: translate('CHARTS.TYPE_PICKER.NAME.2D_DISTRIBUTION', '2D distribution'),
                    tooltip: translate('CHARTS.TYPE_PICKER.TOOLTIP.2D_DISTRIBUTION', 'Shows the bivariate distribution of two fields')
                },
                {
                    id: 'qa_charts_lift-chart-type',
                    type: CHART_TYPES.LIFT,
                    variant: CHART_VARIANTS.normal,
                    displayName: translate('CHARTS.TYPE_PICKER.NAME.LIFT', 'Lift chart'),
                    keywords: [KEYWORDS.MACHINE, KEYWORDS.LEARNING, KEYWORDS.MODELS],
                    tooltip: translate('CHARTS.TYPE_PICKER.TOOLTIP.LIFT', 'Measures the effectiveness of models between results with and without a model')
                }
            ];
        };

        return svc;
    });
})();
