(function() {
    "use strict";

    const opalsHeadlessContainer = {
        templateUrl: "/static/dataiku/opals/opals-headless-container/opals-headless-container.component.html",
        controller: function opalsHeadlessContainerController($scope, $element, OpalsService, OpalsMessageService, WT1) {

            this.headlessUrl = "";
            this.frameId = "headless-frame";

            this.$onInit = function() {
                OpalsService.isHeadlessAvailable().then((isAvailable) => {
                    if (isAvailable) {  
                        const unregister = $scope.$watch(
                            () => $element.find(`#${this.frameId}`),
                            (newVal) => {
                                if (newVal.length > 0) {
                                    this.iframe = newVal[0];
                                    OpalsService.setHeadlessFrame(newVal[0]);
                                    unregister();
                                }
                            }
                        );
                    } else {
                        OpalsService.getHeadlessUrl().then((url) => {
                            WT1.event("opals-headless-load-error", { opalsUrl: url.toString() });
                        });
                    }
                });
                OpalsService.getHeadlessUrl().then((url) => {
                    this.headlessUrl = url;
                });
            };
            this.onMessage = OpalsMessageService.handleMessageEvent;
        },
    };

    angular.module("dataiku.opals").component("opalsHeadlessContainer", opalsHeadlessContainer);
})();
