(function () {
    "use strict";

    const ifThen = {
        bindings : {
            ifThen: '=',
            filterHeader: '<',
            schema: '<',
            shaker: '<',
            step: '<',
            inputDatasetProjectKey: '<',
            inputDatasetName: '<',
            requestedSampleId: '<',
            recipeOutputSchema: '<',
            isRecipe: '<'
        },
        templateUrl: "/static/dataiku/processors/visual-if/if-then/if-then.component.html",
        controller: function ifThenController($scope, $element, $attrs) {
            const ctrl = this;
            ctrl.$onInit = function () {
                let defaults = {
                    ifThen: {},
                    filterHeader: "If",
                    schema: {},
                    shaker: {},
                    step: {},
                    inputDatasetProjectKey: "",
                    inputDatasetName: "",
                    requestedSampleId: "",
                    recipeOutputSchema: "",
                    isRecipe: true
                };
                $.each(defaults, function(param, value) {
                    if (param in ctrl) {
                        $scope[param] = ctrl[param] || value;
                    } else {
                        $scope[param] = value;
                    }
                });
                $scope.fromPrepare = true;
            }
        }
    };
    angular.module("dataiku.processors").component("ifThen", ifThen);
})();