(function () {
    "use strict";

    const thenEditor = {
        require: {
            visualIfEditor: '^visualIfEditor'
        },
        bindings : {
            fromIfThen: '<',
            schema: '<',
            actions: '=',
            shaker: '<',
            step: '<',
            inputDatasetProjectKey: '<',
            inputDatasetName: '<',
            requestedSampleId: '<',
            recipeOutputSchema: '<',
            isRecipe: '<'
        },
        templateUrl: "/static/dataiku/processors/visual-if/then-editor/then-editor.component.html",
        controller: function thenEditorController($scope, $element, $attrs, $stateParams, DataikuAPI, Logger) {
            const ctrl = this;
            ctrl.$onInit = function () {

                $scope.getColumns = function() {
                    return $scope.schema.columns;
                }
                $scope.thenEditorId = $scope.$id;
                $scope.setFocusById = function(elementId) {
                    var element = document.getElementById(elementId);
                    if (element) { element.focus();}
                }

                $scope.formulaHandlers = [];

                $scope.addFormulaHandler = function (action, index, forceRefresh = false) {
                    //Add formula handler for action indexcode/state unless they are there already

                    //Always refresh things on init as once the scope is destroyed this stuff won't work any more (esp the expressionValidator)
                    if ($scope.formulaHandlers[index] && $scope.formulaHandlers[index].action == action && !forceRefresh) {
                        return;
                    }

                    // if we replace an existing formulaHandler, destroy the previous one
                    $scope.formulaHandlers[index]?.destroy();

                    //create new formula handler - replace any existing one in case it is pointing at the wrong action
                    let formulaHandler = {};
                    formulaHandler.action = action;
                    let indexInt = parseInt(index);
                    if (indexInt < $scope.formulaHandlers.length) {
                        $scope.formulaHandlers[index] = formulaHandler;
                    } else if (indexInt === $scope.formulaHandlers.length) {                                                  
                        $scope.formulaHandlers.push(formulaHandler);
                    } else {
                        //as the code is currently written the new index can't be higher than the length
                        Logger.warn("Attempted to add a formulaHandler with an unexpected index");
                        return;
                    }
                    
                    
                    const validateExpressionMonoFuture = ctrl.visualIfEditor.validateExpressionMonoFuturePool.createMonoFuture($scope, false);
                    const validateExpressionApiCallWrapper = validateExpressionMonoFuture.wrap(DataikuAPI.shakers.validateExpression);

                    let initialFormulaStatus = {
                        changeInProgress: false,
                        grelExpressionValid: false,
                        grelExpressionError: false,
                        grelExpressionData: "",
                        grelExpressionEmpty: $scope.formulaHandlers[index].action.formula && $scope.formulaHandlers[index].action.formula.trim().length == 0,
                        ableToValidate: true
                    };

                    formulaHandler.formulaStatus = initialFormulaStatus;

                    formulaHandler.onValidate = (result) => {
                        formulaHandler.formulaStatus.changeInProgress = validateExpressionMonoFuture.active();
                        formulaHandler.formulaStatus.grelExpressionValid = result.valid;
                        formulaHandler.formulaStatus.grelExpressionError = result.error;
                        formulaHandler.formulaStatus.grelExpressionData = result.data;
                        formulaHandler.formulaStatus.grelExpressionEmpty = result.inputExpr && result.inputExpr.trim().length == 0;
                    }

                    formulaHandler.onError = (data, status, headers) => {
                        formulaHandler.formulaStatus.changeInProgress = validateExpressionMonoFuture.active();
                        formulaHandler.formulaStatus.ableToValidate = false;
                    }

                    formulaHandler.onExpressionChange = () => {
                        formulaHandler.formulaStatus.changeInProgress = true;
                    };
                    
                    formulaHandler.expressionValidator = (expression) => {
                        const stepPosition = $scope.findStepId($scope.step);
                        formulaHandler.formulaStatus.changeInProgress = true;
                        return validateExpressionApiCallWrapper(
                            $stateParams.projectKey,
                            $scope.inputDatasetProjectKey,
                            $scope.inputDatasetName,
                            $scope.shakerForQuery(),
                            $scope.requestedSampleId,
                            expression,
                            stepPosition.id,
                            stepPosition.subId || 0,
                            stepPosition.depth,
                            false
                        );
                                            };

                    formulaHandler.destroy = () => {
                        validateExpressionMonoFuture.destroy();
                    }
                }

                $scope.addAction = function () {
                    let action = {
                        outputColumnName: "",
                        operator: "ASSIGN_VALUE",
                        value: "",
                        column: $scope.getColumns()[0].name,
                        formula: ""
                    };                
                    $scope.actions.push(action);
                    $scope.addFormulaHandler(action, $scope.actions.length-1);
                    setTimeout(function () { $scope.setFocusById($scope.thenEditorId + '-action-' + String($scope.actions.length - 1)) }, 0);
                }

                $scope.remove = function (index) {
                    $scope.actions.splice(index, 1);
                    $scope.formulaHandlers.splice(index, 1).forEach((handler) => handler.destroy())
                }

                $scope.canRemove = function () {
                    return ($scope.actions.length > 1 && $scope.fromIfThen) || !$scope.fromIfThen;
                }

                $scope.onInit = function() {
                    let defaults = {
                        actions: [],
                        fromIfThen: false,
                        schema: {},
                        shaker: {},
                        step: {},
                        inputDatasetProjectKey: "",
                        inputDatasetName: "",
                        requestedSampleId: "",
                        recipeOutputSchema: {},
                        isRecipe: true
                    };
                    $.each(defaults, function(param, value) {
                        if (param in ctrl) {
                            $scope[param] = ctrl[param] || value;
                        } else {
                            $scope[param] = value;
                        }
                    });
                    $scope.actionOperators = [{ "name": "ASSIGN_VALUE", "label": "=(Value)" }, { "name": "ASSIGN_COLUMN", "label": "=(Column)" }, { "name": "ASSIGN_FORMULA", "label": "=(Formula)" }]

                    for (let i in $scope.actions) {
                        $scope.addFormulaHandler($scope.actions[i], i, true);
                    }

                    if ($scope.actions.length === 0 && $scope.fromIfThen) {
                        $scope.addAction();
                    }

                    $scope.columns = $scope.getColumns();
                }


                $scope.findStepId = function(inputStep) {
                    var steps = $scope.shaker.steps;
                    var returnStep;
                    steps.forEach((step, i) => {
                        if (step === inputStep) {
                            returnStep = {'id':i, 'subId':undefined, 'depth':0};
                        }
                        if (step.metaType === "GROUP") {
                            step.steps.forEach((subStep, j) => {
                                if (inputStep === subStep) {
                                    returnStep = {'id':i, 'subId':j, 'depth':1};
                                }
                            });
                        }
                    });
                    return returnStep;
                }

                $scope.shakerForQuery = function(){
                    var queryObj = angular.copy($scope.shaker);
                    if ($scope.isRecipe) {
                        if ($scope.recipeOutputSchema.columns) {
                            queryObj.recipeSchema = $scope.recipeOutputSchema;
                        }
                    }
                    queryObj.contextProjectKey = $stateParams.projectKey;
                    return queryObj;
                }

                $scope.onInit();

                $scope.$watchCollection(() => this.actions, function (nv, ov) {
                    //Note - removals are handled by the remove method - this code is called after that
                    if (nv && nv !== ov) {
                        $scope.actions = nv;
                        for (let i in nv) {
                            $scope.addFormulaHandler($scope.actions[i], i);
                        }

                        // Some actions may reduce the length of action (for example if you remove a else-if block, it's replaced by the next that may be shorter)
                        // In this case, the formulaHandler are updated by the loop just above if the action changed, and the validation monofuture destroyed if adequate.
                        // however, the formulaHandler with indexes >= actions.length are still there, and their validation monofuture might still be waiting for their future to complete, or even to start - which is useless now.
                        // this takes care of cleaning up those now useless handlers.
                        $scope.formulaHandlers.splice($scope.actions.length, Infinity).forEach(handler => handler.destroy());
                    }
                });
            }
        }
    };
    angular.module("dataiku.processors").component("thenEditor", thenEditor);
})();
