(function () {
    "use strict";

    const visualIfEditor = {
        bindings : {
            visualIfDesc: '=',
            inputDatasetName: '<',
            shaker: '<',
            step: '<',
            inputDatasetProjectKey: '<',
            requestedSampleId: '<',
            recipeOutputSchema: '<',
            isRecipe: '<'
        },
        templateUrl: "/static/dataiku/processors/visual-if/visual-if-editor/visual-if-editor.component.html",
        controller: function visualIfEditorController($scope, $element, $attrs, $rootScope, $stateParams, DataikuAPI, ShakerService, MonoFuturePool) {
            const ctrl = this;

            // A formula validation future pool that will be shared among all formula-aware component in this editor
            ctrl.validateExpressionMonoFuturePool = MonoFuturePool($scope);

            ctrl.$onInit = function () {
                let defaults = {
                    visualIfDesc: {},
                    inputDatasetName: "",
                    shaker: {},
                    step: {},
                    inputDatasetProjectKey: "",
                    requestedSampleId: "",
                    recipeOutputSchema: "",
                    isRecipe: true
                };
                $.each(defaults, function(param, value) {
                    if (param in ctrl) {
                        $scope[param] = ctrl[param] || value;
                    } else {
                        $scope[param] = value;
                    }
                });
        
                $scope.currentStepSchema = {"columns": []};
                // If the columns are available not in the $stepState, we get the last known input columns from columnsCache.
                $scope.columns =
                    $scope.step.$stepState.change ? $scope.step.$stepState.change.columnsBeforeStep :
                    $scope.step.columnsCache && $scope.step.columnsCache.length>0 ? $scope.step.columnsCache :
                    $scope.recipeOutputSchema.columnsOrder;

                // Since we are in the prepare recipe, we cant know input columns type.
                // We still infer likely type based on outputSchema, if possible, and use this to suggest the most likely operators.
                $scope.updateColumns = function() {
                    if ("recipeOutputSchema" in $scope && $scope.recipeOutputSchema!=="" && "columns" in $scope.recipeOutputSchema){
                        $scope.columns.forEach(col => {
                            $scope.currentStepSchema.columns.push(
                            {
                                "name": col,
                                "type": col in $scope.recipeOutputSchema.columns ? $scope.recipeOutputSchema.columns[col].column.type : "string"
                            })
                        });
                    } else {
                        $scope.columns.forEach(col => {
                            $scope.currentStepSchema.columns.push(
                            {
                                "name": col,
                                "type": "string"
                            })
                        });
                    }
                };
                $scope.updateColumns();
        
                // Init border colors
                $scope.visualIfDesc.elseIfThens.map((element, id) => element.colorId = (id+1)%5);
        
                // We Observe resizing actions on the editor panel to resize the dataset array when it happens
                // In order to avoid broadcasting too many events, we wait 100ms after the last resize event to broadcast
                var timeOut;
                const observer = new ResizeObserver(mutations => {
                    clearTimeout(timeOut);
                    timeOut = setTimeout(() => {$rootScope.$broadcast("visualIfResize_")}, 100);
                });
                const visualIfFormulaEditor = document.querySelector(".visual-if-rule--resizable-editor");
                observer.observe(visualIfFormulaEditor);
            }
            
            $scope.addElseIf = function(index) {
                let colors = [0, 1, 2, 3, 4];
                let colorId;
                let newCondition;
                let conditionInput;
            
                if (index === -1) {
                    conditionInput = $scope.visualIfDesc.ifThen.filter.uiData.conditions[0].input;
                    newCondition = { num: 0, input: conditionInput };
            
                    if ($scope.visualIfDesc.elseIfThens.length === 0) {
                        colorId = 1;
                    } else {
                        let excludedColors = [0, $scope.visualIfDesc.elseIfThens[0].colorId];
                        let availableColors = colors.filter(color => !excludedColors.includes(color));
                        colorId = _.sample(availableColors);
                    }
                } else {
                    conditionInput = $scope.visualIfDesc.elseIfThens[index].filter.uiData.conditions[0].input;
                    newCondition = { num: 0, input: conditionInput };
            
                    let excludedColors = [$scope.visualIfDesc.elseIfThens[index].colorId];
            
                    if (index < $scope.visualIfDesc.elseIfThens.length - 1) {
                        excludedColors.push($scope.visualIfDesc.elseIfThens[index + 1].colorId);
                    }
            
                    let availableColors = colors.filter(color => !excludedColors.includes(color));
                    colorId = _.sample(availableColors);
                }
            
                let elseifThen = {
                    "filter": {
                        "enabled": "true",
                        "distinct": "true",
                        "uiData": {
                            "conditions": [newCondition],
                            "mode": "&&"
                        }
                    },
                    "actions": [],
                    "colorId": colorId
                };
            
                $scope.visualIfDesc.elseIfThens.splice(index + 1, 0, elseifThen);
            };
            

            $scope.addElse = function() {
                $scope.visualIfDesc.elseActions.push({"outputColumnName": "", "operator": "ASSIGN_VALUE", "value": "", "column": $scope.currentStepSchema.columns[0].name, "formula": ""});
            }

            $scope.deleteElseIf = function(index) {
                $scope.visualIfDesc.elseIfThens.splice(index, 1);
            }

            $scope.deleteFirstIf = function() {
                $scope.visualIfDesc.ifThen.filter = angular.copy($scope.visualIfDesc.elseIfThens[0].filter);
                $scope.visualIfDesc.ifThen.actions = angular.copy($scope.visualIfDesc.elseIfThens[0].actions);
                $scope.visualIfDesc.elseIfThens.splice(0, 1);
            }

            $scope.previewChanges = function() {
                $scope.$parent.step.params.visualIfDesc = angular.copy($scope.visualIfDesc);
                $scope.$parent.checkAndRefresh();
            }

            $scope.closeEditor = function() {
                $rootScope.$broadcast("dismissModalInternal_");
                $rootScope.$broadcast("resetModalShownInternal_");
            }

            $scope.convertToFormulaStep = function() {
                // What a nasty hack to get the `shakerWithProcessors` scope.
                // We should really use a service to share data between components.
                // I am doing it here because I don't want to break the current architecture.
                // Note that this will break if the component is not nested in the shakerWithProcessors component.
                DataikuAPI.shakers.convertVisualIf($stateParams.projectKey, $scope.visualIfDesc, $scope.columns)
                .success((data) => {
                    const stepId = ShakerService.findStepId($scope, $scope.step);
                    let insertIndex = stepId?.id;
                    if (stepId != null) {
                        insertIndex++;
                    }
                    const convertedStep = $scope.$parent.addUnconfiguredStep('CreateColumnWithGREL', {
                        column: $scope.visualIfDesc.ifThen.actions[0].outputColumnName,
                        expression: data,
                    }, insertIndex, false);
                    $scope.applyChanges();
                    if (!$scope.step.disabled) {
                        $scope.$parent.toggleDisable($scope.step);
                    }
                })
                .error(setErrorInScope.bind($scope));
            }

            // Visual if can be converted to formula if all actions have the same output column name
            $scope.isFormulaConvertable = function() {
                const outputColumnName = $scope.visualIfDesc.ifThen.actions[0]?.outputColumnName;
                if (!$scope.visualIfDesc.elseIfThens.every(
                        elseifThen => elseifThen.actions.every(action => action.outputColumnName === outputColumnName)
                    )
                ) {
                    return false;
                }
                return $scope.visualIfDesc.elseActions.every(action => action.outputColumnName === outputColumnName);
            }

            $scope.applyChanges = function() {
                $scope.previewChanges();
                $scope.closeEditor();
            }

            $scope.findDuplicates = function(listOfActions) {
                let outputColumnNames = listOfActions.map(action => action.outputColumnName).filter(element => {
                                                                                                    return !["", undefined].includes(element);});
                let outputColumnNamesDeduplicate = new Set(outputColumnNames);
                return outputColumnNames.length !== outputColumnNamesDeduplicate.size;
            }

            $scope.multipleReferences = function() {
                let hasMultipleReferences = false;
                if ($scope.$parent.modalShown) {
                    hasMultipleReferences = $scope.findDuplicates($scope.visualIfDesc.ifThen.actions);
                    if (hasMultipleReferences) {
                        return true;
                    }
                    let i = 0;
                    let elseIfThens = angular.copy($scope.visualIfDesc.elseIfThens);
                    while (!hasMultipleReferences && i < elseIfThens.length && elseIfThens.length!==0){
                        hasMultipleReferences = $scope.findDuplicates(elseIfThens[i].actions);
                        i+=1;
                    }
                    if (hasMultipleReferences) {
                        return true;
                    }
                    let elseActions = angular.copy($scope.visualIfDesc.elseActions);
                    if (!hasMultipleReferences && elseActions.length!==0) {
                        hasMultipleReferences = $scope.findDuplicates(elseActions);
                    }
                }
                return hasMultipleReferences;
            };

            $scope.$watch("visualIfDesc.ifThen.filter.uiData.conditions", function(nv, ov) {
                   if(ov.length===0 || (ov===nv && ov.length===1)){
                    $scope.previewChanges();
                }
            });

        }
    };
    angular.module("dataiku.processors").component("visualIfEditor", visualIfEditor);
})();
