(function(){
    'use strict';

    const geoPreviewMapContent = {
        bindings : {
            onPopupCreated: "=",
            cellValue : "<",
            popupContainer: "=" 
        },
        templateUrl : "static/dataiku/shared/components/geo-preview-component/geo-preview.component.html",
        controller: function ($element, DataikuAPI, ChartsStaticData, ColorUtils, WT1, BuiltinMapBackgrounds){
            const $ctrl = this;
            $ctrl.$onInit = () => {
                
                WT1.event("geo-preview-popup-displayed");

                $ctrl.failure = false;
                DataikuAPI.shakers.convertCellValueToGeoJSON($ctrl.cellValue)
                .then((res) => {
                    $ctrl.failure = false;   
                    const cellGeometry = JSON.parse(res.data);
                    const background = BuiltinMapBackgrounds.getBackgrounds()[0];
                    const pointToLayer = (feature, coordinates) => {
                        return new L.circleMarker(coordinates);
                    };
                    const singleColor = ColorUtils.toRgba(ChartsStaticData.DEFAULT_COLOR_OPTIONS.singleColor,  ChartsStaticData.DEFAULT_COLOR_OPTIONS.transparency);
                    const previewMapStyle = {
                            weight: ChartsStaticData.DEFAULT_STROKE_WIDTH,
                            color: singleColor, 
                            fillColor: singleColor,
                            fillOpacity:  ChartsStaticData.DEFAULT_FILL_OPACITY,
                            opacity: 1
                    };
                    const dataLayer = L.geoJson(cellGeometry, { style: previewMapStyle, pointToLayer: pointToLayer });
                    
                    // prevents error popup from being resized from a 300-height square to a 200-height rectangle
                    // leaflet doesn't work correctly with map containers hiding and resizing
                    $element.find(".geo-preview-component__map-content").css("display", "block");
                    const mapContainer = $element.find(".map-container");
                    const map = L.map(mapContainer[0]).setView([0, 0], 0);
                    const tileLayer = background.getTileLayer();
                    
                    map.addLayer(tileLayer);
                    map.addLayer(dataLayer);
                    
                    map.fitBounds(dataLayer, { animate: false, padding: [20, 20] });
                    if(cellGeometry && cellGeometry.type === "Point") {
                        map.setZoom(15, { animate: false });
                    }

                    if($ctrl.popupContainer.setPopupClosable && $ctrl.popupContainer.setPopupNotClosable) {
                        map.on("movestart", $ctrl.popupContainer.setPopupNotClosable);
                        map.on("moveend", () => {
                            setTimeout($ctrl.popupContainer.setPopupClosable, 50);
                        });
                    }
                }).catch((err) => {
                    $ctrl.failure = true;
                    const warningMessageTemplate = "No preview : {0}";
                    if(!err.data) {
                        // not an error from the server
                        $ctrl.warningMessage = warningMessageTemplate.format("an unknown error occured");
                    } else {
                        $ctrl.warningMessage = warningMessageTemplate.format(err.data.message);
                    }
                }).finally(() => {
                    $ctrl.popupContainer.onPopupCreated && $ctrl.popupContainer.onPopupCreated();
                });
            };
        }
    }

    angular.module('dataiku.shared').component('geoPreviewMapContent', geoPreviewMapContent);
})();