import os, json

class CodeStudioBlock(object):
    """The base interface for a Python CodeStudio block"""

    def __init__(self, config, plugin_config):
        """
        :param config: the dict of the configuration of the object
        :param plugin_config: contains the plugin settings
        """
        self.config = config
        self.plugin_config = plugin_config

    def build_spec(self, spec, env):  # NOSONAR - not static, will be overridden
        """
        Apply the block to the spec
        
        The input is the spec as it was computed from the previous blocks and the environment
        in which the build is done. The output should be a new spec (or a modification of the
        input out). See :func:`dataiku.code_studio.CodeStudioTemplate.build_spec`
                
        :param spec: the current state of the CodeStudio template image spec
        :param env: the build env

        :returns: the updated spec, ie a dict with a field 'dockerfile'
        """
        return spec

    def build_launch(self, spec, env):  # NOSONAR - not static, will be overridden
        """
        Apply the block to the spec
        
        The input is the spec as it was computed from the previous blocks and the environment
        in which the build is done. The output should be a new spec (or a modification of the
        input out). See :func:`dataiku.code_studio.CodeStudioTemplate.build_launch`
        
        :param spec: the current state of the CodeStudio launch spec
        :param env: the launch env

        :returns: the updated spec, as a dict
        """
        return spec

    def build_creation(self, spec, env):  # NOSONAR - not static, will be overridden
        """
        Apply the block to the spec
        
        The input is the spec as it was computed from the previous blocks and the environment
        in which the build is done. The output should be a new spec (or a modification of the
        input out). See :func:`dataiku.code_studio.CodeStudioTemplate.build_creation`
        
        :param spec: the current state of the CodeStudio creation spec
        :param env: the creation env

        :returns: the updated spec, as a dict
        """
        return spec
        