h2o_algo_map = {
    'DEEP_LEARNING_H2O': 'DeepLearning',
    'GBM_H2O': 'GBM',
    'DISTRIBUTED_RF_H2O': 'DRF',
    'GLM_H2O': 'GLM2'
}

h2o_parameters = {
    'DeepLearning': {
        'destination_key': None,
        'source': None,
        'ignored_cols': None,
        'validation': None,
        'classification': None,
        'response': None,
        'expert_mode': None,
        'activation': None,
        'hidden': None,
        'epochs': None,
        'train_samples_per_iteration': None,
        'seed': None,
        'adaptive_rate': None,
        'rho': None,
        'epsilon': None,
        'rate': None,
        'rate_annealing': None,
        'rate_decay': None,
        'momentum_start': None,
        'momentum_ramp': None,
        'momentum_stable': None,
        'nesterov_accelerated_gradient': None,
        'input_dropout_ratio': None,
        'hidden_dropout_ratios': None,
        'l1': None,
        'l2': None,
        'max_w2': None,
        'initial_weight_distribution': None,
        'initial_weight_scale': None,
        'loss': None,
        'score_interval': None,
        'score_training_samples': None,
        'score_validation_samples': None,
        'score_duty_cycle': None,
        'classification_stop': None,
        'regression_stop': None,
        'quiet_mode': None,
        'max_confusion_matrix_size': None,
        'max_hit_ratio_k': None,
        'balance_classes': None,
        'max_after_balance_size': None,
        'score_validation_sampling': None,
        'diagnostics': None,
        'variable_importances': None,
        'fast_mode': None,
        'ignore_const_cols': None,
        'force_load_balance': None,
        'replicate_training_data': None,
        'single_node_mode': None,
        'shuffle_training_data': None,
    },
    'GBM': {
        'destination_key': None,
        'validation': None,
        'response': None,
        'source': None,
        'learn_rate': None,
        'ntrees': None,
        'max_depth': None,
        'min_rows': None,
        'ignored_cols_by_name': None,  # either this or cols..not both
        'cols': None,
        'nbins': None,
        'classification': None,
        'score_each_iteration': None,
        'grid_parallelism': None,
    },
    'DRF': {
        'destination_key': None,
        'source': None,
        # 'model': None,
        'response': None,
        'cols': None,
        'ignored_cols_by_name': None,
        'classification': 1,
        'validation': None,
        'importance': 1,  # enable variable importance by default
        'ntrees': None,
        'max_depth': None,
        'min_rows': None,  # how many rows in leaves for stopping condition
        'nbins': None,
        'mtries': None,
        'sample_rate': None,
        'seed': None,
        'build_tree_per_node': None,
        'score_each_iteration': None,
    },
    'GLM2': {
        'source': None,
        'destination_key': None,
        'response': None,
        # what about cols? doesn't exist?
        # what about ignored_cols_by_name
        'ignored_cols': None,
        'max_iter': None,
        'standardize': None,
        'family': None,
        # 'link': None, # apparently we don't get this for GLM2
        'alphas': 'alpha',
        'lambdas': 'lambda',
        'beta_epsilon': None,  # GLMGrid doesn't use this name
        'tweedie_variance_power': None,
        'n_folds': None,
        # 'weight': None,
        # 'thresholds': None,
        # only GLMGrid has this..we should complain about it on GLM?
        'parallelism': None,
        'beta_eps': None,
        'higher_accuracy': None,
        'use_all_factor_levels': None,
        'lambda_search': None,
    }
}