import gluonts

from dataiku.base.utils import package_is_at_least


def instantiate_identity_predictor(frequency, prediction_length, num_samples=1):
    from gluonts.model.trivial.identity import IdentityPredictor
    if package_is_at_least(gluonts, "0.10.0"):
        # Starting from 0.10.0 the freq argument has been removed
        return IdentityPredictor(
            prediction_length=prediction_length, num_samples=num_samples
        )
    else:
        return IdentityPredictor(
            freq=frequency, prediction_length=prediction_length, num_samples=num_samples
        )

