import pandas as pd

from dataiku.base.utils import package_is_at_least

def _groupby_compat(identifiers):
    """ Passing a length-1 list to groupby() can have two return types: scalar before pandas 2, tuple starting with 2.0
    see https://github.com/pandas-dev/pandas/issues/42795#issuecomment-1367406391
    """
    if package_is_at_least(pd, "2") and len(identifiers) == 1:
        return identifiers[0]
    return identifiers

def str_to_datetime_compat(data):
    if package_is_at_least(pd, "2.0"):
        return pd.to_datetime(data, utc=True, format='mixed')
    elif package_is_at_least(pd, "1.5"):
        return pd.to_datetime(data, utc=True)
    else:
        # Prevent the following error when calling
        # pd.to_datetime with a pd.Categorical as argument
        # > TypeError: Argument 'date_string' has incorrect type (expected str, got numpy.str_)
        #
        # This is a known issue, fixed in Pandas 1.5
        # https://github.com/pandas-dev/pandas/pull/45280
        data_as_str = data.astype(str)

        # Make sure all the dates are processed in UTC.
        return pd.to_datetime(data_as_str, utc=True)