import sys
from abc import abstractmethod


class BaseWriter(object):
    NAME = "INPUT_BASE_WRITER"

    def __init__(self, client):
        self.client = client

    def compute_request_size(self, input_df):
        return sys.getsizeof(self.build_request_payload(input_df))

    @abstractmethod
    def build_request_payload(self, input_df):
        raise NotImplementedError

    @abstractmethod
    def can_write(self, input_df):
        raise NotImplementedError

    @abstractmethod
    def write(self, input_df):
        raise NotImplementedError
