import os, json

class BaseAgentTool(object):
    """The base interface for a code-based agent tool"""

    def __init__(self):
        pass

    def get_descriptor(self, tool):
        """
        Returns the descriptor of the tool, as a dict containing:
           - description (str)
           - inputSchema (dict, a JSON Schema representation)
        """
        pass


    def invoke(self, input, trace):
        """
        Invokes the tool.

        The arguments of the tool invocation are in input["input"], a dict
        """
        pass


    def load_sample_query(self, tool):
        """
        Returns a sample query for the test panel in the Agent tool page.

        Optional function.

        The sample should be returned as a dict in the same format as input["input"]
        received in `invoke` function.
        """
        pass
